/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.knife4j.gateway.config;

import cn.fscode.commons.knife4j.gateway.config.Knife4jExtProperties;
import cn.fscode.commons.tool.core.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
@Primary
public class SwaggerResourceConfig
implements SwaggerResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(SwaggerResourceConfig.class);
    private final RouteLocator routeLocator;
    private final GatewayProperties gatewayProperties;
    private final Knife4jExtProperties knife4JExtProperties;
    public static final String API_URI = "v2/api-docs";

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        ArrayList routes = new ArrayList();
        this.routeLocator.getRoutes().subscribe(route -> routes.add(route.getId()));
        this.gatewayProperties.getRoutes().stream().filter(routeDefinition -> routes.contains(routeDefinition.getId())).forEach(route -> route.getPredicates().stream().filter(predicateDefinition -> {
            Map args = predicateDefinition.getArgs();
            Set entries = args.entrySet();
            for (Map.Entry entry : entries) {
                String value = (String)entry.getValue();
                List<String> excludeUris = this.knife4JExtProperties.getExcludeUri();
                for (String excludeUri : excludeUris) {
                    if (!StringUtils.matches((String)excludeUri, Collections.singletonList(value))) continue;
                    return false;
                }
            }
            return "Path".equalsIgnoreCase(predicateDefinition.getName());
        }).forEach(predicateDefinition -> resources.add(this.swaggerResource(route.getId(), ((String)predicateDefinition.getArgs().get("_genkey_0")).replace("**", API_URI)))));
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        log.info("name: {}, location: {}", (Object)name, (Object)location);
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    public SwaggerResourceConfig(RouteLocator routeLocator, GatewayProperties gatewayProperties, Knife4jExtProperties knife4JExtProperties) {
        this.routeLocator = routeLocator;
        this.gatewayProperties = gatewayProperties;
        this.knife4JExtProperties = knife4JExtProperties;
    }
}

