package cn.fscode.commons.knife4j.gateway.config;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Description:
 *
 * @author shenguangyang
 */
@Configuration
@EnableOpenApi
@EnableKnife4j
public class Knife4jConfig {

    @Resource
    private Knife4jExtProperties knife4JExtProperties;

    @Bean //配置docket以配置Swagger具体参数
    @ConditionalOnMissingBean
    public Docket docket(Environment environment, List<RequestParameter> globalRequestParameters) {
        if (globalRequestParameters == null) {
            globalRequestParameters = new ArrayList<>();
        }
        return new Docket(DocumentationType.OAS_30)
                .globalRequestParameters(globalRequestParameters)
                // 配置是否启用Swagger，如果是false，在浏览器将无法访问
                .enable(knife4JExtProperties.getEnable())
                // 以下是一组的
                // 通过.select()方法，去配置扫描接口,RequestHandlerSelectors配置如何扫描接口
                .select()
                // 配置如何通过path过滤,即这里只扫描请求以/api开头的接口
                // .paths(PathSelectors.ant("/api/**"))
                .build();
    }
}
