package cn.fscode.commons.knife4j.gateway;

import cn.fscode.commons.knife4j.gateway.config.Knife4jConfig;
import cn.fscode.commons.knife4j.gateway.config.Knife4jExtProperties;
import cn.fscode.commons.knife4j.gateway.config.SwaggerResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@AutoConfiguration
@Import({SwaggerHandler.class, SwaggerHeaderFilter.class, SwaggerResourceConfig.class})
@ImportAutoConfiguration(Knife4jConfig.class)
@EnableConfigurationProperties({Knife4jExtProperties.class})
public class CommonsKnife4jGatewayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CommonsKnife4jGatewayAutoConfiguration.class);
    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
        log.info("gateway api doc url [{}]", "http://gateway-host:port/doc.html");
    }
}
