/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import cn.fscode.commons.database.sql.init.BaseDataSourceInit;
import cn.fscode.commons.database.sql.init.DatasourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;

public class MysqlDataSourceInit
extends BaseDataSourceInit {
    private static final Logger log = LoggerFactory.getLogger(MysqlDataSourceInit.class);

    @Override
    public DatabaseType type() {
        return DatabaseType.MYSQL;
    }

    @Override
    public void customDataSource(DataSourceBuilder<?> dataSourceBuilder, DatasourceConfig datasourceConfig) {
        String notDbJdbcUrl = datasourceConfig.getJdbcUrl().replace("/" + this.getDbNameFromUrl(datasourceConfig.getJdbcUrl()), "");
        dataSourceBuilder.url(notDbJdbcUrl);
    }

    private String getDbNameFromUrl(String url) {
        String regex;
        url = url.substring(url.indexOf("//") + 2);
        url = url.substring(url.indexOf("/") + 1);
        int i = url.indexOf("?");
        String dbName = "";
        dbName = i != -1 ? url.substring(0, i) : url;
        if (dbName.matches(regex = "^.*(=|&|/|\\\\).*$")) {
            throw new RuntimeException("url [ " + dbName + " ] is illegal");
        }
        return dbName;
    }
}

