/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database.sql.init;

public class DatasourceConfig {
    private String jdbcUrl;
    private String username;
    private String password;
    private String driverClassName;
    private String sqlScript;

    public static DatasourceConfigBuilder builder() {
        return new DatasourceConfigBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getSqlScript() {
        return this.sqlScript;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setSqlScript(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public String toString() {
        return "DatasourceConfig(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", sqlScript=" + this.getSqlScript() + ")";
    }

    public DatasourceConfig(String jdbcUrl, String username, String password, String driverClassName, String sqlScript) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
        this.sqlScript = sqlScript;
    }

    public static class DatasourceConfigBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String driverClassName;
        private String sqlScript;

        DatasourceConfigBuilder() {
        }

        public DatasourceConfigBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public DatasourceConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public DatasourceConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DatasourceConfigBuilder driverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public DatasourceConfigBuilder sqlScript(String sqlScript) {
            this.sqlScript = sqlScript;
            return this;
        }

        public DatasourceConfig build() {
            return new DatasourceConfig(this.jdbcUrl, this.username, this.password, this.driverClassName, this.sqlScript);
        }

        public String toString() {
            return "DatasourceConfig.DatasourceConfigBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", driverClassName=" + this.driverClassName + ", sqlScript=" + this.sqlScript + ")";
        }
    }
}

