/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.PcSqlProperties;
import cn.fscode.commons.database.sql.init.DataSourceFactory;
import cn.fscode.commons.database.sql.init.DatasourceConfig;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DatabaseInitPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitPostProcessor.class);
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        List<PcSqlProperties.Helper> helperList = PcSqlProperties.Helper.build(this.environment);
        for (PcSqlProperties.Helper helper : helperList) {
            if (!helper.enabled().booleanValue()) {
                return;
            }
            try {
                DatasourceConfig datasourceConfig = helper.getDatasourceConfig();
                DataSourceFactory.create().get(datasourceConfig).execScript(datasourceConfig);
            }
            catch (Exception e) {
                throw new RuntimeException(StrUtil.format((CharSequence)"database create failed, errorMessage [{}]", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

