/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import cn.fscode.commons.database.sql.init.DatasourceConfig;
import cn.fscode.commons.tool.core.StringUtils;
import cn.hutool.core.io.resource.ResourceUtil;
import com.alibaba.fastjson2.JSON;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class BaseDataSourceInit {
    private static final Logger log = LoggerFactory.getLogger(BaseDataSourceInit.class);

    public abstract DatabaseType type();

    public void execScript(DatasourceConfig req) throws Exception {
        if (StringUtils.isEmpty((String)req.getSqlScript())) {
            return;
        }
        Class.forName(req.getDriverClassName());
        DataSource dataSource = this.initDataSource(req);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String sqlContent = ResourceUtil.readStr((String)req.getSqlScript(), (Charset)StandardCharsets.UTF_8);
        log.info("datasource config: {}", (Object)JSON.toJSONString((Object)req));
        String[] split = sqlContent.split(";");
        Arrays.stream(split).filter(StringUtils::isNotEmpty).forEach(arg_0 -> ((JdbcTemplate)jdbcTemplate).execute(arg_0));
        log.info("exec sql script [{}] success", (Object)req.getSqlScript());
    }

    private DataSource initDataSource(DatasourceConfig req) throws Exception {
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        dataSourceBuilder.username(req.getUsername()).password(req.getPassword()).driverClassName(req.getDriverClassName()).url(req.getJdbcUrl());
        this.customDataSource(dataSourceBuilder, req);
        return dataSourceBuilder.build();
    }

    protected abstract void customDataSource(DataSourceBuilder<?> var1, DatasourceConfig var2);
}

