package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.PcSqlProperties;
import cn.hutool.core.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import java.util.List;

/**
 * @author shenguangyang
 */
public class DatabaseInitPostProcessor implements BeanDefinitionRegistryPostProcessor, EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitPostProcessor.class);
    private Environment environment;
    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        List<PcSqlProperties.Helper> helperList = PcSqlProperties.Helper.build(environment);
        for (PcSqlProperties.Helper helper : helperList) {
            if (!helper.enabled()) {
                return;
            }

            try {
                DatasourceConfig datasourceConfig = helper.getDatasourceConfig();
                DataSourceFactory.create().get(datasourceConfig).execScript(datasourceConfig);
            } catch (Exception e) {
                throw new RuntimeException(StrUtil.format("database create failed, errorMessage [{}]", e.getMessage()));
            }
        }

    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {

    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}
