package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import cn.fscode.commons.tool.core.StringUtils;
import cn.hutool.core.io.resource.ResourceUtil;
import com.alibaba.fastjson2.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

/**
 * @author shenguangyang
 */
@Slf4j
public abstract class BaseDataSourceInit {
    public abstract DatabaseType type();
    public void execScript(DatasourceConfig req) throws Exception {
        if (StringUtils.isEmpty(req.getSqlScript())) {
            return;
        }
        Class.forName(req.getDriverClassName());
        DataSource dataSource = initDataSource(req);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String sqlContent = ResourceUtil.readStr(req.getSqlScript(), StandardCharsets.UTF_8);
        log.info("datasource config: {}", JSON.toJSONString(req));
        String[] split = sqlContent.split(";");
        Arrays.stream(split).filter(StringUtils::isNotEmpty).forEach(jdbcTemplate::execute);
        log.info("exec sql script [{}] success", req.getSqlScript());
    }

    private DataSource initDataSource(DatasourceConfig req) throws Exception {
        DataSourceBuilder<?> dataSourceBuilder = DataSourceBuilder.create();
        dataSourceBuilder.username(req.getUsername())
                .password(req.getPassword())
                .driverClassName(req.getDriverClassName())
                .url(req.getJdbcUrl());
        customDataSource(dataSourceBuilder, req);
        return dataSourceBuilder.build();
    }
    protected abstract void customDataSource(DataSourceBuilder<?> dataSourceBuilder, DatasourceConfig datasourceConfig);
}
