/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import cn.fscode.commons.database.sql.init.BaseDataSourceInit;
import cn.fscode.commons.database.sql.init.DatasourceConfig;
import cn.fscode.commons.tool.core.exception.Assert;
import cn.fscode.commons.tool.core.exception.BizException;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DataSourceFactory {
    private final Map<DatabaseType, BaseDataSourceInit> map = new ConcurrentHashMap<DatabaseType, BaseDataSourceInit>();

    private DataSourceFactory() {
    }

    public static DataSourceFactory create() {
        DataSourceFactory dataSourceFactory = new DataSourceFactory();
        Reflections reflection = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{Scanners.SubTypes}).setUrls(ClasspathHelper.forPackage((String)"cn.fscode.commons.database.sql.init", (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage("cn.fscode.commons.database.sql.init")));
        Set subTypesOf = reflection.getSubTypesOf(BaseDataSourceInit.class);
        for (Class item : subTypesOf) {
            try {
                BaseDataSourceInit baseDataSourceInit = (BaseDataSourceInit)item.newInstance();
                dataSourceFactory.map.put(baseDataSourceInit.type(), baseDataSourceInit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dataSourceFactory;
    }

    public BaseDataSourceInit get(DatasourceConfig datasourceConfig) {
        Assert.notNull((Object)datasourceConfig.getJdbcUrl(), (String)"spring.datasource.url is null or spring.datasource.dynamic.datasource.{key}.url is null");
        for (DatabaseType value : DatabaseType.values()) {
            if (!StrUtil.containsAnyIgnoreCase((CharSequence)datasourceConfig.getJdbcUrl(), (CharSequence[])new CharSequence[]{value.getType()}) || !this.map.containsKey((Object)value)) continue;
            return this.map.get((Object)value);
        }
        throw new BizException((CharSequence)"not supported jdbcUrl: {}", new Object[]{datasourceConfig.getJdbcUrl()});
    }
}

