/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.database;

import cn.fscode.commons.database.sql.init.DatasourceConfig;
import cn.fscode.commons.tool.core.StringUtils;
import cn.fscode.commons.tool.core.exception.Assert;
import cn.fscode.commons.tool.core.exception.BizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;

@ConfigurationProperties(prefix="project-commons.sql")
public class PcSqlProperties {
    private List<Init> inits;

    public List<Init> getInits() {
        return this.inits;
    }

    public void setInits(List<Init> inits) {
        this.inits = inits;
    }

    public static class Helper {
        private Environment environment;
        private String envIndex = "";
        private String itemKeyPre;
        private static String KEY_PRE = "project-commons.sql.inits";

        public Helper(Environment environment, String envIndex) {
            this.environment = environment;
            this.envIndex = envIndex;
            this.itemKeyPre = "project-commons.sql.inits" + this.envIndex;
            Assert.notNull((Object)environment, (String)"environment is null");
            Assert.notNull((Object)environment, (String)"envIndex is null");
        }

        public static List<Helper> build(Environment environment) {
            ArrayList<Helper> helpers = new ArrayList<Helper>();
            AbstractEnvironment aEnv = (AbstractEnvironment)environment;
            MutablePropertySources propertySources = aEnv.getPropertySources();
            propertySources.forEach(propertySource -> {
                if (propertySource instanceof MapPropertySource) {
                    MapPropertySource mps = (MapPropertySource)propertySource;
                    Set keys = ((Map)mps.getSource()).keySet();
                    HashMap<String, String> temp = new HashMap<String, String>();
                    for (String key : keys) {
                        String envIndex;
                        if (!key.startsWith(KEY_PRE) || temp.containsKey(envIndex = key.replace(KEY_PRE, "").split("\\.")[0])) continue;
                        temp.put(envIndex, "");
                        helpers.add(new Helper(environment, envIndex));
                    }
                }
            });
            return helpers;
        }

        public Boolean enabled() {
            return Boolean.parseBoolean(this.environment.getProperty(this.itemKeyPre + ".enabled", "false"));
        }

        public String getUseDatasource() {
            return this.environment.getProperty(this.itemKeyPre + ".use-datasource", "");
        }

        public String getSqlScript() {
            return this.environment.getProperty(this.itemKeyPre + ".sql-script", "");
        }

        public DatasourceConfig getDatasourceConfig() {
            DatasourceConfig.DatasourceConfigBuilder builder = DatasourceConfig.builder();
            String useDatasource = this.getUseDatasource();
            if (StringUtils.isNotEmpty((String)useDatasource)) {
                String driverClassName = this.environment.getProperty("spring.datasource.dynamic.datasource." + useDatasource + ".driver-class-name");
                if (Objects.isNull(driverClassName)) {
                    throw new BizException((CharSequence)"sql init fail, use datasource [{}] not exist", new Object[]{useDatasource});
                }
                builder.driverClassName(driverClassName).username(this.environment.getProperty("spring.datasource.dynamic.datasource." + useDatasource + ".username")).password(this.environment.getProperty("spring.datasource.dynamic.datasource." + useDatasource + ".password")).jdbcUrl(this.environment.getProperty("spring.datasource.dynamic.datasource." + useDatasource + ".url"));
            } else {
                String driverClassName = this.environment.getProperty("spring.datasource.driver-class-name");
                if (Objects.isNull(driverClassName)) {
                    throw new BizException("sql init fail, please config [spring.datasource.driver-class-name] or config [" + this.itemKeyPre + ".use-datasource] to specify the data source");
                }
                builder.driverClassName(this.environment.getProperty("spring.datasource.driver-class-name")).jdbcUrl(this.environment.getProperty("spring.datasource.url")).username(this.environment.getProperty("spring.datasource.username")).password(this.environment.getProperty("spring.datasource.password"));
            }
            builder.sqlScript(this.getSqlScript());
            return builder.build();
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public String getEnvIndex() {
            return this.envIndex;
        }

        public String getItemKeyPre() {
            return this.itemKeyPre;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void setEnvIndex(String envIndex) {
            this.envIndex = envIndex;
        }

        public void setItemKeyPre(String itemKeyPre) {
            this.itemKeyPre = itemKeyPre;
        }
    }

    public static class Init {
        private Boolean enabled = Boolean.FALSE;
        private String useDatasource = "";
        private String sqlScript;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getUseDatasource() {
            return this.useDatasource;
        }

        public String getSqlScript() {
            return this.sqlScript;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setUseDatasource(String useDatasource) {
            this.useDatasource = useDatasource;
        }

        public void setSqlScript(String sqlScript) {
            this.sqlScript = sqlScript;
        }
    }
}

