package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.jdbc.DataSourceBuilder;

/**
 * @author shenguangyang
 */
@Slf4j
public class MysqlDataSourceInit extends BaseDataSourceInit {

    @Override
    public DatabaseType type() {
        return DatabaseType.MYSQL;
    }

    @Override
    public void customDataSource(DataSourceBuilder<?> dataSourceBuilder, DatasourceConfig datasourceConfig) {
        // 去掉jdbcUrl中的数据库
        String notDbJdbcUrl = datasourceConfig.getJdbcUrl()
                .replace("/" + getDbNameFromUrl(datasourceConfig.getJdbcUrl()),"");
        // logger.info("去掉数据库名后的jdbcUrl [{}]",notDbJdbcUrl);
        dataSourceBuilder.url(notDbJdbcUrl);
    }

    /**
     * 从url中获取数据库名称
     * @param url jdbc:mysql://192.168.116.131:53306/ums1?useUnicode=true&characterEncoding=utf8&characterSetResults=utf8&serverTimezone=Asia/Shanghai
     * @return ums1
     */
    private String getDbNameFromUrl(String url) {
        url = url.substring(url.indexOf("//") + 2);
        url= url.substring(url.indexOf("/")  +1);
        int i = url.indexOf("?");
        String dbName = "";
        dbName = i != -1 ? url.substring(0, i) : url;

        //意思是:  匹配不含这些特殊字符的其他任意一个或多个字符
        String regex = "^.*(=|&|/|\\\\).*$";
        if (dbName.matches(regex)) {
            throw new RuntimeException("url [ " + dbName + " ] is illegal");
        }
        return dbName;
    }
}
