package cn.fscode.commons.database.sql.init;

import cn.fscode.commons.database.DatabaseType;
import cn.fscode.commons.tool.core.exception.Assert;
import cn.fscode.commons.tool.core.exception.BizException;
import cn.hutool.core.util.StrUtil;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author shenguangyang
 */
public class DataSourceFactory {
    private final Map<DatabaseType, BaseDataSourceInit> map = new ConcurrentHashMap<>();

    private DataSourceFactory() {

    }

    public static DataSourceFactory create() {
        DataSourceFactory dataSourceFactory = new DataSourceFactory();
        Reflections reflection = new Reflections(new ConfigurationBuilder()
                .setScanners(Scanners.SubTypes)
                .setUrls(ClasspathHelper.forPackage("cn.fscode.commons.database.sql.init"))
                .filterInputsBy(new FilterBuilder().includePackage("cn.fscode.commons.database.sql.init")));
        Set<Class<? extends BaseDataSourceInit>> subTypesOf = reflection.getSubTypesOf(BaseDataSourceInit.class);
        for (Class<? extends BaseDataSourceInit> item : subTypesOf) {
            try {
                BaseDataSourceInit baseDataSourceInit = item.newInstance();
                dataSourceFactory.map.put(baseDataSourceInit.type(), baseDataSourceInit);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dataSourceFactory;
    }

    public BaseDataSourceInit get(DatasourceConfig datasourceConfig) {
        Assert.notNull(datasourceConfig.getJdbcUrl(),
                "spring.datasource.url is null or spring.datasource.dynamic.datasource.{key}.url is null");
        for (DatabaseType value : DatabaseType.values()) {
            if (StrUtil.containsAnyIgnoreCase(datasourceConfig.getJdbcUrl(), value.getType()) && map.containsKey(value)) {
                return map.get(value);
            }
        }
        throw new BizException("not supported jdbcUrl: {}", datasourceConfig.getJdbcUrl());
    }
}
