package cn.fscode.commons.database;

import cn.fscode.commons.database.sql.init.DataSourceFactory;
import cn.fscode.commons.database.sql.init.DatabaseInitPostProcessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@Slf4j
@Import({
        DatabaseInitPostProcessor.class, DataSourceFactory.class
})
@AutoConfiguration
@EnableConfigurationProperties({PcSqlProperties.class})
public class DatabaseAutoConfiguration {
   @PostConstruct
    public void init() {
       log.info("init {}", this.getClass().getName());
   }
}
