/*
 * Decompiled with CFR 0.152.
 */
package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.Cal;
import cn.freelancy.sxtwl4j.ChineseFestivals;
import cn.freelancy.sxtwl4j.Common;
import cn.freelancy.sxtwl4j.JD;
import cn.freelancy.sxtwl4j.LunarData;
import cn.freelancy.sxtwl4j.SSQ;
import cn.freelancy.sxtwl4j.WesternFestivals;
import cn.freelancy.sxtwl4j.XL;
import cn.freelancy.sxtwl4j.bean.Day;
import cn.freelancy.sxtwl4j.bean.LunarMonth;
import cn.freelancy.sxtwl4j.bean.LunarYear;
import cn.freelancy.sxtwl4j.bean.SolarMonth;
import cn.freelancy.sxtwl4j.bean.SolarYear;
import cn.freelancy.sxtwl4j.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class Lunar {
    private static final String FIRST_MONTH_NAME = "\u6b63\u6708";
    private static final String LAST_MONTH_NAME = "\u814a\u6708";
    private LunarData[] lun;
    private double w0;
    private int y;
    private int m;
    private int d0;
    private int dn;
    private String Ly;
    private String ShX;
    private String nianhao;

    public Lunar() {
        this.resetLun();
    }

    private void resetLun() {
        this.lun = new LunarData[31];
        for (int i = 0; i < this.lun.length; ++i) {
            this.lun[i] = new LunarData();
        }
    }

    public SolarYear getSolarYear(int solarYear) {
        SolarYear sy = new SolarYear();
        List<Day> allDays = this.getFullDaysBySolarYear(solarYear);
        ArrayList<SolarMonth> allMonths = new ArrayList<SolarMonth>();
        for (int i = 1; i <= 12; ++i) {
            SolarMonth solarMonth = new SolarMonth();
            solarMonth.setYear(solarYear);
            solarMonth.setMonth(i);
            Integer month = i;
            ArrayList<Day> days = new ArrayList<Day>();
            for (Day day : allDays) {
                if (!month.equals(day.getSolarMonth())) continue;
                days.add(day);
            }
            solarMonth.setAllDays(days);
            allMonths.add(solarMonth);
        }
        sy.setAllDays(allDays);
        sy.setYear(solarYear);
        sy.setAllMonths(allMonths);
        return sy;
    }

    public LunarYear getLunarYear(int lunarYear) {
        LunarYear ly = new LunarYear();
        List<Day> allDays = this.getFullDaysByLunarYear(lunarYear);
        List<String> allMonthName = this.getLunarStrFromDaysList(allDays);
        ly.setAllDays(allDays);
        ly.setAllMonthsName(allMonthName);
        ly.setYear(lunarYear);
        ArrayList<LunarMonth> lunarMonths = new ArrayList<LunarMonth>();
        for (String s : allMonthName) {
            LunarMonth lunarMonth = new LunarMonth();
            lunarMonth.setYear(lunarYear);
            lunarMonth.setMonth(s);
            ArrayList<Day> days = new ArrayList<Day>();
            for (Day day : allDays) {
                if (!s.equals(day.getLunarMonth())) continue;
                days.add(day);
            }
            lunarMonth.setAllDays(days);
            lunarMonths.add(lunarMonth);
        }
        ly.setAllMonths(lunarMonths);
        return ly;
    }

    public List<Day> getFullDaysBySolarYear(int yearOfSolar) {
        ArrayList<Day> days = new ArrayList<Day>();
        for (int i = 1; i <= 12; ++i) {
            days.addAll(this.getDaysByYearAndMonth(yearOfSolar, i));
        }
        return days;
    }

    public List<Day> getFullDaysByLunarYear(int lunarYear) {
        int i;
        int solarYear = lunarYear;
        ArrayList<Day> days = new ArrayList<Day>();
        for (i = 1; i < 13; ++i) {
            days.addAll(this.getDaysByYearAndMonth(solarYear, i));
        }
        for (i = 1; i < 5; ++i) {
            days.addAll(this.getDaysByYearAndMonth(solarYear + 1, i));
        }
        int firstIndex = 0;
        Day firstDay = null;
        for (Day day : days) {
            if (!day.getLunarMonth().contains(FIRST_MONTH_NAME)) continue;
            firstDay = day;
            break;
        }
        if (null != firstDay) {
            firstIndex = days.indexOf(firstDay);
        }
        int lastIndex = this.getLastDayIndexOfCurrYear(days);
        return days.subList(firstIndex, lastIndex + 1);
    }

    private int getLastDayIndexOfCurrYear(List<Day> days) {
        int index = 0;
        for (int i = days.size() - 1; i >= 0; --i) {
            if (!days.get(i).getLunarMonth().contains(LAST_MONTH_NAME)) continue;
            index = i;
            break;
        }
        return index;
    }

    private List<String> getLunarStrFromDaysList(List<Day> days) {
        ArrayList<String> months = new ArrayList<String>();
        for (Day day : days) {
            if (months.contains(day.getLunarMonth())) continue;
            months.add(day.getLunarMonth());
        }
        return months;
    }

    public Day getDay(int solarYear, int solarMonth, int solarDay) {
        List<Day> days = this.getFullDaysBySolarYear(solarYear);
        for (Day day : days) {
            if (null == day || day.getSolarYear() != solarYear || day.getSolarMonth() != solarMonth || day.getSolarDay() != solarDay) continue;
            return day;
        }
        return null;
    }

    public List<Day> getDaysByYearAndMonth(int By, int Bm) {
        this.yueLiCalc(By, Bm);
        ArrayList<Day> days = new ArrayList<Day>();
        for (LunarData lunarData : this.lun) {
            if (!this.isLunarDataNotEmpty(lunarData)) continue;
            Day day = new Day();
            day.setSolarYear(lunarData.getY());
            day.setSolarMonth(lunarData.getM());
            day.setSolarDay(lunarData.getD());
            day.setLunarYear(lunarData.getY());
            if (lunarData.getM() < 4 && (lunarData.getLmc().contains("\u814a") || lunarData.getLmc().contains("\u51ac") || lunarData.getLmc().contains("\u5341"))) {
                day.setLunarYear(lunarData.getY() - 1);
            }
            day.setLunarMonth(lunarData.getLleap() + lunarData.getLmc() + "\u6708");
            day.setLunarDay(lunarData.getLdc());
            day.setFestival(lunarData.getA());
            day.setJieQi(lunarData.getLjq());
            day.setJieQiName(lunarData.getJqmc());
            day.setJieQiTime(lunarData.getJqsj());
            days.add(day);
        }
        return days;
    }

    public List<String> get24JieQiByYear(int solarYear) {
        List<Day> days = this.getFullDaysBySolarYear(solarYear);
        ArrayList<String> jieQi24 = new ArrayList<String>();
        for (Day day : days) {
            if (null == day.getJieQiName() || "".equals(day.getJieQiName())) continue;
            jieQi24.add(day.getSolarYear() + "-" + day.getSolarMonth() + "-" + day.getSolarDay() + " " + day.getJieQiTime());
        }
        return jieQi24;
    }

    private boolean isLunarDataNotEmpty(LunarData lunarData) {
        return null != lunarData && lunarData.getY() != 0;
    }

    private String subStr2(String s, int n, String end) {
        if ((s = s.trim()).length() > n + 1) {
            return s.substring(0, n) + end;
        }
        return s;
    }

    private void yueLiCalc(int By, int Bm) {
        LunarData ob;
        int xn;
        double d;
        double D;
        this.resetLun();
        WesternFestivals oba = new WesternFestivals();
        SSQ ssq = new SSQ();
        ChineseFestivals obb = new ChineseFestivals();
        JD.h = 12;
        JD.m = 0;
        JD.s = 0.1;
        JD.Y = By;
        JD.M = Bm;
        JD.D = 1;
        int Bd0 = (int)((double)NumberUtil.int2(JD.toJd()) - Common.J2000);
        if (++JD.M > 12) {
            ++JD.Y;
            JD.M = 1;
        }
        int Bdn = (int)((double)NumberUtil.int2(JD.toJd()) - Common.J2000 - (double)Bd0);
        this.w0 = ((double)Bd0 + Common.J2000 + 1.0 + 7000000.0) % 7.0;
        this.y = By;
        this.m = Bm;
        this.d0 = Bd0;
        this.dn = Bdn;
        int c = By - 1984 + 12000;
        this.Ly = ChineseFestivals.GAN[c % 10] + "" + ChineseFestivals.ZHI[c % 12];
        this.ShX = ChineseFestivals.SH_X[c % 12];
        this.nianhao = obb.getNH(By);
        int j = 0;
        for (int i = 0; i < Bdn; ++i) {
            int mk;
            LunarData ob2 = this.lun[i];
            ob2.d0 = Bd0 + i;
            ob2.di = i;
            ob2.y = By;
            ob2.m = Bm;
            ob2.dn = Bdn;
            ob2.week0 = this.w0;
            ob2.week = (this.w0 + (double)i) % 7.0;
            ob2.weeki = NumberUtil.int2((this.w0 + (double)i) / 7.0);
            ob2.weekN = NumberUtil.int2((this.w0 + (double)Bdn - 1.0) / 7.0) + 1;
            JD.setFromJD((int)((double)ob2.d0 + Common.J2000));
            ob2.d = JD.D;
            if (ssq.getZQ().length == 0 || (double)ob2.d0 < ssq.getZQ()[0] || (double)ob2.d0 >= ssq.getZQ()[24]) {
                ssq.calcY(ob2.d0);
            }
            if ((mk = NumberUtil.int2(((double)ob2.d0 - ssq.getHS()[0]) / 30.0)) < 13 && ssq.getHS()[mk + 1] <= (double)ob2.d0) {
                ++mk;
            }
            ob2.Ldi = (double)ob2.d0 - ssq.getHS()[mk];
            ob2.Ldc = ChineseFestivals.R_M_C[(int)ob2.Ldi];
            ob2.cur_dz = (double)ob2.d0 - ssq.getZQ()[0];
            ob2.cur_xz = (double)ob2.d0 - ssq.getZQ()[12];
            ob2.cur_lq = (double)ob2.d0 - ssq.getZQ()[15];
            ob2.cur_mz = (double)ob2.d0 - ssq.getZQ()[11];
            ob2.cur_xs = (double)ob2.d0 - ssq.getZQ()[13];
            if ((double)ob2.d0 == ssq.getHS()[mk] || ob2.d0 == Bd0) {
                ob2.Lmc = ssq.getYm()[mk];
                ob2.Ldn = ssq.getDx()[mk];
                ob2.Lleap = ssq.getLeap() != 0 && ssq.getLeap() == mk ? "\u95f0" : "";
                ob2.Lmc2 = mk < 13 ? ssq.getYm()[mk + 1] : "\u672a\u77e5";
            } else {
                LunarData ob22 = this.lun[i - 1];
                ob2.Lmc = ob22.Lmc;
                ob2.Ldn = ob22.Ldn;
                ob2.Lleap = ob22.Lleap;
                ob2.Lmc2 = ob22.Lmc2;
            }
            int qk = NumberUtil.int2(((double)ob2.d0 - ssq.getZQ()[0] - 7.0) / 15.2184);
            if (qk < 23 && (double)ob2.d0 >= ssq.getZQ()[qk + 1]) {
                ++qk;
            }
            ob2.Ljq = (double)ob2.d0 == ssq.getZQ()[qk] ? ChineseFestivals.J_Q_M_C[qk] : "";
            Cal cal = new Cal(By, Bm);
            if (Bm == 12 && i == 28) {
                System.out.println("a");
            }
            ob2.dtpq = Common.Dtlpq(ob2, qk, cal);
            ob2.yxmc = ob2.yxjd = (ob2.yxsj = "");
            ob2.jqmc = ob2.jqjd = (ob2.jqsj = "");
            D = ssq.getZQ()[3] + (double)((double)ob2.d0 < ssq.getZQ()[3] ? -365 : 0) + 5844.0 - 35.0;
            ob2.Lyear = Math.floor(D / 365.2422 + 0.5);
            D = ssq.getHS()[2];
            for (j = 0; j < 14; ++j) {
                if (!ssq.getYm()[j].equals("\u6b63") || ssq.getLeap() == j && j != 0 || !((double)ob2.d0 < (D = ssq.getHS()[j]))) continue;
                D -= 365.0;
                break;
            }
            ob2.Lyear0 = Math.floor((D += 5810.0) / 365.2422 + 0.5);
            D = ob2.Lyear + 12000.0;
            ob2.Lyear2 = ChineseFestivals.GAN[(int)(D % 10.0)] + "" + ChineseFestivals.ZHI[(int)(D % 12.0)];
            D = ob2.Lyear0 + 12000.0;
            ob2.Lyear3 = ChineseFestivals.GAN[(int)(D % 10.0)] + "" + ChineseFestivals.ZHI[(int)(D % 12.0)];
            ob2.Lyear4 = ob2.Lyear0 + 1984.0 + 2698.0;
            mk = NumberUtil.int2(((double)ob2.d0 - ssq.getZQ()[0]) / 30.43685);
            if (mk < 12 && (double)ob2.d0 >= ssq.getZQ()[2 * mk + 1]) {
                ++mk;
            }
            D = mk + NumberUtil.int2((ssq.getZQ()[12] + 390.0) / 365.2422) * 12 + 900000;
            ob2.Lmonth = D % 12.0;
            ob2.Lmonth2 = ChineseFestivals.GAN[(int)(D % 10.0)] + "" + ChineseFestivals.ZHI[(int)(D % 12.0)];
            D = ob2.d0 - 6 + 9000000;
            ob2.Lday2 = ChineseFestivals.GAN[(int)(D % 10.0)] + "" + ChineseFestivals.ZHI[(int)(D % 12.0)];
            mk = NumberUtil.int2(((double)ob2.d0 - ssq.getZQ()[0] - 15.0) / 30.43685);
            if (mk < 11 && (double)ob2.d0 >= ssq.getZQ()[2 * mk + 2]) {
                ++mk;
            }
            ob2.XiZ = ChineseFestivals.XI_Z[(mk + 12) % 12] + '\u5ea7';
            oba.getHuiLi(ob2.d0, ob2);
            ob2.A = ob2.B = (ob2.C = "");
            ob2.Fjia = 0;
            oba.getDayName(ob2, ob2);
            obb.getDayName(ob2, ob2);
        }
        double jd2 = (double)Bd0 + Common.dtT(Bd0) - 0.3333333333333333;
        double w = XL.MSALon(jd2 / 36525.0, 10, 3);
        w = (double)NumberUtil.int2((w - 0.78) / Math.PI * 2.0) * Math.PI / 2.0;
        do {
            d = obb.so_accurate(w);
            D = NumberUtil.int2(d + 0.5);
            xn = NumberUtil.int2(w / Common.pi2 * 4.0 + 4000000.01) % 4;
            w += Common.pi2 / 4.0;
            if (D >= (double)(Bd0 + Bdn)) break;
            if (D < (double)Bd0) continue;
            ob = this.lun[(int)(D - (double)Bd0)];
            ob.yxmc = ChineseFestivals.Y_X_M_C[xn];
            ob.yxjd = String.valueOf(d);
            ob.yxsj = JD.timeStr(d);
        } while (D + 5.0 < (double)(Bd0 + Bdn));
        w = XL.SALon(jd2 / 36525.0, 3);
        w = (double)NumberUtil.int2((w - 0.13) / Common.pi2 * 24.0) * Common.pi2 / 24.0;
        do {
            d = obb.qi_accurate(w);
            D = NumberUtil.int2(d + 0.5);
            xn = NumberUtil.int2(w / Common.pi2 * 24.0 + 2.400000601E7) % 24;
            w += Common.pi2 / 24.0;
            if (D >= (double)(Bd0 + Bdn)) break;
            if (D < (double)Bd0) continue;
            ob = this.lun[(int)(D - (double)Bd0)];
            ob.jqmc = ChineseFestivals.J_Q_M_C[xn];
            ob.jqjd = String.valueOf(d);
            ob.jqsj = JD.timeStr(d);
        } while (D + 12.0 < (double)(Bd0 + Bdn));
    }

    public String yueLiHTML(int By, int Bm, int curJD) {
        int i;
        String sty_head = " style=\"font-family: \u5b8b\u4f53; font-size: 14px; text-align: center; background-color: #E0E0FF; color: #000000; font-weight: bold\" ";
        String sty_body = " style=\"font-family: \u5b8b\u4f53; font-size: 12px; text-align: center \" ";
        String sty_date = " style=\"font-family: Arial Black; text-align: center;font-size: 20px\" ";
        String sty_date2 = " style=\"font-family: Arial Black; text-align: center;font-size: 20px; color: #FF0000\" ";
        String sty_cur = " style=\"background-color:#90D050\" ";
        String cr = "";
        this.yueLiCalc(By, Bm);
        String c = this.nianhao + " \u519c\u5386" + this.Ly + "\u5e74\u3010" + this.ShX + "\u5e74\u3011";
        c = c.length() > 33 ? "<span style=\"font-size:12px\">" + c + "</span>" : "<span style=\"font-size:16px;font-weight:bold\">" + c + "</span>";
        String ta0 = "<tr><td colspan=7 style=\"background-color:#00AFFF\" style=\"color=#FFFF00\">" + c + "</td></tr>";
        ta0 = ta0 + "<tr><td" + sty_head + "width=\"%14\">\u65e5</td><td" + sty_head + "width=\"%14\">\u4e00</td><td" + sty_head + "width=\"%14\">\u4e8c</td><td" + sty_head + "width=\"%14\">\u4e09</td><td" + sty_head + "width=\"%14\">\u56db</td><td" + sty_head + "width=\"%14\">\u4e94</td><td" + sty_head + "width=\"%14\">\u516d</td></tr>";
        for (i = 0; i < this.dn; ++i) {
            int j;
            LunarData ob = this.lun[i];
            if (i != 0) {
                j = 0;
                while ((double)j < this.w0) {
                    cr = cr + "<td" + sty_body + "></td>";
                    ++j;
                }
            }
            c = "";
            String isM = "";
            if (ob.A != null && !"".equals(ob.A)) {
                c = c + "<font color=red>" + this.subStr2(ob.A, 4, "..") + "</font>";
            }
            if ((c == null || "".equals(c)) && ob.B != null && !"".equals(ob.B)) {
                c = "<font color=blue>" + this.subStr2(ob.B, 4, "..") + "</font>";
            }
            if ((c == null || "".equals(c)) && "\u521d\u4e00".equals(ob.Ldc)) {
                c = ob.Lleap + ob.Lmc + "\u6708" + (ob.Ldn == 30.0 ? "\u5927" : "\u5c0f");
            }
            if (c == null || "".equals(c)) {
                c = ob.Ldc;
            }
            if (ob.yxmc.equals("\u6714")) {
                isM = "<font color=#505000>\u25cf</font>";
            }
            if (ob.yxmc.equals("\u671b")) {
                isM = "<font color=#F0B000>\u25cf</font>";
            }
            if (ob.yxmc.equals("\u4e0a\u5f26")) {
                isM = "<font color=#F0B000><b>\u222a</b></font>";
            }
            if (ob.yxmc.equals("\u4e0b\u5f26")) {
                isM = "<font color=#F0B000><b>\u2229</b></font>";
            }
            if (ob.jqmc != null && !"".equals(ob.jqmc)) {
                isM = isM + "<font color=#00C000>\u25c6</font>";
            }
            String c2 = ob.Fjia != 0 ? sty_date2 : sty_date;
            c2 = c2 + " onmouseover=\"showMessD(" + i + ")\"";
            c2 = c2 + " onmouseout =\"showMessD(-1)\"";
            c2 = "<span" + c2 + ">" + ob.d + "<br/>" + ob.Lday2 + "</span>";
            if (ob.d0 == curJD) {
                c2 = "<span" + sty_cur + ">" + c2 + "</span>";
            }
            cr = cr + "<td" + sty_body + "width=\"14%\">" + c2 + "<br>" + isM + c + "</td>";
            if (i == this.dn - 1) {
                j = 0;
                while ((double)j < 6.0 - ob.week) {
                    cr = cr + "<td" + sty_body + "></td>";
                    ++j;
                }
            }
            if (i != this.dn - 1 && ob.week != 6.0) continue;
            ta0 = ta0 + "<tr>" + cr + "</tr>";
            cr = "";
        }
        String pg1 = "<table border=0 cellpadding=3 cellspacing=1 width=\"100%\">" + ta0 + "</table>";
        String b2 = "";
        String b3 = "";
        String b4 = "";
        for (i = 0; i < this.dn; ++i) {
            LunarData ob = this.lun[i];
            if (i + 1 < 10) {
                c = "&nbsp;" + c;
            }
            if (ob.yxmc == "\u6714" || ob.yxmc == "\u671b") {
                b2 = b2 + c + "\u65e5 " + ob.yxsj + ob.yxmc + "\u6708 &nbsp;";
            }
            if (ob.yxmc == "\u4e0a\u5f26" || ob.yxmc == "\u4e0b\u5f26") {
                b3 = b3 + c + "\u65e5 " + ob.yxsj + ob.yxmc + " &nbsp;";
            }
            if (ob.jqmc == null || "".equals(ob.jqmc)) continue;
            b4 = b4 + c + "\u65e5 " + ob.jqsj + ob.jqmc + " &nbsp;";
        }
        String pg2 = b2 + "<br>" + b3 + "<br>" + b4;
        return pg1 + "|" + pg2;
    }
}

