/*
 * Decompiled with CFR 0.152.
 */
package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.Cal;
import cn.freelancy.sxtwl4j.ChineseFestivals;
import cn.freelancy.sxtwl4j.LunarData;
import cn.freelancy.sxtwl4j.util.DataUtil;
import cn.freelancy.sxtwl4j.util.NumberUtil;

public class Common {
    private static final double[] DT_AT = new double[]{-4000.0, 108371.7, -13036.8, 392.0, 0.0, -500.0, 17201.0, -627.82, 16.17, -0.3413, -150.0, 12200.6, -346.41, 5.403, -0.1593, 150.0, 9113.8, -328.13, -1.647, 0.0377, 500.0, 5707.5, -391.41, 0.915, 0.3145, 900.0, 2203.4, -283.45, 13.034, -0.1778, 1300.0, 490.1, -57.35, 2.085, -0.0072, 1600.0, 120.0, -9.81, -1.532, 0.1403, 1700.0, 10.2, -0.91, 0.51, -0.037, 1800.0, 13.4, -0.72, 0.202, -0.0193, 1830.0, 7.8, -1.81, 0.416, -0.0247, 1860.0, 8.3, -0.13, -0.406, 0.0292, 1880.0, -5.4, 0.32, -0.183, 0.0173, 1900.0, -2.3, 2.06, 0.169, -0.0135, 1920.0, 21.2, 1.69, -0.304, 0.0167, 1940.0, 24.2, 1.22, -0.064, 0.0031, 1960.0, 33.2, 0.51, 0.231, -0.0109, 1980.0, 51.0, 1.29, -0.026, 0.0032, 2000.0, 63.87, 0.1, 0.0, 0.0, 2005.0, 64.7, 0.4, 0.0, 0.0, 2015.0, 69.0};
    public static final double[][] XL0 = DataUtil.getDouble2FromRes("XL0.db");
    public static final double[][][] XL1 = DataUtil.getDouble3FromRes("XL1.db");
    public static final double[][] XL0Pluto = DataUtil.getDouble2FromRes("XL0Pluto.db");
    private static final double[] XL0_xzb = new double[]{-0.08631, 3.9E-4, -8.0E-5, -0.07447, 6.0E-5, 1.7E-4, -0.07135, -2.6E-4, -0.00176, -0.20239, 0.00273, -0.00347, -0.25486, 0.00276, 0.42926, 0.24588, 0.00345, -14.46266, -0.95116, 0.02481, 58.30651};
    private static final double[] nutB = new double[]{2.1824, -33.75705, 3.6E-5, -1720.0, 920.0, 3.5069, 1256.66393, 1.1E-5, -132.0, 57.0, 1.3375, 16799.4182, -5.1E-5, -23.0, 10.0, 4.3649, -67.5141, 7.2E-5, 21.0, -9.0, 0.04, -628.302, 0.0, -14.0, 0.0, 2.36, 8328.691, 0.0, 7.0, 0.0, 3.46, 1884.966, 0.0, -5.0, 2.0, 5.44, 16833.175, 0.0, -4.0, 2.0, 3.69, 25128.11, 0.0, -3.0, 0.0, 3.55, 628.362, 0.0, 2.0, 0.0};
    public static double cs_rEar = 6378.1366;
    public static double cs_rEarA = 0.99834 * cs_rEar;
    public static double cs_ba = 0.99664719;
    public static double cs_ba2 = cs_ba * cs_ba;
    public static double cs_AU = 1.49597870691E8;
    public static double cs_sinP = cs_rEar / cs_AU;
    public static double cs_PI = Math.asin(cs_sinP);
    public static double cs_GS = 299792.458;
    public static double cs_Agx = cs_AU / cs_GS / 86400.0 / 36525.0;
    public static double[] cs_xxHH = new double[]{116.0, 584.0, 780.0, 399.0, 378.0, 370.0, 367.0, 367.0};
    public static String[] xxName = new String[]{"\u5730\u7403", "\u6c34\u661f", "\u91d1\u661f", "\u706b\u661f", "\u6728\u661f", "\u571f\u661f", "\u5929\u738b\u661f", "\u6d77\u738b\u661f", "\u51a5\u738b\u661f"};
    public static double rad = 206264.80624709636;
    public static double radd = 57.29577951308232;
    public static double pi2 = Math.PI * 2;
    public static double pi_2 = 1.5707963267948966;
    public static double J2000 = 2451545.0;
    public static double cs_k = 0.2725076;
    public static double cs_k2 = 0.272281;
    public static double cs_k0 = 109.1222;
    public static double cs_sMoon = cs_k * cs_rEar * 1.0000036 * rad;
    public static double cs_sMoon2 = cs_k2 * cs_rEar * 1.0000036 * rad;
    public static double cs_sSun = 959.64;

    public static double dtT(double t) {
        return Common.dtCalc(t / 365.2425 + 2000.0) / 86400.0;
    }

    private static double dtCalc(double y) {
        int i;
        double y0 = DT_AT[DT_AT.length - 2];
        double t0 = DT_AT[DT_AT.length - 1];
        if (y >= y0) {
            int jsd = 31;
            if (y > y0 + 100.0) {
                return Common.dtExt(y, jsd);
            }
            double v = Common.dtExt(y, jsd);
            double dv = Common.dtExt(y0, jsd) - t0;
            return v - dv * (y0 + 100.0 - y) / 100.0;
        }
        double[] d = DT_AT;
        for (i = 0; i < d.length && !(y < d[i + 5]); i += 5) {
        }
        double t1 = (y - d[i]) / (d[i + 5] - d[i]) * 10.0;
        double t2 = t1 * t1;
        double t3 = t2 * t1;
        return d[i + 1] + d[i + 2] * t1 + d[i + 3] * t2 + d[i + 4] * t3;
    }

    private static double dtExt(double y, int jsd) {
        double dy = (y - 1820.0) / 100.0;
        return -20.0 + (double)jsd * dy * dy;
    }

    public static double XL0Calc(int xt, int zn, double t, int n) {
        t /= 10.0;
        double tn = 1.0;
        double v = 0.0;
        double[] F = XL0[xt];
        int pn = zn * 6 + 1;
        double N0 = F[pn + 1] - F[pn];
        int i = 0;
        while (i < 6) {
            double n2 = F[pn + 1 + i];
            double n1 = F[pn + i];
            double n0 = n2 - n1;
            if (n0 != 0.0) {
                double N;
                if (n < 0) {
                    N = n2;
                } else {
                    N = (double)NumberUtil.int2((double)(3 * n) * n0 / N0 + 0.5) + n1;
                    if (i != 0) {
                        N += 3.0;
                    }
                    if (N > n2) {
                        N = n2;
                    }
                }
                int j = (int)n1;
                double c = 0.0;
                while ((double)j < N) {
                    c += F[j] * Math.cos(F[j + 1] + t * F[j + 2]);
                    j += 3;
                }
                v += c * tn;
            }
            ++i;
            tn *= t;
        }
        v /= F[0];
        if (xt == 0) {
            double t2 = t * t;
            double t3 = t2 * t;
            if (zn == 0) {
                v += (-0.0728 - 2.7702 * t - 1.1019 * t2 - 0.0996 * t3) / rad;
            }
            if (zn == 1) {
                v += (0.0 + 4.0E-4 * t + 4.0E-4 * t2 - 0.0026 * t3) / rad;
            }
            if (zn == 2) {
                v += (-0.002 + 0.0044 * t + 0.0213 * t2 - 0.025 * t3) / 1000000.0;
            }
        } else {
            double dv = XL0_xzb[(xt - 1) * 3 + zn];
            if (zn == 0) {
                v += -3.0 * t / rad;
            }
            v = zn == 2 ? (v += dv / 1000000.0) : (v += dv / rad);
        }
        return v;
    }

    public static double XL1Calc(int zn, double t, int n) {
        double[][] ob = XL1[zn];
        double v = 0.0;
        double tn = 1.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double tx = t - 10.0;
        if (zn == 0) {
            v += (3.81034409 + 8399.684730072 * t - 3.319E-5 * t2 + 3.11E-8 * t3 - 2.033E-10 * t4) * rad;
            v += 5028.792262 * t + 1.1124406 * t2 + 7.699E-5 * t3 - 2.3479E-5 * t4 - 1.78E-8 * t5;
            if (tx > 0.0) {
                v += -0.866 + 1.43 * tx + 0.054 * tx * tx;
            }
        }
        t2 /= 10000.0;
        t3 /= 1.0E8;
        t4 /= 1.0E8;
        if ((n *= 6) < 0) {
            n = ob[0].length;
        }
        int i = 0;
        while (i < ob.length) {
            double[] F = ob[i];
            int N = NumberUtil.int2((double)(n * F.length) / (double)ob[0].length + 0.5);
            if (i != 0) {
                N += 6;
            }
            if (N >= F.length) {
                N = F.length;
            }
            double c = 0.0;
            for (int j = 0; j < N; j += 6) {
                c += F[j] * Math.cos(F[j + 1] + t * F[j + 2] + t2 * F[j + 3] + t3 * F[j + 4] + t4 * F[j + 5]);
            }
            v += c * tn;
            ++i;
            tn *= t;
        }
        if (zn != 2) {
            v /= rad;
        }
        return v;
    }

    public static double gxc_sunLon(double t) {
        double v = -0.043126 + 628.301955 * t - 2.732E-6 * t * t;
        double e = 0.016708634 - 4.2037E-5 * t - 1.267E-7 * t * t;
        return -20.49552 * (1.0 + e * Math.cos(v)) / rad;
    }

    public static double gxc_moonLon() {
        return -3.4E-6;
    }

    public static double nutationLon2(double t) {
        double t2 = t * t;
        double dL = 0.0;
        double[] B = nutB;
        for (int i = 0; i < B.length; i += 5) {
            double a = i == 0 ? -1.742 * t : 0.0;
            dL += (B[i + 3] + a) * Math.sin(B[i] + B[i + 1] * t + B[i + 2] * t2);
        }
        return dL / 100.0 / rad;
    }

    public static String Dtlpq(LunarData ld, int pjqn, Cal cal) {
        ld.setY(Common.year2Ayear(cal.getCalY()));
        String s = "";
        if (ld.getY() < 1582 || ld.getY() > 1644 || ld.getY() == 1644 && cal.getCalM() - 0 == 12) {
            return s;
        }
        double yearshi = 365.2425;
        double qiying = 55.06;
        double qice = yearshi / 24.0;
        double pqrgz = ((double)(ld.getY() - 1281) * yearshi + qiying + (double)pjqn * qice) % 60.0;
        char pqrtg = ChineseFestivals.GAN[(10 + NumberUtil.int2(pqrgz) % 10) % 10];
        char pqrdz = ChineseFestivals.ZHI[(12 + NumberUtil.int2(pqrgz) % 12) % 12];
        s = s + pqrtg + pqrdz + "\u65e5 ";
        double pqrhh = (pqrgz - (double)NumberUtil.int2(pqrgz)) * 24.0;
        char pqrsc = ChineseFestivals.ZHI[(12 + NumberUtil.parseInt((pqrhh + 1.0) / 2.0)) % 12];
        String pqrsd = ChineseFestivals.S_C_D[NumberUtil.parseInt(pqrhh) % 2];
        double pqrmm = (pqrhh - (double)NumberUtil.int2(pqrhh)) * 60.0;
        String pqrsk = ChineseFestivals.TIME_K[NumberUtil.parseInt(pqrmm / 14.4)];
        s = s + pqrsc + pqrsd + ' ' + pqrsk + '\u523b' + ' ' + ChineseFestivals.J_Q_M_C[pjqn] + "|" + ChineseFestivals.Y_M_C[(NumberUtil.parseInt((double)(pjqn + 1) / 2.0) + 12) % 12] + '\u6708' + ChineseFestivals.J_Q_J_L[pjqn % 2];
        return s;
    }

    public static int year2Ayear(int y) {
        return y >= -4712 && y <= 9999 ? y : 0;
    }

    public static double pty_zty2(double t) {
        double L = (1.753470142E9 + 6.283319653318E11 * t + 5296.74 * t * t) / 1.0E9 + Math.PI;
        double[] z = new double[3];
        double E = (84381.4088 - 46.836051 * t) / rad;
        z[0] = Common.XL0Calc(0, 0, t, 5) + Math.PI;
        z[1] = 0.0;
        z = Common.llrConv(z, E);
        L = Common.rad2rrad(L - z[0]);
        return L / pi2;
    }

    public static double[] llrConv(double[] JW, double E) {
        double[] r = new double[3];
        double J = JW[0];
        double W = JW[1];
        r[0] = NumberUtil.atan2(NumberUtil.sin(J) * NumberUtil.cos(E) - NumberUtil.tan(W) * NumberUtil.sin(E), NumberUtil.cos(J));
        r[1] = NumberUtil.asin(NumberUtil.cos(E) * NumberUtil.sin(W) + NumberUtil.sin(E) * NumberUtil.cos(W) * NumberUtil.sin(J));
        r[2] = JW[2];
        r[0] = Common.rad2mrad(r[0]);
        return r;
    }

    private static double rad2rrad(double v) {
        if ((v %= Math.PI * 2) <= -Math.PI) {
            return v + Math.PI * 2;
        }
        if (v > Math.PI) {
            return v - Math.PI * 2;
        }
        return v;
    }

    private static double rad2mrad(double v) {
        if ((v %= Math.PI * 2) < 0.0) {
            return v + Math.PI * 2;
        }
        return v;
    }
}

