/*
 * Decompiled with CFR 0.152.
 */
package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.ChineseFestivals;
import cn.freelancy.sxtwl4j.Common;
import cn.freelancy.sxtwl4j.JD;
import cn.freelancy.sxtwl4j.Lunar;
import cn.freelancy.sxtwl4j.bean.Day;
import cn.freelancy.sxtwl4j.util.NumberUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaZi {
    public static final char[][] SHI_SHEN = new char[][]{{'\u6bd4', '\u52ab', '\u98df', '\u4f24', '\u624d', '\u8d22', '\u6740', '\u5b98', '\u67ad', '\u5370'}, {'\u52ab', '\u6bd4', '\u4f24', '\u98df', '\u8d22', '\u624d', '\u5b98', '\u6740', '\u5370', '\u67ad'}, {'\u67ad', '\u5370', '\u6bd4', '\u52ab', '\u98df', '\u4f24', '\u624d', '\u8d22', '\u6740', '\u5b98'}, {'\u5370', '\u67ad', '\u52ab', '\u6bd4', '\u4f24', '\u98df', '\u8d22', '\u624d', '\u5b98', '\u6740'}, {'\u6740', '\u5b98', '\u67ad', '\u5370', '\u6bd4', '\u52ab', '\u98df', '\u4f24', '\u624d', '\u8d22'}, {'\u5b98', '\u6740', '\u5370', '\u67ad', '\u52ab', '\u6bd4', '\u4f24', '\u98df', '\u8d22', '\u624d'}, {'\u624d', '\u8d22', '\u6740', '\u5b98', '\u67ad', '\u5370', '\u6bd4', '\u52ab', '\u98df', '\u4f24'}, {'\u8d22', '\u624d', '\u5b98', '\u6740', '\u5370', '\u67ad', '\u52ab', '\u6bd4', '\u4f24', '\u98df'}, {'\u98df', '\u4f24', '\u624d', '\u8d22', '\u6740', '\u5b98', '\u67ad', '\u5370', '\u6bd4', '\u52ab'}, {'\u4f24', '\u98df', '\u8d22', '\u624d', '\u5b98', '\u6740', '\u5370', '\u67ad', '\u52ab', '\u6bd4'}};
    public static final int[] tenElements = new int[]{1, 3, 5, 7, 9, 0, 2, 4, 6, 8};
    public static final Map<Character, Integer> getIndexByGanOrZhi = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('\u7532'), tenElements[2]);
            this.put(Character.valueOf('\u4e59'), tenElements[7]);
            this.put(Character.valueOf('\u4e19'), tenElements[3]);
            this.put(Character.valueOf('\u4e01'), tenElements[8]);
            this.put(Character.valueOf('\u620a'), tenElements[4]);
            this.put(Character.valueOf('\u5df1'), tenElements[9]);
            this.put(Character.valueOf('\u5e9a'), tenElements[0]);
            this.put(Character.valueOf('\u8f9b'), tenElements[5]);
            this.put(Character.valueOf('\u58ec'), tenElements[1]);
            this.put(Character.valueOf('\u7678'), tenElements[6]);
            this.put(Character.valueOf('\u5b50'), tenElements[1]);
            this.put(Character.valueOf('\u4e11'), tenElements[9]);
            this.put(Character.valueOf('\u5bc5'), tenElements[2]);
            this.put(Character.valueOf('\u536f'), tenElements[7]);
            this.put(Character.valueOf('\u8fb0'), tenElements[4]);
            this.put(Character.valueOf('\u5df3'), tenElements[8]);
            this.put(Character.valueOf('\u5348'), tenElements[3]);
            this.put(Character.valueOf('\u672a'), tenElements[9]);
            this.put(Character.valueOf('\u7533'), tenElements[0]);
            this.put(Character.valueOf('\u9149'), tenElements[5]);
            this.put(Character.valueOf('\u620c'), tenElements[4]);
            this.put(Character.valueOf('\u4ea5'), tenElements[6]);
        }
    };
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private char nianGan;
    private char nianZhi;
    private char yueGan;
    private char yueZhi;
    private char riGan;
    private char riZhi;
    private char shiGan;
    private char shiZhi;
    private String trueSolarTime;
    private String jiShi;
    private String riBiao;
    private String shiBiao;
    private String naYin4Year;
    private String naYin4Month;
    private String naYin4Day;
    private String naYin4Hour;
    private String naYin;
    private Date birthDay;
    private int solarYear;
    private int lunarYear;

    public BaZi(int year, int month, int day, int hour, int minute, int second, double longitude, int curTZ) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, minute, second);
        this.birthDay = calendar.getTime();
        this.solarYear = year;
        Lunar lunar = new Lunar();
        Day detailDay = lunar.getDay(year, month, day);
        this.lunarYear = null != detailDay ? detailDay.getLunarYear() : year;
        ChineseFestivals chineseFestivals = new ChineseFestivals();
        double t = (double)hour + (double)minute / 60.0 + (double)second / 3600.0;
        double jd = JD.jd(Common.year2Ayear(year), month, (double)day + t / 24.0);
        chineseFestivals.mingLiBaZi(jd + (double)curTZ / 24.0 - Common.J2000, longitude / Common.radd, this);
        this.riBiao = "\u516c\u5386 " + year + "-" + month + "-" + day + " \u5112\u7565\u65e5\u6570 " + NumberUtil.int2(jd + 0.5) + " \u8ddd2000\u5e74\u9996" + NumberUtil.int2(jd + 0.5 - Common.J2000) + "\u65e5";
        this.shiBiao = "23\u3000 01\u3000 03\u3000 05\u3000 07\u3000 09\u3000 11\u3000 13\u3000 15\u3000 17\u3000 19\u3000 21\u3000 23";
    }

    public static char getShiShenByRiGanAndOther(char riGan, char other) {
        int ri = getIndexByGanOrZhi.get(Character.valueOf(riGan));
        int ot = getIndexByGanOrZhi.get(Character.valueOf(other));
        return SHI_SHEN[ri][ot];
    }

    private static int getIndexOfTheYear(Calendar calInput, String[] jqStrings) {
        Date date;
        int i;
        for (i = 0; i < jqStrings.length && (date = BaZi.getDateByStr(jqStrings[i])).getTime() < calInput.getTimeInMillis(); ++i) {
        }
        return i - 1;
    }

    private static Date getDateByStr(String dateStr) {
        try {
            return SIMPLE_DATE_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private static int indexOf(char[] array, char valueToFind) {
        return BaZi.indexOf(array, valueToFind, 0);
    }

    private static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public String getBaZi() {
        return new String(new char[]{this.nianGan, this.nianZhi, this.yueGan, this.yueZhi, this.riGan, this.riZhi, this.shiGan, this.shiZhi});
    }

    public List<String> getDaYunByGender(int gender) {
        int defaultSize = 8;
        return this.getDaYunByGender(gender, defaultSize);
    }

    public List<String> getDaYunByGender(int gender, int size) {
        ArrayList<String> daYun = new ArrayList<String>();
        int monthGan = BaZi.indexOf(ChineseFestivals.GAN, this.yueGan);
        int monthZhi = BaZi.indexOf(ChineseFestivals.ZHI, this.yueZhi);
        if (this.isPaiDaYunDirPositive(gender, this.nianGan)) {
            for (int i = 0; i < size; ++i) {
                daYun.add(ChineseFestivals.GAN[++monthGan % 10] + "" + ChineseFestivals.ZHI[++monthZhi % 12]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                daYun.add(ChineseFestivals.GAN[(--monthGan + 10) % 10] + "" + ChineseFestivals.ZHI[(--monthZhi + 12) % 12]);
            }
        }
        return daYun;
    }

    private boolean isPaiDaYunDirPositive(int gender, char nianGan) {
        return this.isTianGanYang(nianGan) && gender == 1 || !this.isTianGanYang(nianGan) && gender == 0;
    }

    private boolean isTianGanYang(char tianGan) {
        return BaZi.indexOf(ChineseFestivals.GAN, tianGan) % 2 == 0;
    }

    private boolean isDiZhiYang(char diZhi) {
        return BaZi.indexOf(ChineseFestivals.ZHI, diZhi) % 2 == 0;
    }

    public String getKongWang() {
        int gan = BaZi.indexOf(ChineseFestivals.GAN, this.riGan);
        int zhi = BaZi.indexOf(ChineseFestivals.ZHI, this.riZhi);
        int kong = (10 - gan - (12 - zhi) + 12) % 12;
        return ChineseFestivals.ZHI[kong] + "" + ChineseFestivals.ZHI[kong + 1];
    }

    public Date getQiYunDate(int gender) {
        try {
            long result;
            Calendar calendar = Calendar.getInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.birthDay);
            String[] jie = this.getThisYearAndNextYearJieWithOutQi();
            int jieQiIndex = BaZi.getIndexOfTheYear(cal, jie);
            if (this.isPaiDaYunDirPositive(gender, this.nianGan)) {
                calendar.setTime(SIMPLE_DATE_FORMAT.parse(jie[jieQiIndex + 1]));
                result = calendar.getTimeInMillis() - cal.getTimeInMillis();
            } else {
                calendar.setTime(SIMPLE_DATE_FORMAT.parse(jie[jieQiIndex]));
                result = cal.getTimeInMillis() - calendar.getTimeInMillis();
            }
            result = result / 0x6DDD00L / 3L;
            cal.add(2, (int)result);
            return cal.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private String[] getThisYearAndNextYearJieWithOutQi() {
        Lunar lunar = new Lunar();
        List<String> jieQi = lunar.get24JieQiByYear(this.lunarYear);
        jieQi.addAll(lunar.get24JieQiByYear(this.lunarYear + 1));
        ArrayList<String> jie = new ArrayList<String>();
        for (String s : jieQi) {
            if (jieQi.indexOf(s) % 2 != 0) continue;
            jie.add(s);
        }
        return jie.subList(0, 12).toArray(new String[0]);
    }

    public char getNianGan() {
        return this.nianGan;
    }

    public void setNianGan(char nianGan) {
        this.nianGan = nianGan;
    }

    public char getNianZhi() {
        return this.nianZhi;
    }

    public void setNianZhi(char nianZhi) {
        this.nianZhi = nianZhi;
    }

    public char getYueGan() {
        return this.yueGan;
    }

    public void setYueGan(char yueGan) {
        this.yueGan = yueGan;
    }

    public char getYueZhi() {
        return this.yueZhi;
    }

    public void setYueZhi(char yueZhi) {
        this.yueZhi = yueZhi;
    }

    public char getRiGan() {
        return this.riGan;
    }

    public void setRiGan(char riGan) {
        this.riGan = riGan;
    }

    public char getRiZhi() {
        return this.riZhi;
    }

    public void setRiZhi(char riZhi) {
        this.riZhi = riZhi;
    }

    public char getShiGan() {
        return this.shiGan;
    }

    public void setShiGan(char shiGan) {
        this.shiGan = shiGan;
    }

    public char getShiZhi() {
        return this.shiZhi;
    }

    public void setShiZhi(char shiZhi) {
        this.shiZhi = shiZhi;
    }

    public String getTrueSolarTime() {
        return this.trueSolarTime;
    }

    public void setTrueSolarTime(String trueSolarTime) {
        this.trueSolarTime = trueSolarTime;
    }

    public String getJiShi() {
        return this.jiShi;
    }

    public void setJiShi(String jiShi) {
        this.jiShi = jiShi;
    }

    public String getRiBiao() {
        return this.riBiao;
    }

    public void setRiBiao(String riBiao) {
        this.riBiao = riBiao;
    }

    public String getShiBiao() {
        return this.shiBiao;
    }

    public void setShiBiao(String shiBiao) {
        this.shiBiao = shiBiao;
    }

    public String getNaYin4Year() {
        return this.naYin4Year;
    }

    public void setNaYin4Year(String naYin4Year) {
        this.naYin4Year = naYin4Year;
    }

    public String getNaYin4Month() {
        return this.naYin4Month;
    }

    public void setNaYin4Month(String naYin4Month) {
        this.naYin4Month = naYin4Month;
    }

    public String getNaYin4Day() {
        return this.naYin4Day;
    }

    public void setNaYin4Day(String naYin4Day) {
        this.naYin4Day = naYin4Day;
    }

    public String getNaYin4Hour() {
        return this.naYin4Hour;
    }

    public void setNaYin4Hour(String naYin4Hour) {
        this.naYin4Hour = naYin4Hour;
    }

    public String getNaYin() {
        return this.naYin;
    }

    public void setNaYin(String naYin) {
        this.naYin = naYin;
    }

    public Date getBirthDay() {
        return this.birthDay;
    }

    public void setBirthDay(Date birthDay) {
        this.birthDay = birthDay;
    }

    public int getSolarYear() {
        return this.solarYear;
    }

    public void setSolarYear(int solarYear) {
        this.solarYear = solarYear;
    }

    public int getLunarYear() {
        return this.lunarYear;
    }

    public void setLunarYear(int lunarYear) {
        this.lunarYear = lunarYear;
    }
}

