package cn.freelancy.sxtwl4j.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Yawei Xi
 */
public class DateUtil {

    private static final Map<Character, Character> CHINESE_YEAR = new HashMap<Character, Character>() {
        {
            put('0', '零');
            put('1', '一');
            put('2', '二');
            put('3', '三');
            put('4', '四');
            put('5', '五');
            put('6', '六');
            put('7', '七');
            put('8', '八');
            put('9', '九');
        }
    };

    /**
     * 通过阿拉伯数字年获取大写的年
     *
     * @param year 阿拉伯数字年
     * @return
     */
    public static String getChineseYearByNumberYear(int year) {
        StringBuilder chineseYear = new StringBuilder();
        String solarYearStr = String.valueOf(year);
        if (solarYearStr.contains("-")) {
            solarYearStr = solarYearStr.replace("-", "");
            chineseYear.append("-");
        }
        for (char c : solarYearStr.toCharArray()) {
            chineseYear.append(CHINESE_YEAR.get(c));
        }
        return chineseYear.toString();
    }
}
