package cn.freelancy.sxtwl4j.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @author Yawei Xi
 * @since 2018-8-13 14:04
 */
public class DataUtil {

    /**
     * 从资源文件中获取二维double数组数据
     *
     * @param resFileName 资源文件名称
     * @return
     */
    public static double[][] getDouble2FromRes(String resFileName) {
        String resFileStr = getResFileStr(resFileName);
        if (null != resFileStr) {
            return convert2Double2(resFileStr);
        } else {
            return new double[0][0];
        }
    }

    /**
     * 从资源文件中获取三维double数组数据
     *
     * @param resFileName 资源文件名称
     * @return
     */
    public static double[][][] getDouble3FromRes(String resFileName) {
        String resFileStr = getResFileStr(resFileName);
        if (null != resFileStr) {
            return convert2Double3(resFileStr);
        } else {
            return new double[0][0][0];
        }
    }

    /**
     * 获取资源文件字符串
     *
     * @param resFileName 资源文件名
     * @return
     */
    private static String getResFileStr(String resFileName) {
        try {
            InputStream is = DataUtil.class.getResourceAsStream("/" + resFileName);
            StringBuilder sb = new StringBuilder();
            String data;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((data = br.readLine()) != null) {
                sb.append(data);
            }
            return sb.toString();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 将二维double数组字符串转为二维double数组
     *
     * @param double2Str 二维double数组字符串
     * @return
     */
    private static double[][] convert2Double2(String double2Str) {
        double2Str = double2Str.replace("{", "[").replace("}", "]");
        return convert2double2(double2Str);
    }

    /**
     * 将三维数组double字符串转为三维double数组
     *
     * @param double3Str 三维double数组字符串
     * @return
     */
    private static double[][][] convert2Double3(String double3Str) {
        double3Str = double3Str.replace("{", "[").replace("}", "]");
        return convert2double3(double3Str);
    }

    /**
     * 将字符串转换为三维double数组
     *
     * @param s 需要转换的字符串
     * @return 三维数组
     */
    private static double[][][] convert2double3(String s) {
        String[] ss = s.replace(" ", "").split("]],");
        double[][][] d3 = new double[ss.length][][];
        for (int i = 0; i < ss.length; i++) {
            String[] sss = ss[i].split("],");
            d3[i] = getDouble2FromStrings(sss);
        }
        return d3;
    }

    /**
     * 将字符串转换为二维double数组
     *
     * @param s 需要转换的字符串
     * @return 二维double数组
     */
    private static double[][] convert2double2(String s) {
        String[] ss = s.replace(" ", "").split("],");
        return getDouble2FromStrings(ss);
    }

    /**
     * 将二维字符串数组，转换为二维double数组
     *
     * @param ss 二维字符串数组
     * @return 二维double数组
     */
    private static double[][] getDouble2FromStrings(String[] ss) {
        double[][] d2 = new double[ss.length][0];
        for (int i = 0; i < ss.length; i++) {
            String[] jj = ss[i].replace("[", "").replace("]", "").split(",");
            double[] d1 = new double[jj.length];
            for (int j = 0; j < jj.length; j++) {
                d1[j] = Double.parseDouble(jj[j]);
            }
            d2[i] = d1;
        }
        return d2;
    }

}
