package cn.freelancy.sxtwl4j.bean;

import java.util.List;

/**
 * @author Yawei Xi
 */
public class SolarYear {
    /**
     * 一年中的所有月（农历）
     */
    private List<SolarMonth> allMonths;
    /**
     * 一年中的所有天
     */
    private List<Day> allDays;
    /**
     * 年
     */
    private int year;

    /**
     * 获取一年中的月数
     *
     * @return 月数
     */
    public int getMonthNum() {
        return 12;
    }

    /**
     * 获取一年中的天数
     *
     * @return 天数
     */
    public int getDayNum() {
        return null != allDays ? allDays.size() : 0;
    }

    public List<SolarMonth> getAllMonths() {
        return allMonths;
    }

    public void setAllMonths(List<SolarMonth> allMonths) {
        this.allMonths = allMonths;
    }

    public List<Day> getAllDays() {
        return allDays;
    }

    public void setAllDays(List<Day> allDays) {
        this.allDays = allDays;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    @Override
    public String toString() {
        return "SolarYear{" +
                "allMonths=" + allMonths +
                ", allDays=" + allDays +
                ", year=" + year +
                '}';
    }
}
