package cn.freelancy.sxtwl4j.bean;

import java.util.List;

/**
 * @author Yawei Xi
 */
public class LunarYear {
    /**
     * 一年中的所有月（农历）
     */
    private List<LunarMonth> allMonths;
    /**
     * 一年中的所有天
     */
    private List<Day> allDays;
    /**
     * 年
     */
    private int year;
    /**
     * 一年中的所有月的农历名称
     */
    private List<String> allMonthsName;

    /**
     * 获取一年中的月数
     *
     * @return 月数
     */
    public int getMonthNum() {
        return null != allMonths ? allMonths.size() : 0;
    }

    /**
     * 获取一年中的天数
     *
     * @return 天数
     */
    public int getDayNum() {
        return null != allDays ? allDays.size() : 0;
    }

    public List<LunarMonth> getAllMonths() {
        return allMonths;
    }

    public void setAllMonths(List<LunarMonth> allMonths) {
        this.allMonths = allMonths;
    }

    public List<Day> getAllDays() {
        return allDays;
    }

    public void setAllDays(List<Day> allDays) {
        this.allDays = allDays;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public List<String> getAllMonthsName() {
        return allMonthsName;
    }

    public void setAllMonthsName(List<String> allMonthsName) {
        this.allMonthsName = allMonthsName;
    }

    @Override
    public String toString() {
        return "LunarYear{" +
                "allMonths=" + allMonths +
                ", allDays=" + allDays +
                ", year='" + year + '\'' +
                '}';
    }
}
