package cn.freelancy.sxtwl4j;

import static cn.freelancy.sxtwl4j.util.NumberUtil.int2;

/**
 * @author Yawei Xi
 * @since 2018-8-8 14:54
 */
public class XL {

    public static double ELon(double t, int n) {
        return Common.XL0Calc(0, 0, t, n);
    }

    public static double MLon(double t, int n) {
        return Common.XL1Calc(0, t, n);
    }

    public static double EV(double t) {
        double f = 628.307585 * t;
        return 628.332 + 21 * Math.sin(1.527 + f) + 0.44 * Math.sin(1.48 + f * 2) + 0.129 * Math.sin(5.82 + f) * t + 0.00055 * Math.sin(4.21 + f) * t * t;
    }

    public static double MV(double t) {
        double v = 8399.71 - 914 * Math.sin(0.7848 + 8328.691425 * t + 0.0001523 * t * t);
        v -= 179 * Math.sin(2.543 + 15542.7543 * t) + 160 * Math.sin(0.1874 + 7214.0629 * t) + 62 * Math.sin(3.14 + 16657.3828 * t) + 34 * Math.sin(4.827 + 16866.9323 * t) + 22 * Math.sin(4.9 + 23871.4457 * t) + 12 * Math.sin(2.59 + 14914.4523 * t) + 7 * Math.sin(0.23 + 6585.7609 * t) + 5 * Math.sin(0.9 + 25195.624 * t) + 5 * Math.sin(2.32 - 7700.3895 * t) + 5 * Math.sin(3.88 + 8956.9934 * t) + 5 * Math.sin(0.49 + 7771.3771 * t);
        return v;
    }

    public static double MSALon(double t, int Mn, int Sn) {
        return MLon(t, Mn) + Common.gxc_moonLon() - (ELon(t, Sn) + Common.gxc_sunLon(t) + Math.PI);
    }

    public static double SALon(double t, int n) {
        return ELon(t, n) + Common.nutationLon2(t) + Common.gxc_sunLon(t) + Math.PI;
    }

    public static double ELonT(double W) {
        double t, v = 628.3319653318;
        t = (W - 1.75347) / v;
        v = EV(t);
        t += (W - ELon(t, 10)) / v;
        v = EV(t);
        t += (W - ELon(t, -1)) / v;
        return t;
    }

    public static double MLonT(double W) {
        double t, v = 8399.70911033384;
        t = (W - 3.81034) / v;
        t += (W - MLon(t, 3)) / v;
        v = MV(t);
        t += (W - MLon(t, 20)) / v;
        t += (W - MLon(t, -1)) / v;
        return t;
    }

    public static double MS_aLon_t(double W) {
        double t, v = 7771.37714500204;
        t = (W + 1.08472) / v;
        t += (W - MSALon(t, 3, 3)) / v;
        v = MV(t) - EV(t);
        t += (W - MSALon(t, 20, 10)) / v;
        t += (W - MSALon(t, -1, 60)) / v;
        return t;
    }

    public static double SALonT(double W) {
        double t, v = 628.3319653318;
        t = (W - 1.75347 - Math.PI) / v;
        v = EV(t);
        t += (W - SALon(t, 10)) / v;
        v = EV(t);
        t += (W - SALon(t, -1)) / v;
        return t;
    }

    public static double MSALonT2(double W) {
        double t, v = 7771.37714500204;
        t = (W + 1.08472) / v;
        double L, t2 = t * t;
        t -= (-0.00003309 * t2 + 0.10976 * Math.cos(0.784758 + 8328.6914246 * t + 0.000152292 * t2) + 0.02224 * Math.cos(0.18740 + 7214.0628654 * t - 0.00021848 * t2) - 0.03342 * Math.cos(4.669257 + 628.307585 * t)) / v;
        L = MLon(t, 20) - (4.8950632 + 628.3319653318 * t + 0.000005297 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 0.0002061 * Math.cos(2.67823 + 628.307585 * t) * t + 0.000349 * Math.cos(4.6261 + 1256.61517 * t) - 20.5 / Common.rad);
        v = 7771.38 - 914 * Math.sin(0.7848 + 8328.691425 * t + 0.0001523 * t * t) - 179 * Math.sin(2.543 + 15542.7543 * t) - 160 * Math.sin(0.1874 + 7214.0629 * t);
        t += (W - L) / v;
        return t;
    }

    public static double SALonT2(double W) {
        double t, L, v = 628.3319653318;
        t = (W - 1.75347 - Math.PI) / v;
        t -= (0.000005297 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 0.0002061 * Math.cos(2.67823 + 628.307585 * t) * t) / v;
        t += (W - ELon(t, 8) - Math.PI + (20.5 + 17.2 * Math.sin(2.1824 - 33.75705 * t)) / Common.rad) / v;
        return t;
    }

    public static double moonIll(double t) {
        double t2 = t * t, t3 = t2 * t, t4 = t3 * t;
        double D, M, m, a, dm = Math.PI / 180;
        D = (297.8502042 + 445267.1115168 * t - 0.0016300 * t2 + t3 / 545868 - t4 / 113065000) * dm;
        M = (357.5291092 + 35999.0502909 * t - 0.0001536 * t2 + t3 / 24490000) * dm;
        m = (134.9634114 + 477198.8676313 * t + 0.0089970 * t2 + t3 / 69699 - t4 / 14712000) * dm;
        a = Math.PI - D + (-6.289 * Math.sin(m) + 2.100 * Math.sin(M) - 1.274 * Math.sin(D * 2 - m) - 0.658 * Math.sin(D * 2) - 0.214 * Math.sin(m * 2) - 0.110 * Math.sin(D)) * dm;
        return (1 + Math.cos(a)) / 2;
    }

    public static double moonRad(double r, double h) {
        return Common.cs_sMoon / r * (1 + Math.sin(h) * Common.cs_rEar / r);
    }

    public static double[] moonMinR(double t, double min) {
        double a = 27.55454988 / 36525, b;
        if (min != 0) {
            b = -10.3302 / 36525;
        } else {
            b = 3.4471 / 36525;
        }
        t = b + a * int2((t - b) / a + 0.5);
        double r1, r2, r3, dt;
        dt = 2 / 36525.0;
        r1 = Common.XL1Calc(2, t - dt, 10);
        r2 = Common.XL1Calc(2, t, 10);
        r3 = Common.XL1Calc(2, t + dt, 10);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        dt = 0.5 / 36525;
        r1 = Common.XL1Calc(2, t - dt, 20);
        r2 = Common.XL1Calc(2, t, 20);
        r3 = Common.XL1Calc(2, t + dt, 20);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        dt = 1200 / 86400.0 / 36525;
        r1 = Common.XL1Calc(2, t - dt, -1);
        r2 = Common.XL1Calc(2, t, -1);
        r3 = Common.XL1Calc(2, t + dt, -1);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        r2 += (r1 - r3) / (r1 + r3 - 2 * r2) * (r3 - r1) / 8;
        double[] re = {t, r2};
        return re;
    }

    public static double[] moonNode(double t, double asc) {
        double a = 27.21222082 / 36525, b;
        if (asc != 0) {
            b = 21 / 36525.0;
        } else {
            b = 35 / 36525.0;
        }
        t = b + a * int2((t - b) / a + 0.5);
        double w, v, w2, dt;
        dt = 0.5 / 36525;
        w = Common.XL1Calc(1, t, 10);
        w2 = Common.XL1Calc(1, t + dt, 10);
        v = (w2 - w) / dt;
        t -= w / v;
        dt = 0.05 / 36525;
        w = Common.XL1Calc(1, t, 40);
        w2 = Common.XL1Calc(1, t + dt, 40);
        v = (w2 - w) / dt;
        t -= w / v;
        w = Common.XL1Calc(1, t, -1);
        t -= w / v;
        double[] re = {t, Common.XL1Calc(0, t, -1)};
        return re;
    }

    public static double[] earthMinR(double t, double min) {
        double a = 365.25963586 / 36525, b;
        if (min != 0) {
            b = 1.7 / 36525;
        } else {
            b = 184.5 / 36525;
        }
        t = b + a * int2((t - b) / a + 0.5);
        double r1, r2, r3, dt;
        dt = 3 / 36525.0;
        r1 = Common.XL0Calc(0, 2, t - dt, 10);
        r2 = Common.XL0Calc(0, 2, t, 10);
        r3 = Common.XL0Calc(0, 2, t + dt, 10);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        dt = 0.2 / 36525;
        r1 = Common.XL0Calc(0, 2, t - dt, 80);
        r2 = Common.XL0Calc(0, 2, t, 80);
        r3 = Common.XL0Calc(0, 2, t + dt, 80);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        dt = 0.01 / 36525;
        r1 = Common.XL0Calc(0, 2, t - dt, -1);
        r2 = Common.XL0Calc(0, 2, t, -1);
        r3 = Common.XL0Calc(0, 2, t + dt, -1);
        t += (r1 - r3) / (r1 + r3 - 2 * r2) * dt / 2;
        r2 += (r1 - r3) / (r1 + r3 - 2 * r2) * (r3 - r1) / 8;
        double[] re = {t, r2};
        return re;
    }
}
