package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.util.NumberUtil;

/**
 * @author Yawei Xi
 * @since 2018-8-9 11:58
 */
public class WesternFestivals {

    private static final String[] wFtv = {"0110.黑人日", "0150I世界麻风日", "0520.国际母亲节", "0530I全国助残日", "0630.父亲节", "0716.合作节", "0730.被奴役国家周", "0911.劳动节", "0932I国际和平日", "0940.国际聋人节 世界儿童日", "0950I世界海事日", "1011.国际住房日", "1013I国际减轻自然灾害日(减灾日)", "1144I感恩节"};
    private String[] sFtv2;
    private String[][] sFtv;

    public WesternFestivals() {
        String s = "01#元旦|" + "02.世界湿地日,07.国际声援南非日,10.国际气象节,14I情人节|" + "01.国际海豹日,03.全国爱耳日,05.1963-9999学雷锋纪念日,08I妇女节,12I植树节,12.1925-9999孙中山逝世纪念日,14.国际警察日," + "15I1983-9999消费者权益日,17.中国国医节,17.国际航海日,21.世界森林日,21.消除种族歧视国际日,21.世界儿歌日,22I世界水日," + "23I世界气象日,24.1982-9999世界防治结核病日,25.全国中小学生安全教育日,30.巴勒斯坦国土日|" + "01I1564-9999愚人节,01.全国爱国卫生运动月(四月),01.税收宣传月(四月),07I世界卫生日,22I世界地球日,23.世界图书和版权日,24.亚非新闻工作者日|" + "01#1889-9999劳动节,04I中国青年节,05.碘缺乏病防治日,08.世界红十字日,09.郝维节,12I国际护士节,15I国际家庭日,17.国际电信日,18.国际博物馆日," + "20.全国学生营养日,23.国际牛奶日,31I世界无烟日|" + "01I1925-9999国际儿童节,05.世界环境保护日,06.全国爱眼日,17.防治荒漠化和干旱日,23.国际奥林匹克日,25.全国土地日,26I国际禁毒日|" + "01I1997-9999香港回归纪念日,01I1921-9999中共诞辰,01.世界建筑日,02.国际体育记者日,07I1937-9999抗日战争纪念日,11I世界人口日,30.非洲妇女日|" + "01I1927-9999中国建军节,08.中国男子节(爸爸节),15.日本正式宣布无条件投降日,16.燕衔泥节|" + "03I1945-9999抗日战争胜利纪念,08.1966-9999国际扫盲日,08.国际新闻工作者日,09.毛泽东逝世纪念,10I中国教师节,14.世界清洁地球日," + "16.国际臭氧层保护日,18I九·一八事变纪念日,20.国际爱牙日,27.世界旅游日,28I孔子诞辰|" + "01#1949-9999国庆节,01.世界音乐日,01.国际老人节,02#1949-9999国庆节假日,02.国际和平与民主自由斗争日,03#1949-9999国庆节假日," + "04.世界动物日,06.老人节,08.全国高血压日,08.世界视觉日,09.世界邮政日,09.万国邮联日,10I辛亥革命纪念日,10.世界精神卫生日," + "13.世界保健日,13.国际教师节,14.世界标准日,15.国际盲人节(白手杖节),16.世界粮食日,17.世界消除贫困日,22.世界传统医药日,24.联合国日,24.世界发展信息日,31.世界勤俭日|" + "07.1917-9999十月社会主义革命纪念日,08.中国记者日,09.全国消防安全宣传教育日,10.世界青年节,11I光棍节,11.国际科学与和平周(本日所属的一周),12.孙中山诞辰纪念日," + "14.世界糖尿病日,17.国际大学生节,17.世界学生节,20.彝族年,21.彝族年,21.世界问候日,21.世界电视日,22.彝族年,29.国际声援巴勒斯坦人民国际日|" + "01I1988-9999世界艾滋病日,03.世界残疾人日,05.国际经济和社会发展志愿人员日,08.国际儿童电视日,09.世界足球日,10.世界人权日," + "12I西安事变纪念日,13I南京大屠杀(1937年)纪念日,20.澳门回归纪念,21.国际篮球日,24I平安夜,25I圣诞节,26I狂欢夜,26.毛泽东诞辰纪念,29.国际生物多样性日";
        sFtv2 = s.split("\\|");
        sFtv = new String[sFtv2.length][];
        for (int i = 0; i < sFtv2.length; i++) {
            sFtv[i] = sFtv2[i].split(",");
        }
    }

    public void getDayName(LunarData u, LunarData r) {
        String m0 = (u.m < 10 ? "0" : "") + u.m;
        String d0 = (u.d < 10 ? "0" : "") + u.d;
        int i;
        String s;
        String s2;
        String type;
        if (u.week == 0 || u.week == 6) {
            r.Fjia = 1;
        }
        for (i = 0; i < sFtv[u.m - 1].length; i++) {
            s = sFtv[u.m - 1][i];
            if (s.substring(0, 2) != d0) {
                continue;
            }
            s = s.substring(2);
            type = s.substring(0, 1);
            if ("-".equals(s.substring(5, 6))) {
                if (u.y < (Integer.parseInt(s.substring(1, 5))) || u.y > (Integer.parseInt(s.substring(6, 10)))) {
                    continue;
                }
                s = s.substring(10);
            } else {
                if (u.y < 1850) {
                    continue;
                }
                s = s.substring(1);
            }
            if (type.equals("#")) {
                r.A += s + ' ';
                r.Fjia = 1;
            }
            if (type.equals("I")) {
                r.B += s + ' ';
            }
            if (type.equals(".")) {
                r.C += s + ' ';
            }
        }
        double w = u.weeki;
        if (u.week >= u.week0) {
            w += 1;
        }
        double w2 = w;
        if (u.weeki == u.weekN - 1) {
            w2 = 5;
        }
        w = Integer.parseInt(m0) + w + u.week;
        w2 = Integer.parseInt(m0) + w2 + u.week;
        for (i = 0; i < wFtv.length; i++) {
            s = wFtv[i];
            s2 = s.substring(0, 4);
            if (Double.parseDouble(s2) != w && Double.parseDouble(s2) != w2) {
                continue;
            }
            type = s.substring(4, 5);
            s = s.substring(5);
            if (type.equals("#")) {
                r.A += s + ' ';
                r.Fjia = 1;
            }
            if (type.equals("I")) {
                r.B += s + ' ';
            }
            if (type.equals(".")) {
                r.C += s + ' ';
            }
        }
    }

    public void getHuiLi(double d0, LunarData r) {
        int z;
        int y;
        int m;
        double d;
        d = d0 + 503105;
        z = NumberUtil.int2(d / 10631);
        d -= z * 10631;
        y = NumberUtil.int2((d + 0.5) / 354.366);
        d -= NumberUtil.int2(y * 354.366 + 0.5);
        m = NumberUtil.int2((d + 0.11) / 29.51);
        d -= NumberUtil.int2(m * 29.5 + 0.5);
        r.Hyear = z * 30 + y + 1;
        r.Hmonth = m + 1;
        r.Hday = d + 1;
    }
}
