package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.util.NumberUtil;

import java.lang.reflect.Array;

/**
 * @author Yawei Xi
 * @since 2018-8-8 13:56
 */
public class SSQ {

    private static final double[] SUO_KB = {1457698.231017, 29.53067166, 1546082.512234, 29.53085106, 1640640.735300, 29.53060000, 1642472.151543, 29.53085439, 1683430.509300, 29.53086148, 1752148.041079, 29.53085097, 1807665.420323, 29.53059851, 1883618.114100, 29.53060000, 1907360.704700, 29.53060000, 1936596.224900, 29.53060000, 1939135.675300, 29.53060000, 1947168.00};
    private static final double[] QI_KB = {1640650.479938, 15.21842500, 1642476.703182, 15.21874996, 1683430.515601, 15.218750011, 1752157.640664, 15.218749978, 1807675.003759, 15.218620279, 1883627.765182, 15.218612292, 1907369.128100, 15.218449176, 1936603.140413, 15.218425000, 1939145.524180, 15.218466998, 1947180.798300, 15.218524844, 1964362.041824, 15.218533526, 1987372.340971, 15.218513908, 1999653.819126, 15.218530782, 2007445.469786, 15.218535181, 2021324.917146, 15.218526248, 2047257.232342, 15.218519654, 2070282.898213, 15.218425000, 2073204.872850, 15.218515221, 2080144.500926, 15.218530782, 2086703.688963, 15.218523776, 2110033.182763, 15.218425000, 2111190.300888, 15.218425000, 2113731.271005, 15.218515671, 2120670.840263, 15.218425000, 2123973.309063, 15.218425000, 2125068.997336, 15.218477932, 2136026.312633, 15.218472436, 2156099.495538, 15.218425000, 2159021.324663, 15.218425000, 2162308.575254, 15.218461742, 2178485.706538, 15.218425000, 2178759.662849, 15.218445786, 2185334.020800, 15.218425000, 2187525.481425, 15.218425000, 2188621.191481, 15.218437494, 2322147.76};
    int leap;
    private String SB;
    private String QB;
    private double[] ZQ = new double[0];
    private double ZQPe1;
    private double ZQPe2;
    private double[] HS = new double[0];
    private String[] ym = new String[0];
    private double[] dx = new double[0];

    public SSQ() {
        String suoS, qiS;
        suoS = "EqoFscDcrFpmEsF2DfFideFelFpFfFfFiaipqti1ksttikptikqckstekqttgkqttgkqteksttikptikq2fjstgjqttjkqttgkqt";
        suoS += "ekstfkptikq2tijstgjiFkirFsAeACoFsiDaDiADc1AFbBfgdfikijFifegF1FhaikgFag1E2btaieeibggiffdeigFfqDfaiBkF";
        suoS += "1kEaikhkigeidhhdiegcFfakF1ggkidbiaedksaFffckekidhhdhdikcikiakicjF1deedFhFccgicdekgiFbiaikcfi1kbFibef";
        suoS += "gEgFdcFkFeFkdcfkF1kfkcickEiFkDacFiEfbiaejcFfffkhkdgkaiei1ehigikhdFikfckF1dhhdikcfgjikhfjicjicgiehdik";
        suoS += "cikggcifgiejF1jkieFhegikggcikFegiegkfjebhigikggcikdgkaFkijcfkcikfkcifikiggkaeeigefkcdfcfkhkdgkegieid";
        suoS += "hijcFfakhfgeidieidiegikhfkfckfcjbdehdikggikgkfkicjicjF1dbidikFiggcifgiejkiegkigcdiegfggcikdbgfgefjF1";
        suoS += "kfegikggcikdgFkeeijcfkcikfkekcikdgkabhkFikaffcfkhkdgkegbiaekfkiakicjhfgqdq2fkiakgkfkhfkfcjiekgFebicg";
        suoS += "gbedF1jikejbbbiakgbgkacgiejkijjgigfiakggfggcibFifjefjF1kfekdgjcibFeFkijcfkfhkfkeaieigekgbhkfikidfcje";
        suoS += "aibgekgdkiffiffkiakF1jhbakgdki1dj1ikfkicjicjieeFkgdkicggkighdF1jfgkgfgbdkicggfggkidFkiekgijkeigfiski";
        suoS += "ggfaidheigF1jekijcikickiggkidhhdbgcfkFikikhkigeidieFikggikhkffaffijhidhhakgdkhkijF1kiakF1kfheakgdkif";
        suoS += "iggkigicjiejkieedikgdfcggkigieeiejfgkgkigbgikicggkiaideeijkefjeijikhkiggkiaidheigcikaikffikijgkiahi1";
        suoS += "hhdikgjfifaakekighie1hiaikggikhkffakicjhiahaikggikhkijF1kfejfeFhidikggiffiggkigicjiekgieeigikggiffig";
        suoS += "gkidheigkgfjkeigiegikifiggkidhedeijcfkFikikhkiggkidhh1ehigcikaffkhkiggkidhh1hhigikekfiFkFikcidhh1hit";
        suoS += "cikggikhkfkicjicghiediaikggikhkijbjfejfeFhaikggifikiggkigiejkikgkgieeigikggiffiggkigieeigekijcijikgg";
        suoS += "ifikiggkideedeijkefkfckikhkiggkidhh1ehijcikaffkhkiggkidhh1hhigikhkikFikfckcidhh1hiaikgjikhfjicjicgie";
        suoS += "hdikcikggifikigiejfejkieFhegikggifikiggfghigkfjeijkhigikggifikiggkigieeijcijcikfksikifikiggkidehdeij";
        suoS += "cfdckikhkiggkhghh1ehijikifffffkhsFngErD1pAfBoDd1BlEtFqA2AqoEpDqElAEsEeB2BmADlDkqBtC1FnEpDqnEmFsFsAFn";
        suoS += "llBbFmDsDiCtDmAB2BmtCgpEplCpAEiBiEoFqFtEqsDcCnFtADnFlEgdkEgmEtEsCtDmADqFtAFrAtEcCqAE1BoFqC1F1DrFtBmF";
        suoS += "tAC2ACnFaoCgADcADcCcFfoFtDlAFgmFqBq2bpEoAEmkqnEeCtAE1bAEqgDfFfCrgEcBrACfAAABqAAB1AAClEnFeCtCgAADqDoB";
        suoS += "mtAAACbFiAAADsEtBqAB2FsDqpFqEmFsCeDtFlCeDtoEpClEqAAFrAFoCgFmFsFqEnAEcCqFeCtFtEnAEeFtAAEkFnErAABbFkAD";
        suoS += "nAAeCtFeAfBoAEpFtAABtFqAApDcCGJ";
        qiS = "FrcFs22AFsckF2tsDtFqEtF1posFdFgiFseFtmelpsEfhkF2anmelpFlF1ikrotcnEqEq2FfqmcDsrFor22FgFrcgDscFs22FgEe";
        qiS += "FtE2sfFs22sCoEsaF2tsD1FpeE2eFsssEciFsFnmelpFcFhkF2tcnEqEpFgkrotcnEqrEtFermcDsrE222FgBmcmr22DaEfnaF22";
        qiS += "2sD1FpeForeF2tssEfiFpEoeFssD1iFstEqFppDgFstcnEqEpFg11FscnEqrAoAF2ClAEsDmDtCtBaDlAFbAEpAAAAAD2FgBiBqo";
        qiS += "BbnBaBoAAAAAAAEgDqAdBqAFrBaBoACdAAf1AACgAAAeBbCamDgEifAE2AABa1C1BgFdiAAACoCeE1ADiEifDaAEqAAFe1AcFbcA";
        qiS += "AAAAF1iFaAAACpACmFmAAAAAAAACrDaAAADG0";
        this.SB = jieYa(suoS);
        this.QB = jieYa(qiS);
    }

    public static double[] add(double[] array, double element) {
        double[] newArray = (double[]) ((double[]) copyArrayGrow1(array, Double.TYPE));
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        } else {
            return Array.newInstance(newArrayComponentType, 1);
        }
    }

    private static String[] add(String[] array, String element) {
        Class type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else {
            if (element == null) {
                throw new IllegalArgumentException("Arguments cannot both be null");
            }

            type = element.getClass();
        }

        String[] newArray = (String[]) copyArrayGrow1(array, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    private double calc(double jd, char qs) {
        jd += 2451545;
        int i;
        double D;
        String n;
        double[] B = SUO_KB;
        int pc = 14;
        if (qs == '气') {
            B = QI_KB;
            pc = 7;
        }
        double f1 = B[0] - pc, f2 = B[B.length - 1] - pc, f3 = 2436935;
        if (jd < f1 || jd >= f3) {
            if (qs == '气') {
                return Math.floor(qiHigh(Math.floor((jd + pc - 2451259) / 365.2422 * 24) * Math.PI / 12) + 0.5);
            } else {
                return Math.floor(soHigh(Math.floor((jd + pc - 2451551) / 29.5306) * Math.PI * 2) + 0.5);
            }
        }
        if (jd >= f1 && jd < f2) {
            for (i = 0; i < B.length; i += 2) {
                if (jd + pc < B[i + 2]) {
                    break;
                }
            }
            D = B[i] + B[i + 1] * Math.floor((jd + pc - B[i]) / B[i + 1]);
            D = Math.floor(D + 0.5);
            if (D == 1683460) {
                D++;
            }
            return D - 2451545;
        }
        if (jd >= f2 && jd < f3) {
            if (qs == '气') {
                D = Math.floor(qiLow(Math.floor((jd + pc - 2451259) / 365.2422 * 24) * Math.PI / 12) + 0.5);
                int startIndex = (int) Math.floor((jd - f2) / 365.2422 * 24);
                n = QB.substring(startIndex, startIndex + 1);
            } else {
                D = Math.floor(soLow(Math.floor((jd + pc - 2451551) / 29.5306) * Math.PI * 2) + 0.5);
                int startIndex = (int) Math.floor((jd - f2) / 29.5306);
                n = SB.substring(startIndex, startIndex + 1);
            }
            if (n.equals("1")) {
                return D + 1;
            }
            if (n.equals("2")) {
                return D - 1;
            }
            return D;
        }
        // 这个return是自己加上去的
        return 0;
    }

    public void calcY(double jd) {
        ChineseFestivals obb = new ChineseFestivals();
        double[] A = new double[0];
        double[] B = new double[0];
        int i, k;
        double W, w;
        W = NumberUtil.int2((jd - 355 + 183) / 365.2422) * 365.2422 + 355;
        if (calc(W, '气') > jd) {
            W -= 365.2422;
        }
        for (i = 0; i < 25; i++) {
            A = add(A, calc(W + 15.2184 * i, '气'));
        }
        ZQ = A;
        ZQPe1 = calc(W - 15.2, '气');
        ZQPe2 = calc(W - 30.4, '气');
        w = this.calc(A[0], '朔');
        if (w > A[0]) {
            w -= 29.53;
        }
        for (i = 0; i < 15; i++) {
            B = add(B, calc(w + 29.5306 * i, '朔'));
        }
        HS = B;
        leap = 0;
        for (i = 0; i < 14; i++) {
            if (dx.length < i + 1) {
                dx = add(dx, HS[i + 1] - HS[i]);
            } else {
                dx[i] = HS[i + 1] - HS[i];
            }
            if (ym.length < i + 1) {
                ym = add(ym, String.valueOf(i));
            } else {
                ym[i] = String.valueOf(i);
            }
        }
        double YY = NumberUtil.int2((this.ZQ[0] + 10 + 180) / 365.2422) + 2000;
        if (YY >= -721 && YY <= -104) {
            String[] ns = new String[9];
            double yy;
            for (i = 0; i < 3; i++) {
                yy = YY + i - 1;
                if (yy >= -721) {
                    ns[i] = String.valueOf(calc(1457698 - Common.J2000 + NumberUtil.int2(0.342 + (yy + 721) * 12.368422) * 29.5306, '朔'));
                    ns[i + 3] = "十三";
                    ns[i + 6] = String.valueOf(2);
                }
                if (yy >= -479) {
                    ns[i] = String.valueOf(calc(1546083 - Common.J2000 + NumberUtil.int2(0.500 + (yy + 479) * 12.368422) * 29.5306, '朔'));
                    ns[i + 3] = "十三";
                    ns[i + 6] = String.valueOf(2);
                }
                if (yy >= -220) {
                    ns[i] = String.valueOf(calc(1640641 - Common.J2000 + NumberUtil.int2(0.866 + (yy + 220) * 12.369000) * 29.5306, '朔'));
                    ns[i + 3] = "后九";
                    ns[i + 6] = String.valueOf(11);
                }
            }
            int nn;
            double f1;
            for (i = 0; i < 14; i++) {
                for (nn = 2; nn >= 0; nn--) {
                    if (HS[i] >= Double.parseDouble(ns[nn])) {
                        break;
                    }
                }
                f1 = NumberUtil.int2((HS[i] - Double.parseDouble(ns[nn]) + 15) / 29.5306);
                if (f1 < 12) {
                    ym[i] = ChineseFestivals.Y_M_C[(int) ((f1 + Integer.parseInt(ns[nn + 6])) % 12)];
                } else {
                    ym[i] = String.valueOf(ns[nn + 3]);
                }
            }
            return;
        }
        if (B[13] <= A[24]) {
            for (i = 1; B[i + 1] > A[2 * i] && i < 13; i++) {
            }
            ;
            this.leap = i;
            for (; i < 14; i++) {
                ym[i] = String.valueOf(Integer.parseInt(ym[i]) - 1);
            }
        }
        for (i = 0; i < 14; i++) {
            double Dm = this.HS[i] + Common.J2000;
            int v2 = Integer.parseInt(ym[i]);
            String mc = ChineseFestivals.Y_M_C[v2 % 12];
            if (Dm >= 1724360 && Dm <= 1729794) {
                mc = ChineseFestivals.Y_M_C[(v2 + 1) % 12];
            } else if (Dm >= 1807724 && Dm <= 1808699) {
                mc = ChineseFestivals.Y_M_C[(v2 + 1) % 12];
            } else if (Dm >= 1999349 && Dm <= 1999467) {
                mc = ChineseFestivals.Y_M_C[(v2 + 2) % 12];
            } else if (Dm >= 1973067 && Dm <= 1977052) {
                if (v2 % 12 == 0) {
                    mc = "正";
                }
                if (v2 == 2) {
                    mc = "一";
                }
            }
            if (Dm == 1729794 || Dm == 1808699) {
                mc = "拾贰";
            }
            ym[i] = mc;
        }
    }

    private double soLow(double W) {
        double v = 7771.37714500204;
        double t = (W + 1.08472) / v, L;
        t -= (-0.0000331 * t * t + 0.10976 * Math.cos(0.785 + 8328.6914 * t) + 0.02224 * Math.cos(0.187 + 7214.0629 * t) - 0.03342 * Math.cos(4.669 + 628.3076 * t)) / v + (32 * (t + 1.8) * (t + 1.8) - 20) / 86400 / 36525;
        return t * 36525 + 8 / 24.0;
    }

    private double qiLow(double W) {
        double t, L, v = 628.3319653318;
        t = (W - 4.895062166) / v;
        t -= (53 * t * t + 334116 * Math.cos(4.67 + 628.307585 * t) + 2061 * Math.cos(2.678 + 628.3076 * t) * t) / v / 10000000;
        L = 48950621.66 + 6283319653.318 * t + 53 * t * t + 334166 * Math.cos(4.669257 + 628.307585 * t) + 3489 * Math.cos(4.6261 + 1256.61517 * t) + 2060.6 * Math.cos(2.67823 + 628.307585 * t) * t - 994 - 834 * Math.sin(2.1824 - 33.75705 * t);
        t -= (L / 10000000 - W) / 628.332 + (32 * (t + 1.8) * (t + 1.8) - 20) / 86400 / 36525;
        return t * 36525 + 8 / 24.0;
    }

    private double qiHigh(double W) {
        double t = XL.SALonT2(W) * 36525;
        t = t - Common.dtT(t) + 8 / 24.0;
        double v = ((t + 0.5) % 1) * 86400;
        if (v < 1200 || v > 86400 - 1200) {
            t = XL.SALonT(W) * 36525 - Common.dtT(t) + 8 / 24.0;
        }
        return t;
    }

    private double soHigh(double W) {
        double t = XL.MSALonT2(W) * 36525;
        t = t - Common.dtT(t) + 8 / 24.0;
        double v = ((t + 0.5) % 1) * 86400;
        if (v < 1800 || v > 86400 - 1800) {
            t = XL.MS_aLon_t(W) * 36525 - Common.dtT(t) + 8 / 24.0;
        }
        return t;
    }

    private String jieYa(String s) {
        String o = "0000000000", o2 = o + o;
        s = s.replace("J", "00");
        s = s.replace("I", "000");
        s = s.replace("H", "0000");
        s = s.replace("G", "00000");
        s = s.replace("t", "02");
        s = s.replace("s", "002");
        s = s.replace("r", "0002");
        s = s.replace("q", "00002");
        s = s.replace("p", "000002");
        s = s.replace("o", "0000002");
        s = s.replace("n", "00000002");
        s = s.replace("m", "000000002");
        s = s.replace("l", "0000000002");
        s = s.replace("k", "01");
        s = s.replace("j", "0101");
        s = s.replace("i", "001");
        s = s.replace("h", "001001");
        s = s.replace("g", "0001");
        s = s.replace("f", "00001");
        s = s.replace("e", "000001");
        s = s.replace("d", "0000001");
        s = s.replace("c", "00000001");
        s = s.replace("b", "000000001");
        s = s.replace("a", "0000000001");
        s = s.replace("A", o2 + o2 + o2);
        s = s.replace("B", o2 + o2 + o);
        s = s.replace("C", o2 + o2);
        s = s.replace("D", o2 + o);
        s = s.replace("E", o2);
        s = s.replace("F", o);
        return s;
    }

    public int getLeap() {
        return leap;
    }

    public void setLeap(int leap) {
        this.leap = leap;
    }

    public String getSB() {
        return SB;
    }

    public void setSB(String SB) {
        this.SB = SB;
    }

    public String getQB() {
        return QB;
    }

    public void setQB(String QB) {
        this.QB = QB;
    }

    public double[] getZQ() {
        return ZQ;
    }

    public void setZQ(double[] ZQ) {
        this.ZQ = ZQ;
    }

    public double getZQPe1() {
        return ZQPe1;
    }

    public void setZQPe1(double ZQPe1) {
        this.ZQPe1 = ZQPe1;
    }

    public double getZQPe2() {
        return ZQPe2;
    }

    public void setZQPe2(double ZQPe2) {
        this.ZQPe2 = ZQPe2;
    }

    public double[] getHS() {
        return HS;
    }

    public void setHS(double[] HS) {
        this.HS = HS;
    }

    public String[] getYm() {
        return ym;
    }

    public void setYm(String[] ym) {
        this.ym = ym;
    }

    public double[] getDx() {
        return dx;
    }

    public void setDx(double[] dx) {
        this.dx = dx;
    }
}
