package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.bean.*;
import cn.freelancy.sxtwl4j.util.NumberUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Yawei Xi
 * @since 2018-8-7 13:55
 */
public class Lunar {

    private static final String FIRST_MONTH_NAME = "正月";
    private static final String LAST_MONTH_NAME = "腊月";

    private LunarData[] lun;
    private double w0;
    private int y;
    private int m;
    private int d0;
    private int dn;
    private String Ly;
    private String ShX;
    private String nianhao;

    public Lunar() {
        resetLun();
    }

    private void resetLun() {
        lun = new LunarData[31];
        for (int i = 0; i < lun.length; i++) {
            lun[i] = new LunarData();
        }
    }

    /**
     * 获取公历年的信息
     *
     * @param solarYear 公历年
     * @return
     */
    public SolarYear getSolarYear(int solarYear) {
        SolarYear sy = new SolarYear();
        List<Day> allDays = getFullDaysBySolarYear(solarYear);

        List<SolarMonth> allMonths = new ArrayList<>();
        for (int i = 1; i <= 12; i++) {
            SolarMonth solarMonth = new SolarMonth();
            solarMonth.setYear(solarYear);
            solarMonth.setMonth(i);
            final Integer month = i;
            List<Day> days = new ArrayList<>();
            for (Day day : allDays) {
                if (month.equals(day.getSolarMonth())) {
                    days.add(day);
                }
            }
            solarMonth.setAllDays(days);
            allMonths.add(solarMonth);
        }

        sy.setAllDays(allDays);
        sy.setYear(solarYear);
        sy.setAllMonths(allMonths);
        return sy;
    }

    /**
     * 获取农历年的信息
     *
     * @param lunarYear 农历年
     * @return
     */
    public LunarYear getLunarYear(int lunarYear) {
        LunarYear ly = new LunarYear();
        List<Day> allDays = getFullDaysByLunarYear(lunarYear);
        List<String> allMonthName = getLunarStrFromDaysList(allDays);

        ly.setAllDays(allDays);
        ly.setAllMonthsName(allMonthName);
        ly.setYear(lunarYear);
        List<LunarMonth> lunarMonths = new ArrayList<>();
        for (String s : allMonthName) {
            LunarMonth lunarMonth = new LunarMonth();
            lunarMonth.setYear(lunarYear);
            lunarMonth.setMonth(s);
            List<Day> days = new ArrayList<>();
            for (Day day : allDays) {
                if (s.equals(day.getLunarMonth())) {
                    days.add(day);
                }
            }
            lunarMonth.setAllDays(days);
            lunarMonths.add(lunarMonth);
        }
        ly.setAllMonths(lunarMonths);
        return ly;
    }

    /**
     * 获取某年的所有天
     *
     * @param yearOfSolar 公历年
     * @return
     */
    public List<Day> getFullDaysBySolarYear(int yearOfSolar) {
        List<Day> days = new ArrayList<>();
        for (int i = 1; i <= 12; i++) {
            days.addAll(getDaysByYearAndMonth(yearOfSolar, i));
        }
        return days;
    }

    /**
     * 获取某年的所有天
     *
     * @param lunarYear 农历年
     * @return
     */
    public List<Day> getFullDaysByLunarYear(int lunarYear) {
        int solarYear = lunarYear;
        List<Day> days = new ArrayList<>();
        for (int i = 1; i < 13; i++) {
            days.addAll(getDaysByYearAndMonth(solarYear, i));
        }
        for (int i = 1; i < 5; i++) {
            days.addAll(getDaysByYearAndMonth(solarYear + 1, i));
        }

        int firstIndex = 0;
        int lastIndex;
        Day firstDay = null;
        for (Day day : days) {
            if (day.getLunarMonth().contains(FIRST_MONTH_NAME)) {
                firstDay = day;
                break;
            }
        }
        if (null != firstDay) {
            firstIndex = days.indexOf(firstDay);
        }
        // 当年最后一天
        lastIndex = getLastDayIndexOfCurrYear(days);
        return days.subList(firstIndex, lastIndex + 1);
    }

    private int getLastDayIndexOfCurrYear(List<Day> days) {
        int index = 0;
        for (int i = days.size() - 1; i >= 0; i--) {
            if (days.get(i).getLunarMonth().contains(LAST_MONTH_NAME)) {
                index = i;
                break;
            }
        }
        return index;
    }

    /**
     * 获取农历该年的所有月份
     *
     * @param days 农历的年的所有天
     * @return
     */
    private List<String> getLunarStrFromDaysList(List<Day> days) {
        List<String> months = new ArrayList<>();
        for (Day day : days) {
            if (!months.contains(day.getLunarMonth())) {
                months.add(day.getLunarMonth());
            }
        }
        return months;
    }

    /**
     * 通过公历的年月日获取日期对象
     *
     * @param solarYear  年（公历）
     * @param solarMonth 月（公历）
     * @param solarDay   日（公历）
     * @return 日期对象
     */
    public Day getDay(int solarYear, int solarMonth, int solarDay) {
        List<Day> days = getFullDaysBySolarYear(solarYear);
        for (Day day : days) {
            if (null != day && day.getSolarYear() == solarYear && day.getSolarMonth() == solarMonth && day.getSolarDay() == solarDay) {
                return day;
            }
        }
        return null;
    }

    /**
     * 通过 年月 获取当月的所有天的信息
     *
     * @param By 年
     * @param Bm 月
     * @return
     */
    public List<Day> getDaysByYearAndMonth(int By, int Bm) {
        yueLiCalc(By, Bm);
        List<Day> days = new ArrayList<>();
        for (LunarData lunarData : lun) {
            if (isLunarDataNotEmpty(lunarData)) {
                Day day = new Day();
                day.setSolarYear(lunarData.getY());
                day.setSolarMonth(lunarData.getM());
                day.setSolarDay(lunarData.getD());
                day.setLunarYear(lunarData.getY());
                if (lunarData.getM() < 4) {
                    if (lunarData.getLmc().contains("腊") || lunarData.getLmc().contains("冬") || lunarData.getLmc().contains("十")) {
                        day.setLunarYear(lunarData.getY() - 1);
                    }
                }
                day.setLunarMonth(lunarData.getLleap() + lunarData.getLmc() + "月");
                day.setLunarDay(lunarData.getLdc());
                day.setFestival(lunarData.getA());
                day.setJieQi(lunarData.getLjq());
                day.setJieQiName(lunarData.getJqmc());
                day.setJieQiTime(lunarData.getJqsj());
                days.add(day);
            }
        }
        return days;
    }

    /**
     * 获取某年所有节气
     *
     * @param solarYear 年（公历）
     * @return 24节气时间字符串列表
     */
    public List<String> get24JieQiByYear(int solarYear) {
        List<Day> days = getFullDaysBySolarYear(solarYear);
        List<String> jieQi24 = new ArrayList<>();
        for (Day day : days) {
            if (null != day.getJieQiName() && !"".equals(day.getJieQiName())) {
                jieQi24.add(day.getSolarYear() + "-" + day.getSolarMonth() + "-" + day.getSolarDay() + " " + day.getJieQiTime());
            }
        }
        return jieQi24;
    }

    /**
     * 判断lunarData是否为空
     * PS：
     * 为空的条件：对象不存在，或对象的 y (年） 值为0，因为不存在公元0年
     *
     * @param lunarData 要进行判断的日历对象
     * @return 不为空(true), 为空(false)
     */
    private boolean isLunarDataNotEmpty(LunarData lunarData) {
        return null != lunarData && lunarData.getY() != 0;
    }

    private String subStr2(String s, int n, String end) {
        s = s.trim();
        if (s.length() > n + 1) {
            return s.substring(0, n) + end;
        }
        return s;
    }

    private void yueLiCalc(int By, int Bm) {
        resetLun();
        int i, j, k, c, Bd0, Bdn;
        WesternFestivals oba = new WesternFestivals();
        SSQ ssq = new SSQ();
        ChineseFestivals obb = new ChineseFestivals();
        JD.h = 12;
        JD.m = 0;
        JD.s = 0.1;
        JD.Y = By;
        JD.M = Bm;
        JD.D = 1;
        Bd0 = (int) (NumberUtil.int2(JD.toJd()) - Common.J2000);
        JD.M++;
        if (JD.M > 12) {
            JD.Y++;
            JD.M = 1;
        }
        Bdn = (int) (NumberUtil.int2(JD.toJd()) - Common.J2000 - Bd0);
        w0 = (Bd0 + Common.J2000 + 1 + 7000000) % 7;
        y = By;
        m = Bm;
        d0 = Bd0;
        dn = Bdn;
        c = By - 1984 + 12000;
        Ly = ChineseFestivals.GAN[c % 10] + "" + ChineseFestivals.ZHI[c % 12];
        ShX = ChineseFestivals.SH_X[c % 12];
        nianhao = obb.getNH(By);
        double w;
        double D;
        for (i = 0, j = 0; i < Bdn; i++) {
            LunarData ob = this.lun[i];
            ob.d0 = Bd0 + i;
            ob.di = i;
            ob.y = By;
            ob.m = Bm;
            ob.dn = Bdn;
            ob.week0 = this.w0;
            ob.week = (this.w0 + i) % 7;
            ob.weeki = NumberUtil.int2((this.w0 + i) / 7);
            ob.weekN = NumberUtil.int2((this.w0 + Bdn - 1) / 7) + 1;
            JD.setFromJD((int) (ob.d0 + Common.J2000));
            ob.d = JD.D;
            if (ssq.getZQ().length == 0 || ob.d0 < ssq.getZQ()[0] || ob.d0 >= ssq.getZQ()[24]) {
                ssq.calcY(ob.d0);
            }
            int mk = NumberUtil.int2((ob.d0 - ssq.getHS()[0]) / 30);
            if (mk < 13 && ssq.getHS()[mk + 1] <= ob.d0) {
                mk++;
            }
            ob.Ldi = ob.d0 - ssq.getHS()[mk];
            ob.Ldc = ChineseFestivals.R_M_C[(int) ob.Ldi];
            ob.cur_dz = ob.d0 - ssq.getZQ()[0];
            ob.cur_xz = ob.d0 - ssq.getZQ()[12];
            ob.cur_lq = ob.d0 - ssq.getZQ()[15];
            ob.cur_mz = ob.d0 - ssq.getZQ()[11];
            ob.cur_xs = ob.d0 - ssq.getZQ()[13];
            if (ob.d0 == ssq.getHS()[mk] || ob.d0 == Bd0) {
                ob.Lmc = ssq.getYm()[mk];
                ob.Ldn = ssq.getDx()[mk];
                ob.Lleap = (ssq.getLeap() != 0 && ssq.getLeap() == mk) ? "闰" : "";
                ob.Lmc2 = mk < 13 ? ssq.getYm()[mk + 1] : "未知";
            } else {
                LunarData ob2 = this.lun[i - 1];
                ob.Lmc = ob2.Lmc;
                ob.Ldn = ob2.Ldn;
                ob.Lleap = ob2.Lleap;
                ob.Lmc2 = ob2.Lmc2;
            }
            int qk = NumberUtil.int2((ob.d0 - ssq.getZQ()[0] - 7) / 15.2184);
            if (qk < 23 && ob.d0 >= ssq.getZQ()[qk + 1]) {
                qk++;
            }
            if (ob.d0 == ssq.getZQ()[qk]) {
                ob.Ljq = ChineseFestivals.J_Q_M_C[qk];
            } else {
                ob.Ljq = "";
            }
            Cal cal = new Cal(By, Bm);
            if (Bm == 12 && i == 28) {
                System.out.println("a");
            }
            ob.dtpq = Common.Dtlpq(ob, qk, cal);
            ob.yxsj = "";
            ob.yxjd = ob.yxsj;
            ob.yxmc = ob.yxjd;
            ob.jqsj = "";
            ob.jqjd = ob.jqsj;
            ob.jqmc = ob.jqjd;
            D = ssq.getZQ()[3] + (ob.d0 < ssq.getZQ()[3] ? -365 : 0) + 365.25 * 16 - 35;
            ob.Lyear = Math.floor(D / 365.2422 + 0.5);
            D = ssq.getHS()[2];
            for (j = 0; j < 14; j++) {
                if (!ssq.getYm()[j].equals("正") || ssq.getLeap() == j && j != 0) {
                    continue;
                }
                D = ssq.getHS()[j];
                if (ob.d0 < D) {
                    D -= 365;
                    break;
                }
            }
            D = D + 5810;
            ob.Lyear0 = Math.floor(D / 365.2422 + 0.5);
            D = ob.Lyear + 12000;
            ob.Lyear2 = ChineseFestivals.GAN[(int) (D % 10)] + "" + ChineseFestivals.ZHI[(int) (D % 12)];
            D = ob.Lyear0 + 12000;
            ob.Lyear3 = ChineseFestivals.GAN[(int) (D % 10)] + "" + ChineseFestivals.ZHI[(int) (D % 12)];
            ob.Lyear4 = ob.Lyear0 + 1984 + 2698;
            mk = NumberUtil.int2((ob.d0 - ssq.getZQ()[0]) / 30.43685);
            if (mk < 12 && ob.d0 >= ssq.getZQ()[2 * mk + 1]) {
                mk++;
            }
            D = mk + NumberUtil.int2((ssq.getZQ()[12] + 390) / 365.2422) * 12 + 900000;
            ob.Lmonth = D % 12;
            ob.Lmonth2 = ChineseFestivals.GAN[(int) (D % 10)] + "" + ChineseFestivals.ZHI[(int) (D % 12)];
            D = ob.d0 - 6 + 9000000;
            ob.Lday2 = ChineseFestivals.GAN[(int) (D % 10)] + "" + ChineseFestivals.ZHI[(int) (D % 12)];
            mk = NumberUtil.int2((ob.d0 - ssq.getZQ()[0] - 15) / 30.43685);
            if (mk < 11 && ob.d0 >= ssq.getZQ()[2 * mk + 2]) {
                mk++;
            }
            ob.XiZ = ChineseFestivals.XI_Z[(mk + 12) % 12] + '座';
            oba.getHuiLi(ob.d0, ob);
            ob.C = "";
            ob.B = ob.C;
            ob.A = ob.B;
            ob.Fjia = 0;
            oba.getDayName(ob, ob);
            obb.getDayName(ob, ob);
        }
        double d, jd2 = Bd0 + Common.dtT(Bd0) - 8 / 24.0;
        w = XL.MSALon(jd2 / 36525, 10, 3);
        w = NumberUtil.int2((w - 0.78) / Math.PI * 2) * Math.PI / 2;
        int xn;
        do {
            d = obb.so_accurate(w);
            D = NumberUtil.int2(d + 0.5);
            xn = NumberUtil.int2(w / Common.pi2 * 4 + 4000000.01) % 4;
            w += Common.pi2 / 4;
            if (D >= Bd0 + Bdn) {
                break;
            }
            if (D < Bd0) {
                continue;
            }
            LunarData ob = lun[(int) (D - Bd0)];
            ob.yxmc = ChineseFestivals.Y_X_M_C[xn];
            ob.yxjd = String.valueOf(d);
            ob.yxsj = JD.timeStr(d);
        } while (D + 5 < Bd0 + Bdn);
        w = XL.SALon(jd2 / 36525, 3);
        w = NumberUtil.int2((w - 0.13) / Common.pi2 * 24) * Common.pi2 / 24;
        do {
            d = obb.qi_accurate(w);
            D = NumberUtil.int2(d + 0.5);
            xn = NumberUtil.int2(w / Common.pi2 * 24 + 24000006.01) % 24;
            w += Common.pi2 / 24;
            if (D >= Bd0 + Bdn) {
                break;
            }
            if (D < Bd0) {
                continue;
            }
            LunarData ob = lun[(int) (D - Bd0)];
            ob.jqmc = ChineseFestivals.J_Q_M_C[xn];
            ob.jqjd = String.valueOf(d);
            ob.jqsj = JD.timeStr(d);
        } while (D + 12 < Bd0 + Bdn);
    }

    public String yueLiHTML(int By, int Bm, int curJD) {
        String sty_head = " style=\"font-family: 宋体; font-size: 14px; text-align: center; background-color: #E0E0FF; color: #000000; font-weight: bold\" ";
        String sty_body = " style=\"font-family: 宋体; font-size: 12px; text-align: center \" ";
        String sty_date = " style=\"font-family: Arial Black; text-align: center;font-size: 20px\" ";
        String sty_date2 = " style=\"font-family: Arial Black; text-align: center;font-size: 20px; color: #FF0000\" ";
        String sty_cur = " style=\"background-color:#90D050\" ";
        int i, j;
        String c, c2, cr = "", isM;
        this.yueLiCalc(By, Bm);
        c = this.nianhao + " 农历" + this.Ly + "年【" + this.ShX + "年】";
        if (c.length() > 33) {
            c = "<span style=\"font-size:12px\">" + c + "</span>";
        } else {
            c = "<span style=\"font-size:16px;font-weight:bold\">" + c + "</span>";
        }
        String ta0 = "<tr><td colspan=7 style=\"background-color:#00AFFF\" style=\"color=#FFFF00\">" + c + "</td></tr>";
        ta0 += "<tr>" + "<td" + sty_head + "width=\"%14\">日</td>" + "<td" + sty_head + "width=\"%14\">一</td>" + "<td" + sty_head + "width=\"%14\">二</td>" + "<td" + sty_head + "width=\"%14\">三</td>" + "<td" + sty_head + "width=\"%14\">四</td>" + "<td" + sty_head + "width=\"%14\">五</td>" + "<td" + sty_head + "width=\"%14\">六</td></tr>";
        for (i = 0; i < this.dn; i++) {
            LunarData ob = lun[i];
            if (i != 0) {
                for (j = 0; j < this.w0; j++) {
                    cr += "<td" + sty_body + "></td>";
                }
            }
            c = "";
            isM = "";
            if (ob.A != null && !"".equals(ob.A)) {
                c += "<font color=red>" + subStr2(ob.A, 4, "..") + "</font>";
            }
            if ((c == null || "".equals(c)) && ob.B != null && !"".equals(ob.B)) {
                c = "<font color=blue>" + subStr2(ob.B, 4, "..") + "</font>";
            }
            if ((c == null || "".equals(c)) && "初一".equals(ob.Ldc)) {
                c = ob.Lleap + ob.Lmc + "月" + (ob.Ldn == 30 ? "大" : "小");
            }
            if (c == null || "".equals(c)) {
                c = ob.Ldc;
            }
            if (ob.yxmc.equals("朔")) {
                isM = "<font color=#505000>●</font>";
            }
            if (ob.yxmc.equals("望")) {
                isM = "<font color=#F0B000>●</font>";
            }
            if (ob.yxmc.equals("上弦")) {
                isM = "<font color=#F0B000><b>∪</b></font>";
            }
            if (ob.yxmc.equals("下弦")) {
                isM = "<font color=#F0B000><b>∩</b></font>";
            }
            if (ob.jqmc != null && !"".equals(ob.jqmc)) {
                isM += "<font color=#00C000>◆</font>";
            }
            if (ob.Fjia != 0) {
                c2 = sty_date2;
            } else {
                c2 = sty_date;
            }
            c2 += " onmouseover=\"showMessD(" + i + ")\"";
            c2 += " onmouseout =\"showMessD(-1)\"";
            c2 = "<span" + c2 + ">" + ob.d + "<br/>" + ob.Lday2 + "</span>";
            if (ob.d0 == curJD) c2 = "<span" + sty_cur + ">" + c2 + "</span>";
            cr += "<td" + sty_body + "width=\"14%\">" + c2 + "<br>" + isM + c + "</td>";
            if (i == this.dn - 1) {
                for (j = 0; j < 6 - ob.week; j++) {
                    cr += "<td" + sty_body + "></td>";
                }
            }
            if (i == this.dn - 1 || ob.week == 6) {
                ta0 += "<tr>" + cr + "</tr>";
                cr = "";
            }
        }
        String pg1 = "<table border=0 cellpadding=3 cellspacing=1 width=\"100%\">" + ta0 + "</table>";
        String b2 = "", b3 = "", b4 = "";
        for (i = 0; i < this.dn; i++) {
            LunarData ob = lun[i];
            if (i + 1 < 10) {
                c = "&nbsp;" + c;
            }
            if (ob.yxmc == "朔" || ob.yxmc == "望") {
                b2 += c + "日 " + ob.yxsj + ob.yxmc + "月 &nbsp;";
            }
            if (ob.yxmc == "上弦" || ob.yxmc == "下弦") {
                b3 += c + "日 " + ob.yxsj + ob.yxmc + " &nbsp;";
            }
            if (ob.jqmc != null && !"".equals(ob.jqmc)) {
                b4 += c + "日 " + ob.jqsj + ob.jqmc + " &nbsp;";
            }
        }
        String pg2 = b2 + "<br>" + b3 + "<br>" + b4;
        return pg1 + "|" + pg2;
    }

}
