package cn.freelancy.sxtwl4j;

import static cn.freelancy.sxtwl4j.util.NumberUtil.int2;

/**
 * @author Yawei Xi
 * @since 2018-8-7 9:40
 */
public class JD {
    public static int Y = 2000;
    public static int M = 1;
    public static int D = 1;
    public static int h = 12;
    public static int m = 0;
    public static double s = 0;

    private static String[] week = {"日", "一", "二", "三", "四", "五", "六", "七"};

    private static double nnWeek(int y, int m, int n, int w) {
        double jd = jd(y, m, 1.5);
        double w0 = (jd + 1 + 7000000) % 7;
        double r = jd - w0 + 7 * n + w;
        if (w >= w0) {
            r -= 7;
        }
        if (n == 5) {
            m++;
            if (m > 12) {
                m = 1;
                y++;
            }
            if (r >= jd(y, m, 1.5)) {
                r -= 7;
            }
        }
        return r;
    }

    private static int getWeek(int jd) {
        return int2(jd + 1.5 + 7000000) % 7;
    }

    public static String timeStr(double jd) {
        int h;
        int m;
        int s;
        String hs;
        String ms;
        String ss;
        jd += 0.5;
        jd = (jd - int2(jd));
        s = int2(jd * 86400 + 0.5);
        h = int2(s / 3600.0);
        s -= h * 3600;
        m = int2(s / 60.0);
        s -= m * 60;
        hs = "0" + h;
        ms = "0" + m;
        ss = "0" + s;
        return hs.substring(hs.length() - 2) + ":" + ms.substring(ms.length() - 2) + ":" + ss.substring(ss.length() - 2);
    }

    public static void setFromJD(int jd) {
        JdDateTime r = dd(jd);
        Y = r.getYear();
        M = r.getMonth();
        D = r.getDay();
        m = r.getMinute();
        h = r.getHour();
        s = r.getSecond();
    }

    public static double toJd() {
        return jd(Y, M, D + ((s / 60 + m) / 60 + h) / 24);
    }

    private static String jd2Str(int jd) {
        JdDateTime r = dd(jd);
        return dd2Str(r);
    }

    private static String dd2Str(JdDateTime r) {
        String Y = "     " + r.getYear();
        String M = "0" + r.getMonth();
        String D = "0" + r.getDay();
        int h = r.getHour();
        int m = r.getMinute();
        int s = int2(r.getSecond() + 0.5);
        if (s >= 60) {
            s -= 60;
            m++;
        }
        if (m >= 60) {
            m -= 60;
            h++;
        }
        String h1 = "0" + h;
        String m1 = "0" + m;
        String s1 = "0" + s;
        Y = Y.substring(Y.length() - 5);
        M = M.substring(M.length() - 2);
        D = D.substring(D.length() - 2);
        h1 = h1.substring(h1.length() - 2);
        m1 = m1.substring(m1.length() - 2);
        s1 = s1.substring(s1.length() - 2);
        return Y + "-" + M + "-" + D + " " + h1 + ":" + m1 + ":" + s1;
    }

    private static JdDateTime dd(int jd) {
        JdDateTime r = new JdDateTime();
        int D = int2(jd + 0.5);
        double F = jd + 0.5 - D;
        int c;
        if (D >= 2299161) {
            c = int2((D - 1867216.25) / 36524.25);
            D += 1 + c - int2(c / 4.0);
        }
        D += 1524;
        r.setYear(int2((D - 122.1) / 365.25));
        D -= int2(365.25 * r.getYear());
        r.setMonth(int2(D / 30.601));
        D -= int2(30.601 * r.getMonth());
        r.setDay(D);
        if (r.getMonth() > 13) {
            r.setMonth(r.getMonth() - 13);
            r.setYear(r.getYear() - 4715);
        } else {
            r.setMonth(r.getMonth() - 1);
            r.setYear(r.getYear() - 4716);
        }
        F *= 24;
        r.setHour(int2(F));
        F -= r.getHour();
        F *= 60;
        r.setMinute(int2(F));
        F -= r.getMinute();
        F *= 60;
        r.setSecond(int2(F));
        return r;
    }

    /**
     * @param y 年
     * @param m 月
     * @param d 日
     * @return
     */
    public static double jd(int y, int m, double d) {
        int n = 0;
        int G = 0;
        if (y * 372 + m * 31 + int2(d) >= 588829) {
            G = 1;
        }
        if (m <= 2) {
            m += 12;
            y--;
        }
        if (G != 0) {
            n = int2(y / 100.0);
            n = 2 - n + int2(n / 4.0);
        }
        return int2(365.25 * (y + 4716)) + int2(30.6001 * (m + 1)) + d + n - 1524.5;
    }
}
