package cn.freelancy.sxtwl4j;

import cn.freelancy.sxtwl4j.util.DataUtil;

import static cn.freelancy.sxtwl4j.util.NumberUtil.*;

/**
 * @author Yawei Xi
 * @since 2018-8-7 14:06
 */
public class Common {

    private static final double[] DT_AT = {-4000, 108371.7, -13036.80, 392.000, 0.0000, -500, 17201.0, -627.82, 16.170, -0.3413, -150, 12200.6, -346.41, 5.403, -0.1593, 150, 9113.8, -328.13, -1.647, 0.0377, 500, 5707.5, -391.41, 0.915, 0.3145, 900, 2203.4, -283.45, 13.034, -0.1778, 1300, 490.1, -57.35, 2.085, -0.0072, 1600, 120.0, -9.81, -1.532, 0.1403, 1700, 10.2, -0.91, 0.510, -0.0370, 1800, 13.4, -0.72, 0.202, -0.0193, 1830, 7.8, -1.81, 0.416, -0.0247, 1860, 8.3, -0.13, -0.406, 0.0292, 1880, -5.4, 0.32, -0.183, 0.0173, 1900, -2.3, 2.06, 0.169, -0.0135, 1920, 21.2, 1.69, -0.304, 0.0167, 1940, 24.2, 1.22, -0.064, 0.0031, 1960, 33.2, 0.51, 0.231, -0.0109, 1980, 51.0, 1.29, -0.026, 0.0032, 2000, 63.87, 0.1, 0, 0, 2005, 64.7, 0.4, 0, 0, 2015, 69};
    public static final double[][] XL0 = DataUtil.getDouble2FromRes("XL0.db");
    public static final double[][][] XL1 = DataUtil.getDouble3FromRes("XL1.db");
    public static final double[][] XL0Pluto = DataUtil.getDouble2FromRes("XL0Pluto.db");
    private static final double[] XL0_xzb = {-0.08631, +0.00039, -0.00008, -0.07447, +0.00006, +0.00017, -0.07135, -0.00026, -0.00176, -0.20239, +0.00273, -0.00347, -0.25486, +0.00276, +0.42926, +0.24588, +0.00345, -14.46266, -0.95116, +0.02481, +58.30651};
    private static final double[] nutB = {2.1824, -33.75705, 36e-6, -1720, 920, 3.5069, 1256.66393, 11e-6, -132, 57, 1.3375, 16799.4182, -51e-6, -23, 10, 4.3649, -67.5141, 72e-6, 21, -9, 0.04, -628.302, 0, -14, 0, 2.36, 8328.691, 0, 7, 0, 3.46, 1884.966, 0, -5, 2, 5.44, 16833.175, 0, -4, 2, 3.69, 25128.110, 0, -3, 0, 3.55, 628.362, 0, 2, 0};


    public static double cs_rEar = 6378.1366;
    public static double cs_rEarA = 0.99834 * cs_rEar;
    public static double cs_ba = 0.99664719;
    public static double cs_ba2 = cs_ba * cs_ba;
    public static double cs_AU = 1.49597870691e8;
    public static double cs_sinP = cs_rEar / cs_AU;
    public static double cs_PI = Math.asin(cs_sinP);
    public static double cs_GS = 299792.458;
    public static double cs_Agx = cs_AU / cs_GS / 86400 / 36525;
    public static double[] cs_xxHH = {116, 584, 780, 399, 378, 370, 367, 367};
    public static String[] xxName = {"地球", "水星", "金星", "火星", "木星", "土星", "天王星", "海王星", "冥王星"};
    public static double rad = 180 * 3600 / Math.PI;
    public static double radd = 180 / Math.PI;
    public static double pi2 = Math.PI * 2;
    public static double pi_2 = Math.PI / 2;
    public static double J2000 = 2451545;
    public static double cs_k = 0.2725076;
    public static double cs_k2 = 0.2722810;
    public static double cs_k0 = 109.1222;
    public static double cs_sMoon = cs_k * cs_rEar * 1.0000036 * rad;
    public static double cs_sMoon2 = cs_k2 * cs_rEar * 1.0000036 * rad;
    public static double cs_sSun = 959.64;

    public static double dtT(double t) {
        return dtCalc(t / 365.2425 + 2000) / 86400.0;
    }

    private static double dtCalc(double y) {
        double y0 = DT_AT[DT_AT.length - 2];
        double t0 = DT_AT[DT_AT.length - 1];
        if (y >= y0) {
            int jsd = 31;
            if (y > y0 + 100) {
                return dtExt(y, jsd);
            }
            double v = dtExt(y, jsd);
            double dv = dtExt(y0, jsd) - t0;
            return v - dv * (y0 + 100 - y) / 100;
        }
        int i;
        double[] d = DT_AT;
        for (i = 0; i < d.length; i += 5) {
            if (y < d[i + 5]) {
                break;
            }
        }
        double t1 = (y - d[i]) / (d[i + 5] - d[i]) * 10, t2 = t1 * t1, t3 = t2 * t1;
        return d[i + 1] + d[i + 2] * t1 + d[i + 3] * t2 + d[i + 4] * t3;
    }

    private static double dtExt(double y, int jsd) {
        double dy = (y - 1820) / 100;
        return -20 + jsd * dy * dy;
    }

    public static double XL0Calc(int xt, int zn, double t, int n) {
        t /= 10;
        int i, j;
        double tn = 1;
        double c;
        double v = 0;
        double[] F = XL0[xt];
        double n1, n2, N;
        double n0;
        int pn = zn * 6 + 1;
        double N0 = F[pn + 1] - F[pn];
        for (i = 0; i < 6; i++, tn *= t) {
            n1 = F[pn + i];
            n2 = F[pn + 1 + i];
            n0 = n2 - n1;
            if (n0 == 0) {
                continue;
            }
            if (n < 0) {
                N = n2;
            } else {
                N = int2(3 * n * n0 / N0 + 0.5) + n1;
                if (i != 0) {
                    N += 3;
                }
                if (N > n2) {
                    N = n2;
                }
            }
            for (j = (int) n1, c = 0; j < N; j += 3) {
                c += F[j] * Math.cos(F[j + 1] + t * F[j + 2]);
            }
            v += c * tn;
        }
        v /= F[0];
        if (xt == 0) {
            double t2 = t * t, t3 = t2 * t;
            if (zn == 0) {
                v += (-0.0728 - 2.7702 * t - 1.1019 * t2 - 0.0996 * t3) / rad;
            }
            if (zn == 1) {
                v += (+0.0000 + 0.0004 * t + 0.0004 * t2 - 0.0026 * t3) / rad;
            }
            if (zn == 2) {
                v += (-0.0020 + 0.0044 * t + 0.0213 * t2 - 0.0250 * t3) / 1000000;
            }
        } else {
            double dv = XL0_xzb[(xt - 1) * 3 + zn];
            if (zn == 0) {
                v += -3 * t / rad;
            }
            if (zn == 2) {
                v += dv / 1000000;
            } else {
                v += dv / rad;
            }
        }
        return v;
    }

    public static double XL1Calc(int zn, double t, int n) {
        double[][] ob = XL1[zn];
        int i, j, N;
        double v = 0, tn = 1, c;
        double[] F;
        double t2 = t * t, t3 = t2 * t, t4 = t3 * t, t5 = t4 * t, tx = t - 10;
        if (zn == 0) {
            v += (3.81034409 + 8399.684730072 * t - 3.319e-05 * t2 + 3.11e-08 * t3 - 2.033e-10 * t4) * rad;
            v += 5028.792262 * t + 1.1124406 * t2 + 0.00007699 * t3 - 0.000023479 * t4 - 0.0000000178 * t5;
            if (tx > 0) {
                v += -0.866 + 1.43 * tx + 0.054 * tx * tx;
            }
        }
        t2 /= 1e4;
        t3 /= 1e8;
        t4 /= 1e8;
        n *= 6;
        if (n < 0) {
            n = ob[0].length;
        }
        for (i = 0; i < ob.length; i++, tn *= t) {
            F = ob[i];
            N = int2(n * F.length / (double) ob[0].length + 0.5);
            if (i != 0) {
                N += 6;
            }
            if (N >= F.length) {
                N = F.length;
            }
            for (j = 0, c = 0; j < N; j += 6) {
                c += F[j] * Math.cos(F[j + 1] + t * F[j + 2] + t2 * F[j + 3] + t3 * F[j + 4] + t4 * F[j + 5]);
            }
            v += c * tn;
        }
        if (zn != 2) {
            v /= rad;
        }
        return v;
    }

    public static double gxc_sunLon(double t) {
        double v = -0.043126 + 628.301955 * t - 0.000002732 * t * t;
        double e = 0.016708634 - 0.000042037 * t - 0.0000001267 * t * t;
        return (-20.49552 * (1 + e * Math.cos(v))) / rad;
    }

    public static double gxc_moonLon() {
        return -3.4E-6;
    }

    public static double nutationLon2(double t) {
        double t2 = t * t, dL = 0;
        int i;
        double[] B = nutB;
        double a;
        for (i = 0; i < B.length; i += 5) {
            if (i == 0) {
                a = -1.742 * t;
            } else {
                a = 0;
            }
            dL += (B[i + 3] + a) * Math.sin(B[i] + B[i + 1] * t + B[i + 2] * t2);
        }
        return dL / 100 / rad;
    }

    public static String Dtlpq(LunarData ld, int pjqn, Cal cal) {
        ld.setY(year2Ayear(cal.getCalY()));
        String s = "";
        if (ld.getY() < 1582 || ld.getY() > 1644 || (ld.getY() == 1644 && cal.getCalM() - 0 == 12)) {
            return s;
        }
        double yearshi = 365.2425;
        double qiying = 55.0600;
        double qice = yearshi / 24;
        double pqrgz = ((ld.getY() - 1281) * yearshi + qiying + pjqn * qice) % 60;
        char pqrtg = ChineseFestivals.GAN[(10 + int2(pqrgz) % 10) % 10];
        char pqrdz = ChineseFestivals.ZHI[(12 + int2(pqrgz) % 12) % 12];
        s = s + pqrtg + pqrdz + "日 ";
        double pqrhh = (pqrgz - int2(pqrgz)) * 24;
        char pqrsc = ChineseFestivals.ZHI[(12 + parseInt((pqrhh + 1) / 2)) % 12];
        String pqrsd = ChineseFestivals.S_C_D[parseInt(pqrhh) % 2];
        double pqrmm = (pqrhh - int2(pqrhh)) * 60;
        String pqrsk = ChineseFestivals.TIME_K[parseInt(pqrmm / 14.4)];
        s = s + pqrsc + pqrsd + ' ' + pqrsk + '刻' + ' ' + ChineseFestivals.J_Q_M_C[pjqn] + "|" + ChineseFestivals.Y_M_C[(parseInt((pjqn + 1) / 2.0) + 12) % 12] + '月' + ChineseFestivals.J_Q_J_L[pjqn % 2];
        return s;
    }

    /**
     * 判断年y是否是 -4712 ~ 9999之间，如果不在，则返回错误：即0年
     * PS：实际是不存在0年的，公元是从1年开始的
     *
     * @param y
     * @return
     */
    public static int year2Ayear(int y) {
        return y >= -4712 && y <= 9999 ? y : 0;
    }

    public static double pty_zty2(double t) {
        double L = (1753470142 + 628331965331.8 * t + 5296.74 * t * t) / 1000000000 + Math.PI;
        double[] z = new double[3];
        double E = (84381.4088 - 46.836051 * t) / rad;
        z[0] = XL0Calc(0, 0, t, 5) + Math.PI;
        z[1] = 0;
        z = llrConv(z, E);
        L = rad2rrad(L - z[0]);
        return L / pi2;
    }

    public static double[] llrConv(double[] JW, double E) {
        double[] r = new double[3];
        double J = JW[0], W = JW[1];
        r[0] = atan2(sin(J) * cos(E) - tan(W) * sin(E), cos(J));
        r[1] = asin(cos(E) * sin(W) + sin(E) * cos(W) * sin(J));
        r[2] = JW[2];
        r[0] = rad2mrad(r[0]);
        return r;
    }

    private static double rad2rrad(double v) {
        v = v % (2 * Math.PI);
        if (v <= -Math.PI) {
            return v + 2 * Math.PI;
        }
        if (v > Math.PI) {
            return v - 2 * Math.PI;
        }
        return v;
    }

    private static double rad2mrad(double v) {
        v = v % (2 * Math.PI);
        if (v < 0) {
            return v + 2 * Math.PI;
        }
        return v;
    }
}
