package cn.freelancy.sxtwl4j;

import static cn.freelancy.sxtwl4j.util.NumberUtil.int2;

/**
 * @author Yawei Xi
 * @since 2018-8-8 10:51
 */
public class ChineseFestivals {
    public static final String[] numCn = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十"};
    public static final char[] GAN = {'甲', '乙', '丙', '丁', '戊', '己', '庚', '辛', '壬', '癸'};
    public static final char[] ZHI = {'子', '丑', '寅', '卯', '辰', '巳', '午', '未', '申', '酉', '戌', '亥'};
    public static final String[] SH_X = {"鼠", "牛", "虎", "兔", "龙", "蛇", "马", "羊", "猴", "鸡", "狗", "猪"};
    public static final String[] XI_Z = {"摩羯", "水瓶", "双鱼", "白羊", "金牛", "双子", "巨蟹", "狮子", "处女", "天秤", "天蝎", "射手"};
    public static final String[] Y_X_M_C = {"朔", "上弦", "望", "下弦"};
    public static final String[] J_Q_M_C = {"冬至", "小寒", "大寒", "立春", "雨水", "惊蛰", "春分", "清明", "谷雨", "立夏", "小满", "芒种", "夏至", "小暑", "大暑", "立秋", "处暑", "白露", "秋分", "寒露", "霜降", "立冬", "小雪", "大雪"};
    public static final String[] Y_M_C = {"冬", "腊", "正", "二", "三", "四", "五", "六", "七", "八", "九", "十"};
    public static final String[] R_M_C = {"初一", "初二", "初三", "初四", "初五", "初六", "初七", "初八", "初九", "初十", "十一", "十二", "十三", "十四", "十五", "十六", "十七", "十八", "十九", "二十", "廿一", "廿二", "廿三", "廿四", "廿五", "廿六", "廿七", "廿八", "廿九", "三十", "卅一"};
    public static final String[] G_Z_N_Y = {"大海水", "海中金", "炉中火", "大林木", "路旁土", "剑锋金", "山头火", "洞下水", "城墙土", "白腊金", "杨柳木", "泉中水", "屋上土", "霹雷火", "松柏木", "常流水", "沙中金", "山下火", "平地木", "壁上土", "金箔金", "佛灯火", "天河水", "大驿土", "钗钏金", "桑松木", "大溪水", "沙中土", "天上火", "石榴木", "大海水"};
    public static final String[] S_C_D = {"正", "初"};
    public static final String[] TIME_K = {"初", "一", "二", "三", "四"};
    public static final String[] J_Q_J_L = {"中", "节"};
    private String[] JNB;

    public ChineseFestivals() {
        String s = "-2069,45,0,夏,禹,,禹,-2024,10,0,夏,启,,启,-2014,25,0,夏,太康,,太康,-1986,14,0,夏,仲康,,仲康,-1972,28,0,夏,相,,相,-1944,2,0,夏,后羿,,后羿,-1942,38,0,夏,寒浞,,寒浞,-1904,21,0,夏,少康,,少康,-1883,17,0,夏,杼,,杼,-1866,26,0,夏,槐,,槐,-1840,18,0,夏,芒,,芒,-1822,16,0,夏,泄,,泄,-1806,59,0,夏,不降,,不降,-1747,21,0,夏,扃,,扃,-1726,21,0,夏,廑,,廑,"
                + "-1705,31,0,夏,孔甲,,孔甲,-1674,11,0,夏,皋,,皋,-1663,11,0,夏,发,,发,-1652,53,0,夏,桀,,桀,-1599,11,0,商,商太祖,汤,商汤,-1588,1,0,商,商代王,太乙,商代王,-1587,2,0,商,哀王,子胜,外丙,-1585,4,0,商,懿王,子庸,仲壬,-1581,12,0,商,太宗,子至,太甲,-1569,29,0,商,昭王,子绚,沃丁,-1540,25,0,商,宣王,子辩,太庚,-1515,17,0,商,敬王,子高,小甲,-1498,13,0,商,元王,子密,雍己,-1485,75,0,商,中宗,子伷,太戊,-1410,11,0,商,孝成王,子庄,仲丁,"
                + "-1399,15,0,商,思王,子发,外壬,-1384,9,0,商,前平王,子整,河亶甲,-1375,19,0,商,穆王,子滕,祖乙,-1356,16,0,商,桓王,子旦,祖辛,-1340,5,0,商,僖王,子逾,沃甲,-1335,9,0,商,庄王,子新,祖丁,-1326,6,0,商,顷王,子更,南庚,-1320,7,0,商,悼王,子和,阳甲,-1313,42,0,商,世祖,子旬,盘庚,-1271,21,0,商,章王,子颂,小辛,-1250,1,0,商,惠王,子敛,小乙,-1249,59,0,商,高宗,子昭,武丁,-1190,2,0,商,后平王,子跃,祖庚,-1188,33,0,商,世宗,子载,祖甲,-1155,8,0,商,甲宗,子先,廪辛,"
                + "-1147,1,0,商,康祖,子嚣,庚丁,-1146,35,0,商,武祖,子瞿,武乙,-1111,11,0,商,匡王,子托,文丁,-1100,26,0,商,德王,子羡,帝乙,-1074,29,0,商,纣王,子寿,帝辛,-1045,4,0,西周,武王,姬发,武王,-1041,22,0,西周,成王,姬诵,成王,-1019,25,0,西周,康王,姬钊,康王,-994,19,0,西周,昭王,姬瑕,昭王,-975,54,0,西周,穆王,姬满,穆王,-921,23,0,西周,共王,姬繄,共王,-898,8,0,西周,懿王,姬囏,懿王,-890,6,0,西周,孝王,姬辟方,孝王,-884,8,0,西周,夷王,姬燮,夷王,-876,36,0,西周,厉王,姬胡,厉王,"
                + "-840,14,0,西周,厉王,姬胡,共和,-826,46,0,西周,宣王,姬静,宣王,-780,11,0,西周,幽王,姬宫湦,幽王,-769,51,0,东周,平王,姬宜臼,平王,-718,23,0,东周,桓王,姬林,桓王,-695,15,0,东周,庄王,姬佗,庄王,-680,5,0,东周,釐王,姬胡齐,釐王,-675,25,0,东周,惠王,姬阆,惠王,-650,33,0,东周,襄王,姬郑,襄王,-617,6,0,东周,顷王,姬壬臣,顷王,-611,6,0,东周,匡王,姬班,匡王,-605,21,0,东周,定王,姬瑜,定王,-584,14,0,东周,简王,姬夷,简王,-570,27,0,东周,灵王,姬泄心,灵王,-543,24,0,东周,景王,姬贵,景王,"
                + "-519,1,0,东周,悼王,姬勐,悼王,-518,44,0,东周,敬王,姬匄,敬王,-474,7,0,东周,元王,姬仁,元王,-467,27,0,东周,贞定王,姬介,贞定王,-440,1,0,东周,哀王-思王,姬去疾-姬叔,哀王-思王,-439,15,0,东周,考王,姬嵬,考王,-424,24,0,东周,威烈王,姬午,威烈王,-400,26,0,东周,安王,姬骄,安王,-374,7,0,东周,烈王,姬喜,烈王,-367,48,0,东周,显王,姬扁,显王,-319,6,0,东周,慎靓王,姬定,慎靓王,-313,8,0,东周,赧王,姬延,赧王,-305,56,0,战国-秦,昭襄王,嬴则,昭襄王,-249,1,0,战国-秦,孝文王,嬴柱,孝文王,-248,3,0,战国-秦,庄襄王,嬴子楚,庄襄王,"
                + "-245,25,0,秦,嬴政,嬴政,嬴政,-220,12,0,秦,始皇帝,嬴政,始皇,-208,3,0,秦,二世皇帝,嬴胡亥,二世,-205,12,0,西汉,高帝,刘邦,高帝,-193,7,0,西汉,惠帝,刘盈,惠帝,-186,8,0,西汉,高后,吕雉,高后,-178,16,0,西汉,文帝,刘恒,文帝,-162,7,0,西汉,文帝,刘恒,后元,-155,7,0,西汉,景帝,刘启,景帝,-148,6,0,西汉,景帝,刘启,中元,-142,3,0,西汉,景帝,刘启,后元,-139,6,0,西汉,武帝,刘彻,建元,-133,6,0,西汉,武帝,刘彻,元光,-127,6,0,西汉,武帝,刘彻,元朔,-121,6,0,西汉,武帝,刘彻,元狩,"
                + "-115,6,0,西汉,武帝,刘彻,元鼎,-109,6,0,西汉,武帝,刘彻,元封,-103,4,0,西汉,武帝,刘彻,太初,-99,4,0,西汉,武帝,刘彻,天汉,-95,4,0,西汉,武帝,刘彻,太始,-91,4,0,西汉,武帝,刘彻,征和,-87,2,0,西汉,武帝,刘彻,后元,-85,6,0,西汉,昭帝,刘弗陵,始元,-79,6,0,西汉,昭帝,刘弗陵,元凤,-73,1,0,西汉,昭帝,刘弗陵,元平,-72,4,0,西汉,宣帝,刘询,本始,-68,4,0,西汉,宣帝,刘询,地节,-64,4,0,西汉,宣帝,刘询,元康,-60,4,0,西汉,宣帝,刘询,神爵,-56,4,0,西汉,宣帝,刘询,五凤,"
                + "-52,4,0,西汉,宣帝,刘询,甘露,-48,1,0,西汉,宣帝,刘询,黄龙,-47,5,0,西汉,元帝,刘奭,初元,-42,5,0,西汉,元帝,刘奭,永光,-37,5,0,西汉,元帝,刘奭,建昭,-32,1,0,西汉,元帝,刘奭,竟宁,-31,4,0,西汉,成帝,刘骜,建始,-27,4,0,西汉,成帝,刘骜,河平,-23,4,0,西汉,成帝,刘骜,阳朔,-19,4,0,西汉,成帝,刘骜,鸿嘉,-15,4,0,西汉,成帝,刘骜,永始,-11,4,0,西汉,成帝,刘骜,元延,-7,2,0,西汉,成帝,刘骜,绥和,-5,4,0,西汉,哀帝,刘欣,建平,-1,2,0,西汉,哀帝,刘欣,元寿,"
                + "1,5,0,西汉,平帝,刘衍,元始,6,2,0,西汉,孺子婴,王莽摄政,居摄,8,1,0,西汉,孺子婴,王莽摄政,初始,9,5,0,新,,王莽,始建国,14,6,0,新,,王莽,天凤,20,3,0,新,,王莽,地皇,23,2,0,西汉,更始帝,刘玄,更始,25,31,0,东汉,光武帝,刘秀,建武,56,2,0,东汉,光武帝,刘秀,建武中元,58,18,0,东汉,明帝,刘庄,永平,76,8,0,东汉,章帝,刘炟,建初,84,3,0,东汉,章帝,刘炟,元和,87,2,0,东汉,章帝,刘炟,章和,89,16,0,东汉,和帝,刘肇,永元,105,1,0,东汉,和帝,刘肇,元兴,"
                + "106,1,0,东汉,殇帝,刘隆,延平,107,7,0,东汉,安帝,刘祜,永初,114,6,0,东汉,安帝,刘祜,元初,120,1,0,东汉,安帝,刘祜,永宁,121,1,0,东汉,安帝,刘祜,建光,122,4,0,东汉,安帝,刘祜,延光,126,6,0,东汉,顺帝,刘保,永建,132,4,0,东汉,顺帝,刘保,阳嘉,136,6,0,东汉,顺帝,刘保,永和,142,2,0,东汉,顺帝,刘保,汉安,144,1,0,东汉,顺帝,刘保,建康,145,1,0,东汉,冲帝,刘炳,永嘉,146,1,0,东汉,质帝,刘缵,本初,147,3,0,东汉,桓帝,刘志,建和,150,1,0,东汉,桓帝,刘志,和平,"
                + "151,2,0,东汉,桓帝,刘志,元嘉,153,2,0,东汉,桓帝,刘志,永兴,155,3,0,东汉,桓帝,刘志,永寿,158,9,0,东汉,桓帝,刘志,延熹,167,1,0,东汉,桓帝,刘志,永康,168,4,0,东汉,灵帝,刘宏,建宁,172,5,0,东汉,灵帝,刘宏,熹平,178,6,0,东汉,灵帝,刘宏,光和,184,6,0,东汉,灵帝,刘宏,中平,190,4,0,东汉,献帝,刘协,初平,194,2,0,东汉,献帝,刘协,兴平,196,24,0,东汉,献帝,刘协,建安,220,7,0,三国-魏,文帝,曹丕,黄初,227,6,0,三国-魏,明帝,曹叡,太和,233,4,0,三国-魏,明帝,曹叡,青龙,"
                + "237,3,0,三国-魏,明帝,曹叡,景初,240,9,0,三国-魏,齐王,曹芳,正始,249,5,0,三国-魏,齐王,曹芳,嘉平,254,2,0,三国-魏,高贵乡公,曹髦,正元,256,4,0,三国-魏,高贵乡公,曹髦,甘露,260,4,0,三国-魏,元帝,曹奂,景元,264,1,0,三国-魏,元帝,曹奂,咸熙,265,10,0,西晋,武帝,司马炎,泰始,275,5,0,西晋,武帝,司马炎,咸宁,280,10,0,西晋,武帝,司马炎,太康,290,10,0,西晋,武帝,司马炎,太熙,300,1,0,西晋,惠帝,司马衷,永康,301,1,0,西晋,惠帝,司马衷,永宁,302,2,0,西晋,惠帝,司马衷,太安,304,2,0,西晋,惠帝,司马衷,永安,"
                + "306,1,0,西晋,惠帝,司马衷,光熙,307,6,0,西晋,怀帝,司马炽,永嘉,313,4,0,西晋,愍帝,司马邺,建兴,317,1,0,东晋,元帝,司马睿,建武,318,4,0,东晋,元帝,司马睿,大兴,322,1,0,东晋,元帝,司马睿,永昌,323,3,0,东晋,明帝,司马绍,太宁,326,9,0,东晋,成帝,司马衍,咸和,335,8,0,东晋,成帝,司马衍,咸康,343,2,0,东晋,康帝,司马岳,建元,345,12,0,东晋,穆帝,司马聃,永和,357,5,0,东晋,穆帝,司马聃,升平,362,1,0,东晋,哀帝,司马丕,隆和,363,3,0,东晋,哀帝,司马丕,兴宁,366,5,0,东晋,海西公,司马奕,太和,"
                + "371,2,0,东晋,简文帝,司马昱,咸安,373,3,0,东晋,孝武帝,司马曜,甯康,376,21,0,东晋,孝武帝,司马曜,太元,397,5,0,东晋,安帝,司马德宗,隆安,402,3,0,东晋,安帝,司马德宗,元兴,405,14,0,东晋,安帝,司马德宗,义熙,419,1,0,东晋,恭帝,司马德文,元熙,420,3,0,南朝/宋,武帝,刘裕,永初,423,2,0,南朝/宋,少帝,刘义符,景平,424,30,0,南朝/宋,文帝,刘義隆,元嘉,454,3,0,南朝/宋,孝武,帝刘骏,孝建,457,8,0,南朝/宋,孝武,帝刘骏,大明,465,1,0,南朝/宋,废帝,刘子业,永光,465,1,0,南朝/宋,废帝,刘子业,景和,"
                + "465,7,0,南朝/宋,明帝,刘彧,泰始,472,1,0,南朝/宋,明帝,刘彧,泰豫,473,5,0,南朝/宋,废帝,刘昱,元徽,477,3,0,南朝/宋,顺帝,刘准,升明,479,4,0,南朝/齐,高帝,萧道成,建元,483,11,0,南朝/齐,武帝,萧赜,永明,494,1,0,南朝/齐,欎林王,萧昭业,隆昌,494,1,0,南朝/齐,海陵王,萧昭文,延兴,494,5,0,南朝/齐,明帝,萧鸾,建武,498,1,0,南朝/齐,明帝,萧鸾,永泰,499,3,0,南朝/齐,东昏侯,萧宝,中兴,501,2,0,南朝/齐,和帝,萧宝融,中兴,502,18,0,南朝/梁,武帝,萧衍,天监,520,8,0,南朝/梁,武帝,萧衍,普通,527,3,0,南朝/梁,武帝,萧衍,大通,"
                + "529,6,0,南朝/梁,武帝,萧衍,中大通,535,12,0,南朝/梁,武帝,萧衍,大同,546,2,0,南朝/梁,武帝,萧衍,中大同,547,3,0,南朝/梁,武帝,萧衍,太清,550,2,0,南朝/梁,简文帝,萧纲,大宝,551,2,0,南朝/梁,豫章王,萧栋,天正,552,4,0,南朝/梁,元帝,萧绎,承圣,555,1,0,南朝/梁,贞阳侯,萧渊明,天成,555,2,0,南朝/梁,敬帝,萧方智,绍泰,556,2,0,南朝/梁,敬帝,萧方智,太平,557,3,0,南朝/陈,武帝,陈霸先,太平,560,7,0,南朝/陈,文帝,陈蒨,天嘉,566,1,0,南朝/陈,文帝,陈蒨,天康,567,2,0,南朝/陈,废帝,陈伯宗,光大,569,14,0,南朝/陈,宣帝,陈顼,太建,"
                + "583,4,0,南朝/陈,后主,陈叔宝,至德,587,3,0,南朝/陈,后主,陈叔宝,祯明,555,8,0,南朝/后梁,宣帝,萧詧,大定,562,24,0,南朝/后梁,明帝,萧岿,天保,586,2,0,南朝/后梁,莒公,萧琮,广运,386,11,0,北朝/北魏,道武帝,拓跋圭,登国,396,3,0,北朝/北魏,道武帝,拓跋圭,皇始,398,7,0,北朝/北魏,道武帝,拓跋圭,天兴,404,6,0,北朝/北魏,道武帝,拓跋圭,天赐,409,5,0,北朝/北魏,明元帝,拓跋嗣,永兴,414,3,0,北朝/北魏,明元帝,拓跋嗣,神瑞,416,8,0,北朝/北魏,明元帝,拓跋嗣,泰常,424,5,0,北朝/北魏,太武帝,拓跋焘,始光,428,4,0,北朝/北魏,太武帝,拓跋焘,神麚,432,3,0,北朝/北魏,太武帝,拓跋焘,延和,"
                + "435,6,0,北朝/北魏,太武帝,拓跋焘,太延,440,12,0,北朝/北魏,太武帝,拓跋焘,太平真君,451,2,0,北朝/北魏,太武帝,拓跋焘,正平,452,1,0,北朝/北魏,南安王,拓跋余,承平,452,3,0,北朝/北魏,文成帝,拓跋浚,兴安,454,2,0,北朝/北魏,文成帝,拓跋浚,兴光,455,5,0,北朝/北魏,文成帝,拓跋浚,太安,460,6,0,北朝/北魏,文成帝,拓跋浚,和平,466,2,0,北朝/北魏,献文帝,拓跋弘,天安,467,5,0,北朝/北魏,献文帝,拓跋弘,皇兴,471,6,0,北朝/北魏,教文帝,拓跋宏,延兴,476,1,0,北朝/北魏,孝文帝,拓跋宏,承明,477,23,0,北朝/北魏,孝文帝,拓跋宏,太和,500,4,0,北朝/北魏,宣武帝,元恪,景明,504,5,0,北朝/北魏,宣武帝,元恪,正始,"
                + "508,5,0,北朝/北魏,宣武帝,元恪,永平,512,4,0,北朝/北魏,宣武帝,元恪,延昌,516,3,0,北朝/北魏,孝明帝,元诩,熙平,518,3,0,北朝/北魏,孝明帝,元诩,神龟,520,6,0,北朝/北魏,孝明帝,元诩,正光,525,3,0,北朝/北魏,孝明帝,元诩,孝昌,528,1,0,北朝/北魏,孝明帝,元诩,武泰,528,1,0,北朝/北魏,孝庄帝,元子攸,建义,528,3,0,北朝/北魏,孝庄帝,元子攸,永安,530,2,0,北朝/北魏,东海王,元晔,建明,531,2,0,北朝/北魏,节闵帝,元恭,普泰,531,2,0,北朝/北魏,安定王,元朗,中兴,532,1,0,北朝/北魏,孝武帝,元修,太昌,532,1,0,北朝/北魏,孝武帝,元修,永兴,532,3,0,北朝/北魏,孝武帝,元修,永熙,"
                + "534,4,0,北朝/东魏,孝静帝,元善见,天平,538,2,0,北朝/东魏,孝静帝,元善见,元象,539,4,0,北朝/东魏,孝静帝,元善见,兴和,543,8,0,北朝/东魏,孝静帝,元善见,武定,535,17,0,北朝/西魏,文帝,元宝炬,大统,552,3,0,北朝/西魏,废帝,元钦,大统,554,3,0,北朝/西魏,恭帝,元廓,大统,550,10,0,北朝/北齐,文宣帝,高洋,天保,560,1,0,北朝/北齐,废帝,高殷,乾明,560,2,0,北朝/北齐,孝昭帝,高演,皇建,561,2,0,北朝/北齐,武成帝,高湛,太宁,562,4,0,北朝/北齐,武成帝,高湛,河清,565,5,0,北朝/北齐,温公,高纬,天统,570,7,0,北朝/北齐,温公,高纬,武平,576,2,0,北朝/北齐,温公,高纬,隆化,"
                + "576,1,0,北朝/北齐,安德王,高延宗,德昌,577,1,0,北朝/北齐,幼主,高恒,承光,557,1,0,北朝/北周,闵帝,宇文觉,空,557,2,0,北朝/北周,明帝,宇文毓,空,559,2,0,北朝/北周,明帝,宇文毓,武成,561,5,0,北朝/北周,武帝,宇文邕,保定,566,7,0,北朝/北周,武帝,宇文邕,天和,572,7,0,北朝/北周,武帝,宇文邕,建德,578,1,0,北朝/北周,武帝,宇文邕,宣政,579,1,0,北朝/北周,宣帝,宇文贇,大成,579,2,0,北朝/北周,静帝,宇文衍,大象,581,1,0,北朝/北周,静帝,宇文衍,大定,581,20,0,隋,文帝,杨坚,开皇,601,4,0,隋,文帝,杨坚,仁寿,605,13,0,隋,炀帝,杨广,大业,"
                + "617,2,0,隋,恭帝,杨侑,义宁,618,9,0,唐,高祖,李渊,武德,627,23,0,唐,太宗,李世民,贞观,650,6,0,唐,高宗,李治,永徽,656,6,0,唐,高宗,李治,显庆,661,3,0,唐,高宗,李治,龙朔,664,2,0,唐,高宗,李治,麟德,666,3,0,唐,高宗,李治,乾封,668,3,0,唐,高宗,李治,总章,670,5,0,唐,高宗,李治,咸亨,674,3,0,唐,高宗,李治,上元,676,4,0,唐,高宗,李治,仪凤,679,2,0,唐,高宗,李治,调露,680,2,0,唐,高宗,李治,永隆,681,2,0,唐,高宗,李治,开耀,"
                + "682,2,0,唐,高宗,李治,永淳,683,1,0,唐,高宗,李治,弘道,684,1,0,唐,中宗,李显,嗣圣,684,1,0,唐,睿宗,李旦,文明,684,1,0,武周,则天后,武曌,光宅,685,4,0,武周,则天后,武曌,垂拱,689,1,0,武周,则天后,武曌,永昌,689,2,0,武周,则天后,武曌,载初,690,3,0,武周,则天后,武曌,天授,692,1,0,武周,则天后,武曌,如意,692,3,0,武周,则天后,武曌,长寿,694,1,0,武周,则天后,武曌,延载,695,1,0,武周,则天后,武曌,证圣,695,2,0,武周,则天后,武曌,天册万岁,696,1,0,武周,则天后,武曌,万岁登封,"
                + "696,2,0,武周,则天后,武曌,万岁通天,697,1,0,武周,则天后,武曌,神功,698,3,0,武周,则天后,武曌,圣历,700,1,0,武周,则天后,武曌,久视,701,1,0,武周,则天后,武曌,大足,701,4,0,武周,则天后,武曌,长安,705,1,0,武周,则天后,李显,神龙,705,2,0,唐,中宗,李显,神龙,707,4,0,唐,中宗,李显,景龙,710,1,0,唐,温王,李重茂,唐隆,710,2,0,唐,睿宗,李旦,景云,712,1,0,唐,睿宗,李旦,太极,712,1,0,唐,睿宗,李旦,延和,712,2,0,唐,玄宗,李隆基,先天,713,29,0,唐,玄宗,李隆基,开元,"
                + "742,15,0,唐,玄宗,李隆基,天宝,756,3,0,唐,肃宗,李亨,至德,758,3,0,唐,肃宗,李亨,乾元,760,3,0,唐,肃宗,李亨,上元,762,2,0,唐,肃宗,李亨,宝应,763,2,0,唐,代宗,李豫,广德,765,2,0,唐,肃宗,李亨,永泰,766,14,0,唐,肃宗,李亨,大历,780,4,0,唐,德宗,李适,建中,784,1,0,唐,德宗,李适,兴元,785,21,0,唐,德宗,李适,贞元,805,1,0,唐,顺宗,李诵,永贞,806,15,0,唐,宪宗,李纯,元和,821,4,0,唐,穆宗,李恒,长庆,825,3,0,唐,敬宗,李湛,宝历,"
                + "827,9,0,唐,文宗,李昂,大和,836,5,0,唐,文宗,李昂,开成,841,6,0,唐,武宗,李炎,会昌,847,14,0,唐,宣宗,李忱,大中,860,15,0,唐,宣宗,李忱,咸通,874,6,0,唐,僖宗,李儇,乾符,880,2,0,唐,僖宗,李儇,广明,881,5,0,唐,僖宗,李儇,中和,885,4,0,唐,僖宗,李儇,光启,888,1,0,唐,僖宗,李儇,文德,889,1,0,唐,昭宗,李晔,龙纪,890,2,0,唐,昭宗,李晔,大顺,892,2,0,唐,昭宗,李晔,景福,894,5,0,唐,昭宗,李晔,乾宁,898,4,0,唐,昭宗,李晔,光化,"
                + "901,4,0,唐,昭宗,李晔,天复,904,1,0,唐,昭宗,李晔,天佑,905,3,1,唐,昭宣帝,李祝,天佑,907,5,0,五代/梁,太祖,朱温,开平,911,2,0,五代/梁,太祖,朱温,乾化,913,1,0,五代/梁,庶人,朱友圭,凤历,913,3,2,五代/梁,末帝,朱友贞,乾化,915,7,0,五代/梁,末帝,朱友贞,贞明,921,3,0,五代/梁,末帝,朱友贞,龙德,923,4,0,五代/唐,庄宗,李存勗,同光,926,5,0,五代/唐,明宗,李嗣源,天成,930,4,0,五代/唐,明宗,李嗣源,长兴,934,1,0,五代/唐,闵帝,李从厚,应顺,934,3,0,五代/唐,潞王,李从珂,清泰,936,6,0,五代/晋,高祖,石敬瑭,天福,"
                + "942,2,6,五代/晋,出帝,石重贵,天福,944,3,0,五代/晋,出帝,石重贵,开运,947,12,0,五代/汉,高祖,刘知远,天福,948,1,0,五代/汉,隐帝,刘承祐,乾祐,948,3,0,五代/汉,隐帝,刘承祐,乾祐,951,3,0,五代/周,太祖,郭威,广顺,954,1,0,五代/周,太祖,郭威,显德,954,6,0,五代/周,世宗,柴荣,显德,959,2,5,五代/周,恭帝,郭宗训,显德,960,4,0,北宋,太祖,赵匡胤,建隆,963,6,0,北宋,太祖,赵匡胤,乾德,968,9,0,北宋,太祖,赵匡胤,开宝,976,9,0,北宋,太宗,赵炅,太平兴国,984,4,0,北宋,太宗,赵炅,雍熙,988,2,0,北宋,太宗,赵炅,端拱,"
                + "990,5,0,北宋,太宗,赵炅,淳化,995,3,0,北宋,太宗,赵炅,至道,998,6,0,北宋,真宗,赵恒,咸平,1004,4,0,北宋,真宗,赵恒,景德,1008,9,0,北宋,真宗,赵恒,大中祥符,1017,5,0,北宋,真宗,赵恒,天禧,1022,1,0,北宋,真宗,赵恒,乾兴,1023,10,0,北宋,仁宗,赵祯,天圣,1032,2,0,北宋,仁宗,赵祯,明道,1034,5,0,北宋,仁宗,赵祯,景祐,1038,3,0,北宋,仁宗,赵祯,宝元,1040,2,0,北宋,仁宗,赵祯,康定,1041,8,0,北宋,仁宗,赵祯,庆历,1049,6,0,北宋,仁宗,赵祯,皇祐,1054,3,0,北宋,仁宗,赵祯,至和,"
                + "1056,8,0,北宋,仁宗,赵祯,嘉祐,1064,4,0,北宋,英宗,赵曙,治平,1068,10,0,北宋,神宗,赵顼,熙宁,1078,8,0,北宋,神宗,赵顼,元丰,1086,9,0,北宋,哲宗,赵煦,元祐,1094,5,0,北宋,哲宗,赵煦,绍圣,1098,3,0,北宋,哲宗,赵煦,元符,1101,1,0,北宋,徽宗,赵佶,建中靖国,1102,5,0,北宋,徽宗,赵佶,崇宁,1107,4,0,北宋,徽宗,赵佶,大观,1111,8,0,北宋,徽宗,赵佶,政和,1118,2,0,北宋,徽宗,赵佶,重和,1119,7,0,北宋,徽宗,赵佶,宣和,1126,2,0,北宋,钦宗,赵桓,靖康,1127,4,0,南宋,高宗,赵构,建炎,"
                + "1131,32,0,南宋,高宗,赵构,绍兴,1163,2,0,南宋,孝宗,赵慎,隆兴,1165,9,0,南宋,孝宗,赵慎,乾道,1174,16,0,南宋,孝宗,赵慎,淳熙,1190,5,0,南宋,光宗,赵暴,绍熙,1195,6,0,南宋,宁宗,赵扩,庆元,1201,4,0,南宋,宁宗,赵扩,嘉泰,1205,3,0,南宋,宁宗,赵扩,开禧,1208,17,0,南宋,宁宗,赵扩,嘉定,1225,3,0,南宋,理宗,赵昀,宝庆,1228,6,0,南宋,理宗,赵昀,绍定,1234,3,0,南宋,理宗,赵昀,端平,1237,4,0,南宋,理宗,赵昀,嘉熙,1241,12,0,南宋,理宗,赵昀,淳祐,1253,6,0,南宋,理宗,赵昀,寶祐,"
                + "1259,1,0,南宋,理宗,赵昀,开庆,1260,5,0,南宋,理宗,赵昀,景定,1265,10,0,南宋,度宗,赵禥,咸淳,1275,2,0,南宋,恭宗,赵(上“日”下“丝”),德祐 ,1276,3,0,南宋,端宗,赵(上“日”下“正”),景炎,1278,2,0,南宋,帝昺,赵昺,祥兴,1271,24,7,元,世祖,孛儿只斤·忽必烈,至元,1295,3,0,元,成宗,孛儿只斤·铁穆耳,元贞,1297,11,0,元,成宗,孛儿只斤·铁穆耳,大德,1308,4,0,元,武宗,孛儿只斤·海山,至大,1312,2,0,元,仁宗,孛儿只斤·爱育黎拔力八达,皇庆,1314,7,0,元,仁宗,孛儿只斤·愛育黎拔力八達,延祐,1321,3,0,元,英宗,孛儿只斤·宗硕德八剌,至治,1324,5,0,元,泰定帝,孛儿只斤·也孙铁木耳,泰定,1328,1,0,元,泰定帝,孛儿只斤·也孙铁木耳,至和,"
                + "1328,1,0,元,幼主,孛儿只斤·阿速吉八,天顺,1328,3,0,元,文宗,孛儿只斤·图贴睦尔,天历,1330,3,0,元,文宗,孛儿只斤·图贴睦尔,至顺,1333,3,0,元,惠宗,孛儿只斤·妥镤贴睦尔,元统,1335,6,0,元,惠宗,孛儿只斤·妥镤贴睦尔,至元,1341,28,0,元,惠宗,孛儿只斤·妥镤贴睦尔,至正,1368,31,0,明,太祖,朱元璋,洪武,1399,4,0,明,惠帝,朱允溫,建文,1403,22,0,明,成祖,朱棣,永乐,1425,1,0,明,仁宗,朱高炽,洪熙,1426,10,0,明,宣宗,朱瞻基,宣德,1436,14,0,明,英宗,朱祁镇,正统,1450,7,0,明,代宗,朱祁钰,景泰,1457,8,0,明,英宗,朱祁镇,天顺,1465,23,0,明,宪宗,朱见深,成化,"
                + "1488,18,0,明,孝宗,朱祐樘,弘治,1506,16,0,明,武宗,朱厚照,正德,1522,45,0,明,世宗,朱厚熜,嘉靖,1567,6,0,明,穆宗,朱载贺,隆庆,1573,48,0,明,神宗,朱翊钧,万历,1620,1,0,明,光宗,朱常洛,泰昌,1621,7,0,明,熹宗,朱同校,天启,1628,17,0,明,毅宗,朱由检,崇祯,1644,18,0,清,世祖,爱新觉罗福临,顺治,1662,61,0,清,圣祖,爱新觉罗玄烨,康熙,1723,13,0,清,世宗,爱新觉罗胤禛,雍正,1736,60,0,清,高宗,爱新觉罗弘历,乾隆,1796,25,0,清,仁宗,爱新觉罗颙琰,嘉庆,1821,30,0,清,宣宗,爱新觉罗旻宁,道光,1851,11,0,清,文宗,爱新觉罗奕詝,咸丰,"
                + "1862,13,0,清,穆宗,爱新觉罗载淳,同治,1875,34,0,清,德宗,爱新觉罗载湉,光绪,1909,3,0,清,无朝,爱新觉罗溥仪,宣统,1912,37,0,近、现代,中华民国,,民国,1949,9999,1948,当代,中国,,公历纪元";
        JNB = s.split(",");
//        for (int i = 0; i < JNB.length; i += 7) {
//            JNB[i] -= 0;
//            JNB[i + 1] -= 0;
//            JNB[i + 2] -= 0;
//        }
    }

    public String getNH(int y) {
        int j;
        String c;
        String s = "";
        String[] ob = JNB;
        for (int i = 0; i < ob.length; i += 7) {
            j = Integer.parseInt(ob[i]);
            if (y < j || y >= j + Integer.parseInt(ob[i + 1])) {
                continue;
            }
            c = ob[i + 6] + (y - j + 1 + Integer.parseInt(ob[i + 2])) + "年";
            s += (!"".equals(s) ? ";" : "") + "[" + ob[i + 3] + "]" + ob[i + 4] + " " + ob[i + 5] + " " + c;
        }
        return s;
    }

    public void getDayName(LunarData u, LunarData r) {
        String d = u.Lmc + (u.Lmc.length() < 2 ? "月" : "") + u.Ldc;
        if (!u.Lleap.equals("闰")) {
            if (d.equals("正月初一")) {
                r.A += "春节 ";
                r.B += "鸡日 ";
                r.C += "元始天尊圣诞.弥勒佛圣诞|";
                r.Fjia = 1;
            }
            if (d.equals("正月初二")) {
                r.B += "大年初二 ";
                r.C += "鸭日 ";
                r.Fjia = 1;
            }
            if (d.equals("正月初三")) {
                r.C += "大年初三 猫日 孙真人圣诞、郝真人圣诞 ";
                r.Fjia = 1;
            }
            if (d.equals("正月初四")) {
                r.C += "狗日 ";
            }
            if (d.equals("正月初五")) {
                r.C += "破五 猪日 路神生日";
            }
            if (d.equals("正月初六")) {
                r.C += "羊日 定光佛圣诞 ";
            }
            if (d.equals("正月初七")) {
                r.C += "人日 ";
            }
            if (d.equals("正月初八")) {
                r.C += "马日 阎王诞 ";
            }
            if (d.equals("正月初九")) {
                r.C += "牛日 玉皇大帝圣诞 ";
            }
            if (d.equals("正月初十")) {
                r.C += "骆驼日 ";
            }
            if (d.equals("正月十三")) {
                r.C += "上灯节 ";
            }
            if (d.equals("正月十四")) {
                r.C += "灯花节 ";
            }
            if (d.equals("正月十五")) {
                r.A += "元宵节 ";
                r.B += "上元节 ";
                r.C += "壮族歌墟节 苗族踩山节 达斡尔族卡钦 上元天官圣、门神户尉圣诞、混元帝君圣诞 ";
            }
            if (d.equals("正月十六")) {
                r.C += "侗族芦笙节(至正月二十) ";
            }
            if (d.equals("正月十七")) {
                r.C += "中人日 ";
            }
            if (d.equals("正月十八")) {
                r.C += "下灯节 ";
            }
            if (d.equals("正月廿五")) {
                r.C += "填仓节 ";
            }
            if (d.equals("正月廿七")) {
                r.C += "老人日 ";
            }
            if (d.equals("正月廿九")) {
                r.C += "送穷日 ";
            }
            if (d.equals("二月初一")) {
                r.C += "瑶族忌鸟节 勾陈圣诞、剑真人圣诞 ";
            }
            if (d.equals("二月初二")) {
                r.B += "春龙节(龙抬头) ";
                r.C += "畲族会亲节 土地正神圣诞 济公诞";
            }
            if (d.equals("二月初三")) {
                r.C += "文昌梓童帝君圣诞 ";
            }
            if (d.equals("二月初六")) {
                r.C += "东华帝君圣诞 ";
            }
            if (d.equals("二月初八")) {
                r.C += "傈傈族刀杆节 释迦牟尼佛出家 昌福真君圣诞 ";
            }
            if (d.equals("二月初九")) {
                r.C += "海空上师生日 ";
            }
            if (d.equals("二月十二")) {
                r.C += "花神诞 ";
            }
            if (d.equals("二月十三")) {
                r.C += "葛真君圣诞 ";
            }
            if (d.equals("二月十五")) {
                r.C += "傈傈族刀杆节 释迦牟尼佛涅槃 九天玄女诞、太上老君圣诞、精忠岳元帅圣诞 ";
            }
            if (d.equals("二月十九")) {
                r.C += "观世音菩萨圣诞 ";
            }
            if (d.equals("二月廿一")) {
                r.C += "普贤菩萨圣诞、水母圣诞 ";
            }
            if (d.equals("二月廿五")) {
                r.C += "玄天圣父真帝圣诞 ";
            }
            if (d.equals("三月初三")) {
                r.B += "北帝诞 ";
                r.C += "苗族黎族歌墟节 王母诞.北极真武玄天大帝圣诞 ";
            }
            if (d.equals("三月初六")) {
                r.C += "眼光娘娘圣诞、张果老圣诞 ";
            }
            if (d.equals("三月十五")) {
                r.C += "白族三月街(至三月二十) 昊天大帝圣诞、玄坛赵公明元帅圣诞、泰山老母诞 ";
            }
            if (d.equals("三月十六")) {
                r.C += "准提菩萨圣诞、山神圣诞 ";
            }
            if (d.equals("三月十八")) {
                r.C += "后土娘娘圣诞、中岳大帝圣诞 ";
            }
            if (d.equals("三月二十")) {
                r.C += "子孙娘娘圣诞 ";
            }
            if (d.equals("三月廿三")) {
                r.B += "天后诞 妈祖诞 ";
            }
            if (d.equals("三月廿八")) {
                r.C += "东岳大帝圣诞、苍颉至圣先师圣诞 ";
            }
            if (d.equals("四月初四")) {
                r.C += "文殊菩萨圣诞 ";
            }
            if (d.equals("四月初八")) {
                r.B += "牛王诞 ";
                r.C += "释迦牟尼佛圣诞 ";
            }
            if (d.equals("四月十二")) {
                r.C += "蛇王诞 ";
            }
            if (d.equals("四月十四")) {
                r.C += "吕纯阳(吕洞宾)祖师圣诞 ";
            }
            if (d.equals("四月十五")) {
                r.C += "佛吉祥日——释迦牟尼佛诞生、成道、涅槃三期同一庆(即南传佛教国家的卫塞节)、钟离祖师圣诞 ";
            }
            if (d.equals("四月十八")) {
                r.C += "锡伯族西迁节 紫徽大帝圣诞 华佗神医诞 ";
            }
            if (d.equals("四月廿八")) {
                r.C += "药王神农圣诞 ";
            }
            if (d.equals("五月初一")) {
                r.C += "南极长生大帝圣诞 ";
            }
            if (d.equals("五月初五")) {
                r.A += "端午节 ";
                r.C += "地坻温元帅圣诞、雷霆邓天君圣诞 ";
                r.Fjia = 1;
            }
            if (d.equals("五月十一")) {
                r.C += "都城隍圣诞 ";
            }
            if (d.equals("五月十三")) {
                r.B += "关帝诞、皇帝诞 ";
                r.C += "阿昌族泼水节.伽蓝菩萨圣诞 ";
            }
            if (d.equals("五月十八")) {
                r.C += "张天师圣诞 ";
            }
            if (d.equals("五月廿二")) {
                r.C += "鄂温克族米阔鲁节 ";
            }
            if (d.equals("五月廿九")) {
                r.C += "瑶族达努节 ";
            }
            if (d.equals("六月初三")) {
                r.C += "护法韦驮尊天菩萨圣诞 ";
            }
            if (d.equals("六月初六")) {
                r.B += "姑姑节 天贶节 ";
                r.C += "壮族祭田节 瑶族尝新节 ";
            }
            if (d.equals("六月十一")) {
                r.C += "王灵官圣诞、马神圣诞 ";
            }
            if (d.equals("六月十九")) {
                r.C += "观世音菩萨成道——此日放生、念佛，功德殊胜 ";
            }
            if (d.equals("六月廿四")) {
                r.B += "火把节、星回节(彝、白、佤、阿昌、纳西、基诺族 ) ";
                r.C += "雷神圣诞、关公诞、荷花仙子诞 ";
            }
            if (d.equals("六月廿六")) {
                r.C += "二郞真君圣诞 ";
            }
            if (d.equals("七月初七")) {
                r.B += "七夕(中国情人节,乞巧节,女儿节 ) ";
            }
            if (d.equals("七月十三")) {
                r.C += "侗族吃新节.大势至菩萨圣诞 ";
            }
            if (d.equals("七月十五")) {
                r.B += "中元节 鬼节 ";
                r.C += "中元地官圣诞 ";
            }
            if (d.equals("七月十八")) {
                r.C += "西王母娘娘圣诞 ";
            }
            if (d.equals("七月十九")) {
                r.C += "值年太岁圣诞 ";
            }
            if (d.equals("七月二十")) {
                r.C += "棉花诞 ";
            }
            if (d.equals("七月廿三")) {
                r.C += "诸葛武侯诞 ";
            }
            if (d.equals("七月廿四")) {
                r.C += "龙树王菩萨圣诞 ";
            }
            if (d.equals("七月三十")) {
                r.C += "地藏菩萨圣诞 ";
            }
            if (d.equals("八月初三")) {
                r.C += "灶王神圣诞 ";
            }
            if (d.equals("八月初十")) {
                r.C += "北岳大帝圣诞 ";
            }
            if (d.equals("八月十五")) {
                r.A += "中秋节 ";
                r.Fjia = 1;
            }
            if (d.equals("八月廿二")) {
                r.C += "燃灯佛圣诞 ";
            }
            if (d.equals("九月初三")) {
                r.C += "五瘟圣诞 ";
            }
            if (d.equals("九月初九")) {
                r.B += "重阳节 ";
                r.C += "老人节(2013) 斗母元君圣诞、都天大帝圣诞、梅葛二仙翁圣诞 ";
            }
            if (d.equals("九月十七")) {
                r.C += "金龙四大天王圣诞 ";
            }
            if (d.equals("九月十九")) {
                r.C += "观世音菩萨出家纪念日 ";
            }
            if (d.equals("九月廿二")) {
                r.C += "增福财神圣诞 ";
            }
            if (d.equals("九月三十")) {
                r.C += "药师琉璃光如来圣诞 ";
            }
            if (d.equals("十月初一")) {
                r.B += "祭祖节(十月朝) ";
                r.C += "东皇大帝圣诞 ";
            }
            if (d.equals("十月初五")) {
                r.C += "达摩祖师圣诞 ";
            }
            if (d.equals("十月十五")) {
                r.B += "下元节 ";
                r.C += "下元水天官圣诞 ";
            }
            if (d.equals("十月十六")) {
                r.C += "瑶族盘王节 ";
            }
            if (d.equals("冬月初四")) {
                r.C += "大成至圣先师文宣王孔子圣诞 ";
            }
            if (d.equals("冬月初六")) {
                r.C += "西岳大帝圣诞 ";
            }
            if (d.equals("冬月初七")) {
                r.C += "阿弥陀佛圣诞 ";
            }
            if (d.equals("冬月十一")) {
                r.C += "太乙救苦天尊圣诞 ";
            }
            if (d.equals("冬月十七")) {
                r.C += "阿弥陀佛圣诞 ";
            }
            if (d.equals("冬月十九")) {
                r.C += "日光天子圣诞、大慈至圣九还菩萨圣诞 ";
            }
            if (d.equals("腊月初八")) {
                r.B += "腊八节 ";
                r.C += "释迦如来成道日 ";
            }
            if (d.equals("腊月十六")) {
                r.C += "南岳大帝圣诞 ";
            }
            if (d.equals("腊月二十")) {
                r.C += "鲁班先师圣诞 ";
            }
            if (d.equals("腊月廿一")) {
                r.B += "天庆大帝圣诞 ";
            }
            if (d.equals("腊月廿三")) {
                r.B += "小年 ";
            }
            if (d.equals("腊月廿九")) {
                r.C += "华严菩萨圣诞 ";
            }
        }
        if (u.Lmc2.equals("正")) {
            if (d.equals("腊月三十") && u.Ldn == 30) {
                r.A += "除夕 ";
                r.Fjia = 1;
            }
            if (d.equals("腊月廿九") && u.Ldn == 29) {
                r.A += "除夕 ";
                r.Fjia = 1;
            }
        }
        if (u.Ljq != null && !"".equals(u.Ljq)) {
            if (u.Ljq.equals("清明")) {
                r.A += u.Ljq + " ";
                r.Fjia = 1;
            } else {
                r.B += u.Ljq + " ";
            }
        }
        String w;
        String w2;
        if (u.cur_dz >= 0 && u.cur_dz < 81) {
            w = ChineseFestivals.numCn[(int) (Math.floor(u.cur_dz / 9) + 1)];
            if (u.cur_dz % 9 == 0) {
                r.B += "『" + w + "九』 ";
            }
            r.C += w + "九第" + (u.cur_dz % 9 + 1) + "天 ";
        }
        w = u.Lday2.substring(0, 1);
        w2 = u.Lday2.substring(1, 2);
        if (u.cur_xz >= 20 && u.cur_xz < 30 && w.equals("庚")) {
            r.B += "初伏 ";
        }
        if (u.cur_xz >= 30 && u.cur_xz < 40 && w.equals("庚")) {
            r.B += "中伏 ";
        }
        if (u.cur_lq >= 0 && u.cur_lq < 10 && w.equals("庚")) {
            r.B += "末伏 ";
        }
        if (u.cur_mz >= 0 && u.cur_mz < 10 && w.equals("丙")) {
            r.B += "入梅 ";
        }
        if (u.cur_xs >= 0 && u.cur_xs < 12 && w2.equals("未")) {
            r.B += "出梅 ";
        }
    }

    public void mingLiBaZi(double jd, double J, BaZi ob) {
        int i;
        String c;
        int v;
        int ny;
        double jd2 = jd + Common.dtT(jd);
        double w = XL.SALon(jd2 / 36525, -1);
        int k = int2((w / Common.pi2 * 360 + 45 + 15 * 360) / 30);
        jd += Common.pty_zty2(jd2 / 36525) + J / Math.PI / 2;
        ob.setTrueSolarTime(JD.timeStr(jd));
        jd += 13 / 24.0;
        int D = int2(jd);
        int SC = int2((jd - D) * 12);
        v = int2(k / 12.0 + 6000000);
        ob.setNianGan(GAN[v % 10]);
        ob.setNianZhi(ZHI[v % 12]);
        ob.setNaYin4Year(G_Z_N_Y[(int) Math.round(((60 + (v + 1) % 60) % 60) / 2.0)]);
        v = k + 2 + 60000000;
        ob.setYueGan(GAN[v % 10]);
        ob.setYueZhi(ZHI[v % 12]);
        ob.setNaYin4Month(G_Z_N_Y[(int) Math.round((((60 + (v + 1) % 60) % 60) / 2.0))]);
        v = D - 6 + 9000000;
        ob.setRiGan(GAN[v % 10]);
        ob.setRiZhi(ZHI[v % 12]);
        ob.setNaYin4Day(G_Z_N_Y[(int) Math.round((((60 + (v + 1) % 60) % 60) / 2.0))]);
        v = (D - 1) * 12 + 90000000 + SC;
        ob.setShiGan(GAN[v % 10]);
        ob.setShiZhi(ZHI[v % 12]);
        ob.setNaYin4Hour(G_Z_N_Y[(int) Math.round((((60 + (v + 1) % 60) % 60) / 2.0))]);
        v -= SC;
        ob.setJiShi("");
        for (i = 0; i < 13; i++) {
            c = GAN[(v + i) % 10] + "" + ZHI[(v + i) % 12];
            if (SC == i) {
                ob.setJiShi(c);
                c = "<font color=red>" + c + "</font>";
                ob.setNaYin(G_Z_N_Y[(int) Math.round((((60 + (v + i + 1) % 60) % 60) / 2.0))]);
            }
            ob.setJiShi(ob.getJiShi() + (i != 0 ? " " : "") + c);
        }
    }

    public double qi_accurate(double W) {
        double t = XL.SALonT(W) * 36525;
        return t - Common.dtT(t) + 8 / 24.0;
    }

    public double so_accurate(double W) {
        double t = XL.MS_aLon_t(W) * 36525;
        return t - Common.dtT(t) + 8 / 24.0;
    }

    public double qi_accurate2(double jd) {
        double d = Math.PI / 12;
        double w = Math.floor((jd + 293) / 365.2422 * 24) * d;
        double a = this.qi_accurate(w);
        if (a - jd > 5) {
            return this.qi_accurate(w - d);
        }
        if (a - jd < -5) {
            return this.qi_accurate(w + d);
        }
        return a;
    }

    public double so_accurate2(double jd) {
        return this.so_accurate(Math.floor((jd + 8) / 29.5306) * Math.PI * 2);
    }
}
