/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.ruledetail.parse;

import cn.fraudmetrix.riskservice.ruledetail.parse.Convert;
import cn.fraudmetrix.riskservice.ruledetail.parse.ConvertPrimary;
import cn.fraudmetrix.riskservice.ruledetail.parse.DecodeJavaBean;
import cn.fraudmetrix.riskservice.ruledetail.parse.DecodeList;
import cn.fraudmetrix.riskservice.ruledetail.parse.DecodeNothing;
import cn.fraudmetrix.riskservice.ruledetail.parse.Format;
import cn.fraudmetrix.riskservice.ruledetail.parse.FormatProvider;
import cn.fraudmetrix.riskservice.ruledetail.parse.PublicFormatProvider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.List;

public class PublicFormat
implements Format {
    private final Type sourceType;
    private Convert decoder;

    public PublicFormat(Type sourceType) {
        this.sourceType = sourceType;
        this.decoder = this.getDecoder();
    }

    @Override
    public Object decode(Object json) {
        return this.decoder.run(json);
    }

    private Convert getDecoder() {
        if (this.sourceType == null) {
            return new DecodeNothing();
        }
        if (this.isPrimaryType(this.sourceType)) {
            return new ConvertPrimary(this.sourceType);
        }
        if (this.isListType(this.sourceType)) {
            Type elementType = this.getListElementType(this.sourceType);
            return new DecodeList(this.getProvider(), elementType);
        }
        if (this.sourceType instanceof Class) {
            return DecodeJavaBean.create(this.getProvider(), (Class)this.sourceType);
        }
        return new DecodeNothing();
    }

    private FormatProvider getProvider() {
        return PublicFormatProvider.getInstance();
    }

    private boolean isListType(Type type) {
        Type result = this.getListElementType(type);
        return result != null;
    }

    private Type getListElementType(Type type) {
        if (type == null) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        if (rawType != List.class) {
            return null;
        }
        Type[] args = ((ParameterizedType)type).getActualTypeArguments();
        if (args.length != 1) {
            return null;
        }
        return args[0];
    }

    private boolean isPrimaryType(Type type) {
        if (type == Integer.TYPE) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Long.TYPE) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type == Boolean.TYPE) {
            return true;
        }
        if (type == Timestamp.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        if (type == Float.TYPE) {
            return true;
        }
        if (type == Double.class) {
            return true;
        }
        return type == Double.TYPE;
    }
}

