/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.object.RiskResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

public class RiskServiceClient {
    private static final Log log = LogFactory.getLog(RiskServiceClient.class);
    private String apiUrl;
    private static final String DEFAULT_CHARSET = "utf-8";
    private NameValuePair partnerCode;
    private String charset;
    private String appDataSecrectKey;
    private CloseableHttpClient httpClient;
    private static final RiskServiceClient instance = new RiskServiceClient();
    private static boolean inited;
    private RequestConfig globalRequestConfig;
    private String sslCertPath;

    private RiskServiceClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel, boolean heartbeatSwitch, String appDataSecrectKey) {
        RiskServiceClient riskServiceClient = instance;
        synchronized (riskServiceClient) {
            if (inited) {
                return;
            }
            inited = true;
        }
        Asserts.notBlank((CharSequence)partnerCode, (String)"partnerCode");
        Asserts.check((connectTimeout >= 500 ? 1 : 0) != 0, (String)"connectTimeout must >= 500ms.");
        Asserts.check((readTimeout >= 500 ? 1 : 0) != 0, (String)"readTimeout must >= 500ms.");
        Asserts.check((maxConnection > 0 ? 1 : 0) != 0, (String)"maxConnection must > 0.");
        if (appDataSecrectKey != null) {
            this.appDataSecrectKey = appDataSecrectKey;
        }
        if (null == environment) {
            environment = Environment.PRODUCT;
        }
        this.apiUrl = environment.getApiUrl();
        this.partnerCode = new BasicNameValuePair("partner_code", partnerCode);
        this.charset = null == charset ? DEFAULT_CHARSET : charset;
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(connectTimeout);
        configBuilder.setSocketTimeout(readTimeout);
        configBuilder.setConnectionRequestTimeout(500);
        configBuilder.setStaleConnectionCheckEnabled(true);
        if (proxyModel != null) {
            configBuilder.setProxy(proxyModel.getProxy());
        }
        RequestConfig requestConfig = configBuilder.build();
        this.globalRequestConfig = RequestConfig.copy((RequestConfig)requestConfig).build();
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnSocketFactory()).setDefaultRequestConfig(requestConfig).setMaxConnTotal(maxConnection).setMaxConnPerRoute(maxConnection).build();
        if (heartbeatSwitch) {
            Thread heartbeatThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        RiskServiceClient.this.execute("heartbeat", "heartbeat", null);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                            return;
                        }
                    }
                }
            }, "RiskServiceClient Heartbeat Thread");
            heartbeatThread.setDaemon(true);
            heartbeatThread.start();
        }
    }

    private void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel, boolean heartbeatSwitch) {
        this.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, proxyModel, heartbeatSwitch, null);
    }

    private void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        this.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, null, true);
    }

    public static RiskServiceClient getInstance(String partnerCode) {
        return RiskServiceClient.getInstance(partnerCode, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment) {
        return RiskServiceClient.getInstance(partnerCode, environment, (String)null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, ProxyModel proxyModel) {
        return RiskServiceClient.getInstance(partnerCode, environment, 1000, 1000, 50, null, proxyModel);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, ProxyModel proxyModel, String appDataSecrectKey) {
        return RiskServiceClient.getInstance(partnerCode, environment, 1000, 1000, 50, null, proxyModel, true, appDataSecrectKey);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, boolean heartbeatSwitch) {
        return RiskServiceClient.getInstance(partnerCode, environment, 1000, 1000, 50, null, null, heartbeatSwitch);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, String charset) {
        return RiskServiceClient.getInstance(partnerCode, environment, 1000, 1000, 50, charset);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, String charset) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, 50, charset);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, String appDataSecrectKey, int connectTimeout, int readTimeout, int maxConnection) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, DEFAULT_CHARSET, null, true, appDataSecrectKey);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, proxyModel, true);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel, boolean heartbeatSwitch) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, proxyModel, heartbeatSwitch, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel, boolean heartbeatSwitch, String appDataSecrectKey) {
        instance.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, proxyModel, heartbeatSwitch, appDataSecrectKey);
        return instance;
    }

    private HttpEntity buildRequestEntity(String partner, String secretKey, String eventId, Map<String, String> params) {
        ArrayList<Object> nameValuePairs = new ArrayList<Object>();
        if (partner == null) {
            nameValuePairs.add(this.partnerCode);
        } else {
            nameValuePairs.add(new BasicNameValuePair("partner_code", partner));
        }
        nameValuePairs.add(new BasicNameValuePair("secret_key", secretKey));
        nameValuePairs.add(new BasicNameValuePair("event_id", eventId));
        if (null != params) {
            for (String key : params.keySet()) {
                nameValuePairs.add(new BasicNameValuePair(key, params.get(key)));
            }
        }
        return new UrlEncodedFormEntity(nameValuePairs, Charset.forName(this.charset));
    }

    public RiskResult execute(String secretKey, String eventId, Map<String, String> params) {
        return this.executeByPartner(null, secretKey, eventId, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiskResult executeByPartner(String partnerCode, String secretKey, String eventId, Map<String, String> params) {
        RiskResult riskResult = null;
        HttpPost httpPost = new HttpPost(this.apiUrl);
        if (this.sslCertPath != null && !"".equals(this.sslCertPath)) {
            System.setProperty("javax.net.ssl.trustStore", this.sslCertPath);
            System.setProperty("javax.net.ssl.trustStorePassword", "");
        }
        if (this.globalRequestConfig != null) {
            httpPost.setConfig(RequestConfig.copy((RequestConfig)this.globalRequestConfig).build());
        }
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity(this.buildRequestEntity(partnerCode, secretKey, eventId, params));
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn((Object)("execute failed, response status: " + statusCode));
                RiskResult riskResult2 = null;
                return riskResult2;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                log.warn((Object)"execute failed, response output is null!");
                RiskResult riskResult3 = null;
                return riskResult3;
            }
            String result = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            result = result.trim();
            log.debug((Object)("execute result: " + result));
            riskResult = (RiskResult)JSON.parseObject((String)result, RiskResult.class);
        }
        catch (Exception e) {
            if (!"heartbeat".equals(secretKey)) {
                log.error((Object)"execute throw exception, details: ", (Throwable)e);
                riskResult = RiskResult.failedWithReason("000:" + e.toString());
            }
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                }
                finally {
                    httpPost.releaseConnection();
                }
            }
        }
        return riskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiskResult executeWithSecret(String secretKey, String eventId, Map<String, String> params) {
        Asserts.notBlank((CharSequence)this.appDataSecrectKey, (String)"appDataSecrectKey\u4e0d\u80fd\u4e3a\u7a7a");
        RiskResult riskResult = null;
        HttpPost httpPost = new HttpPost(this.apiUrl);
        if (this.globalRequestConfig != null) {
            httpPost.setConfig(RequestConfig.copy((RequestConfig)this.globalRequestConfig).build());
        }
        String partnerCodeValue = this.partnerCode.getValue();
        httpPost.addHeader("X-Partner-Code", partnerCodeValue);
        params.put("partner_code", partnerCodeValue);
        params.put("secret_key", secretKey);
        params.put("event_id", eventId);
        String base64 = this.encrypt(JSONObject.toJSONString(params), this.appDataSecrectKey);
        if (base64 == null) {
            log.error((Object)"\u8bf7\u68c0\u67e5\u79d8\u94a5\u662f\u5426\u5408\u6cd5,\u53c2\u6570\u52a0\u5bc6\u5931\u8d25");
            riskResult = RiskResult.failedWithReason("000:\u53c2\u6570\u52a0\u5bc6\u5931\u8d25");
            return riskResult;
        }
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(base64, ContentType.APPLICATION_OCTET_STREAM));
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn((Object)("execute failed, response status: " + statusCode));
                RiskResult riskResult2 = null;
                return riskResult2;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                log.warn((Object)"execute failed, response output is null!");
                RiskResult riskResult3 = null;
                return riskResult3;
            }
            String result = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            if ((result = this.decrypt(result, this.appDataSecrectKey)) == null) {
                log.error((Object)"\u8bf7\u68c0\u67e5\u79d8\u94a5\u548c\u53c2\u6570\u662f\u5426\u5408\u6cd5,\u8bf7\u6c42\u7ed3\u679c\u89e3\u5bc6\u5931\u8d25");
                riskResult = RiskResult.failedWithReason("000:\u8bf7\u6c42\u7ed3\u679c\u89e3\u6790\u5931\u8d25");
            } else {
                result = result.trim();
                log.debug((Object)("execute result: " + result));
                riskResult = (RiskResult)JSON.parseObject((String)result, RiskResult.class);
            }
        }
        catch (Exception e) {
            if (!"heartbeat".equals(secretKey)) {
                log.error((Object)"execute throw exception, details: ", (Throwable)e);
                riskResult = RiskResult.failedWithReason("000:" + e.toString());
            }
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                }
                finally {
                    httpPost.releaseConnection();
                }
            }
        }
        return riskResult;
    }

    public String encrypt(String sSrc, String sKey) {
        if (sKey == null) {
            return null;
        }
        if (sKey.length() != 16) {
            return null;
        }
        try {
            byte[] raw = sKey.getBytes(DEFAULT_CHARSET);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes(DEFAULT_CHARSET));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String decrypt(String sSrc, String sKey) {
        if (sKey == null) {
            return null;
        }
        if (sKey.length() != 16) {
            return null;
        }
        try {
            byte[] raw = sKey.getBytes(DEFAULT_CHARSET);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] encrypted = Base64.decodeBase64((String)sSrc);
            byte[] original = cipher.doFinal(encrypted);
            return new String(original, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).useProtocol("TLSv1.2").build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            log.error((Object)e);
        }
        return sslsf;
    }

    public static class RiskServiceClientBuilder {
        private Environment environment;
        private ProxyModel proxyModel;
        private int connectTimeout = 1000;
        private int readTimeout = 1000;
        private int maxConnection = 50;
        private String charset;
        private boolean heartbeatSwitch;
        private String appDataSecrectKey;
        private String partnerCode;
        private String sslCertPath;

        public RiskServiceClientBuilder partnerCode(String partnerCode) {
            this.partnerCode = partnerCode;
            return this;
        }

        public RiskServiceClientBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public RiskServiceClientBuilder proxyModel(ProxyModel proxyModel) {
            this.proxyModel = proxyModel;
            return this;
        }

        public RiskServiceClientBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public RiskServiceClientBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public RiskServiceClientBuilder maxConnection(int maxConnection) {
            this.maxConnection = maxConnection;
            return this;
        }

        public RiskServiceClientBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public RiskServiceClientBuilder appDataSecrectKey(String appDataSecrectKey) {
            this.appDataSecrectKey = appDataSecrectKey;
            return this;
        }

        public RiskServiceClientBuilder heartbeatSwitch(boolean heartbeatSwitch) {
            this.heartbeatSwitch = heartbeatSwitch;
            return this;
        }

        public RiskServiceClientBuilder sslCertPath(String sslCertPath) {
            this.sslCertPath = sslCertPath;
            return this;
        }

        public RiskServiceClient build() {
            if (this.sslCertPath != null) {
                instance.sslCertPath = this.sslCertPath;
            }
            instance.appDataSecrectKey = this.appDataSecrectKey;
            instance.init(this.partnerCode, this.environment, this.connectTimeout, this.readTimeout, this.maxConnection, this.charset, this.proxyModel, this.heartbeatSwitch);
            return instance;
        }
    }
}

