package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Type;
import java.util.List;

import com.alibaba.fastjson.JSONArray;

public class DecodeList implements Convert {

    private FormatProvider format;
    private Type elementType;

    public DecodeList(FormatProvider format, Type elementType){
        this.format = format;
        this.elementType = elementType;
    }

    @Override
    public Object run(Object json) {
        // 检查参数
        if (json == null) return null;
        if (!(json instanceof List)) return null;

        // 对于简单类型，通过getClass获取真正类型
        if (elementType instanceof Class) {
            return runWithType((List) json, elementType);
        }

        // 对于复合类型，将已知参数作为类型
        return runWithType((List) json, elementType);
    }

    private JSONArray runWithType(List<?> list, Type type) {
        Format f = format.getFormat(type);
        JSONArray result = new JSONArray();
        for (Object object : list) {
            // 不处理null数据
            if (object == null) continue;

            // 如果解码失败，不放到结果中
            Object e = f.decode(object);
            if(e == null) continue;
            result.add(e);
        }
        return result;
    }
}
