package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.fastjson.JSONObject;

public class DecodeJavaBeanViaCustomType implements Convert {

    private Log            logger = LogFactory.getLog(DecodeJavaBeanViaCustomType.class);

    private FormatProvider format;
    private Class<?>       sourceType;
    private Method         getType;

    public DecodeJavaBeanViaCustomType(FormatProvider format, Class<?> sourceType){
        this.format = format;
        this.sourceType = sourceType;

        // 获取类型
        this.getType = getTypeMethod(sourceType);
    }

    private Method getTypeMethod(Class<?> sourceType) {
        try {
            Method method = sourceType.getMethod("getType", JSONObject.class);
            if (!isStatic(method)) return null;
            return method;
        } catch (Exception ex) {
            logger.warn("Failed to get type method");
            return null;
        }
    }

    private boolean isStatic(Method method) {
        int m = method.getModifiers();
        return Modifier.isStatic(m);
    }

    @Override
    public Object run(Object o) {
        // 检查参数
        if (o == null) return null;
        if (getType == null) return null;
        if (format == null) return null;

        // 传入参数必须要是json
        if (!(o instanceof JSONObject)) return null;
        JSONObject json = (JSONObject) o;

        // 参数正确，通过getType方法获得对应的类型
        // 返回对象必须是Class类型
        Class<?> resultClass = getType(json);
        if (resultClass == null) return null;

        // 根据对应的Class类型进行反序列化，
        Format f = format.getFormat(resultClass);
        Object result = f.decode(json);

        // 返回成功结果
        return result;
    }

    private Class<?> getType(JSONObject json) {
        // 调用函数
        Object result;
        try {
            result = getType.invoke(sourceType, json);
        } catch (Exception ex) {
            return null;
        }

        // 返回结果必须为Class<?>
        if (!(result instanceof Class)) return null;
        return (Class) result;
    }
}
