package cn.fraudmetrix.riskservice.object;

import org.apache.http.HttpHost;

import java.io.Serializable;

/**
 * Created by qiangzi on 17/3/30.
 */
public class ProxyModel  implements Serializable {

    private static final long serialVersionUID = 3217182486038675145L;

    private String proxyIp;
    private int proxyPort;
    private String proxyProtocol;

    public ProxyModel() {
    }

    public ProxyModel(String proxyIp, int proxyPort) {
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        this.proxyProtocol = "http";
    }

    public ProxyModel(String proxyIp, int proxyPort, String proxyProtocol) {
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyIp() {
        return proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
    }

    public int getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyProtocol() {
        return proxyProtocol;
    }

    public void setProxyProtocol(String proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public HttpHost getProxy(){
        return new HttpHost(proxyIp, proxyPort, proxyProtocol);
    }
}
