/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.riskservice.demo;

import cn.fraudmetrix.riskservice.RuleDetailClient;
import cn.fraudmetrix.riskservice.RuleDetailResult;
import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.ruledetail.BlackListDetail;
import cn.fraudmetrix.riskservice.ruledetail.BlackListHit;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Observable;

/**
 * 仅仅是决策引擎规则详情调用demo
 */
public class RuleDetailDemo extends Observable {

    // 填写参数
    static String partnerCode = "your partner code";
    static String partnerKey = "your partner key";
    static String sequenceId = "your sequence id";
    static Environment env = Environment.PRODUCT; // 调用生产环境
    public static void main(String[] argv) {
        testWithBuilder();
        testNormal();
    }

    //构造方法模式
    public static void testNormal(){
        // 调用接口
        RuleDetailClient client = RuleDetailClient.getInstance(partnerCode, env);
        RuleDetailResult result = client.execute(partnerKey, sequenceId);
        System.out.println(JSONObject.toJSON(result).toString());

        if (result == null) return;

        // 样例：获取黑名单命中的数据
        List<BlackListDetail> find = result.find(BlackListDetail.class);
        for (BlackListDetail e : find) {
            List<BlackListHit> hits = e.getHits();
            for (BlackListHit hit : hits) {
                // hit中包含了命中黑名单的具体信息

            }
        }
    }

    //builder模式
    public static void testWithBuilder(){
        ProxyModel proxyModel = new ProxyModel("192.168.6.32", 8118);
        RuleDetailClient.RuleDetailClientBuilder builder = new RuleDetailClient.RuleDetailClientBuilder();
        RuleDetailClient ruleDetailClient = builder.partnerCode(partnerCode) //合作方,必填值
                .environment(env) //对接环境,可选值:默认生产环境
                .connectTimeout(500)   //连接时间, 可选值: 默认1000
                .readTimeout(2000) //读取时间, 可选值: 默认1000
                .maxConnection(5) //最大连接数, 可选值: 默认50
                .proxyModel(proxyModel) //http代理, 可选值:默认null
                .heartbeatSwitch(false) //是否保持心跳, 可选值:默认true
                .charset("utf-8") //URLencode编码字符集, 可选值:默认utf-8
                .sslCertPath("")
                .build();

        //普通post提交
        RuleDetailResult result = ruleDetailClient.execute(partnerKey, sequenceId);
        System.out.println(JSONObject.toJSONString(result, true));
        if (result == null) return;

        // 样例：获取黑名单命中的数据
        List<BlackListDetail> find = result.find(BlackListDetail.class);
        for (BlackListDetail e : find) {
            List<BlackListHit> hits = e.getHits();
            for (BlackListHit hit : hits) {
                // hit中包含了命中黑名单的具体信息

            }
        }
    }


}
