package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Field;
import java.lang.reflect.Type;

public class PublicFormatProvider implements FormatProvider {

    private static LazyLoadMap<Type, Format>       formats      = new Formats();
    private static LazyLoadMap<Field, FieldFormat> fieldFormats = new FieldFormats();
    private static PublicFormatProvider            instance     = new PublicFormatProvider();

    private static class Formats extends LazyLoadMap<Type, Format> {

        @Override
        public Format create(Type key) {
            return new PublicFormat(key);
        }
    }

    private static class FieldFormats extends LazyLoadMap<Field, FieldFormat> {

        @Override
        public FieldFormat create(Field field) {
            return new PublicFieldFormat(instance, field);
        }
    }

    @Override
    public Format getFormat(Type clazz) {
        return formats.get(clazz);
    }

    @Override
    public FieldFormat getFieldFormat(Field field) {
        return fieldFormats.get(field);
    }

    public static FormatProvider getFormat() {
        return instance;
    }

    public static FormatProvider getInstance() {
        return instance;
    }
}
