package cn.fraudmetrix.riskservice;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by coco on 17/9/15.
 */
public class InfoCheckDetail {

    private HttpsURLConnection conn;

    public String invoke(Map<String,Object> params, String detailUrl) {
        try {

            StringBuilder postBody = new StringBuilder();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                postBody.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(),
                        "utf-8")).append("&");
            }

            if (!params.isEmpty()) {
                postBody.deleteCharAt(postBody.length() - 1);
            }
            String urlData = detailUrl + "?" + postBody.toString();
            URL url = new URL(urlData);
            SSLSocketFactory ssf = (SSLSocketFactory) SSLSocketFactory.getDefault();
            conn = (HttpsURLConnection) url.openConnection();
            conn.setSSLSocketFactory(ssf);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");

            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line).append("\n");
            }
            return result.toString().trim();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        Map params = new HashMap<String,Object>();
        params.put("partner_key","demo");
        params.put("partner_code","demo");
        params.put("sequence_id","123");
        InfoCheckDetail infoCheckDetail = new InfoCheckDetail();
        String detailUrl = "https://apitest.tongdun.cn/risk/dataservice.detail/v1";
        System.out.println(infoCheckDetail.invoke(params,detailUrl));
    }
}
