/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.ruledetail.parse;

import cn.fraudmetrix.riskservice.ruledetail.parse.Convert;
import cn.fraudmetrix.riskservice.ruledetail.parse.Format;
import cn.fraudmetrix.riskservice.ruledetail.parse.FormatProvider;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecodeJavaBeanViaCustomType
implements Convert {
    private Log logger = LogFactory.getLog(DecodeJavaBeanViaCustomType.class);
    private FormatProvider format;
    private Class<?> sourceType;
    private Method getType;

    public DecodeJavaBeanViaCustomType(FormatProvider format, Class<?> sourceType) {
        this.format = format;
        this.sourceType = sourceType;
        this.getType = this.getTypeMethod(sourceType);
    }

    private Method getTypeMethod(Class<?> sourceType) {
        try {
            Method method = sourceType.getMethod("getType", JSONObject.class);
            if (!this.isStatic(method)) {
                return null;
            }
            return method;
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Failed to get type method");
            return null;
        }
    }

    private boolean isStatic(Method method) {
        int m = method.getModifiers();
        return Modifier.isStatic(m);
    }

    @Override
    public Object run(Object o) {
        if (o == null) {
            return null;
        }
        if (this.getType == null) {
            return null;
        }
        if (this.format == null) {
            return null;
        }
        if (!(o instanceof JSONObject)) {
            return null;
        }
        JSONObject json = (JSONObject)o;
        Class<?> resultClass = this.getType(json);
        if (resultClass == null) {
            return null;
        }
        Format f = this.format.getFormat(resultClass);
        Object result = f.decode(json);
        return result;
    }

    private Class<?> getType(JSONObject json) {
        Object result;
        try {
            result = this.getType.invoke(this.sourceType, json);
        }
        catch (Exception ex) {
            return null;
        }
        if (!(result instanceof Class)) {
            return null;
        }
        return (Class)result;
    }
}

