package cn.fraudmetrix.riskservice.object;

import java.io.Serializable;

/**
 * Created by qiangzi on 17/1/12.
 */
public class OutputField implements Serializable{

    private static final long    serialVersionUID = -3320502297169293390L;
    private String field_name;
    private Object value;
    private String type;
    private String desc;

    public String getField_name() {
        return field_name;
    }

    public void setField_name(String field_name) {
        this.field_name = field_name;
    }

    public Object getValue() {
        if("DOUBLE".equals(type) && value != null){
            try{
                return Double.parseDouble(value.toString());
            }
            catch (Exception e){
                return null;
            }
        }
        if("INT".equals(type) && value != null){
            try{
                return Integer.parseInt(value.toString());
            }
            catch (Exception e){
                return null;
            }
        }
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
