package cn.fraudmetrix.riskservice;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

import java.io.InputStream;

/**
 * @author kui.yuan@fraudmetrix.cn
 */
public class Version {

    private static final String POM_PATH = "/META-INF/maven/cn.fraudmetrix/riskservice-client/pom.xml";
    private static String version = "unknown";
    static {
        try {
            InputStream inputStream = RiskServiceClient.class.getResourceAsStream(POM_PATH);

            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(inputStream);
            Element rootElement = document.getRootElement();
            for (Object e: rootElement.getChildren()) {
                Element element = (Element) e;
                if ("version".equals(element.getName())) {
                    version = element.getValue();
                    break;
                }
            }
        } catch (Exception e) {
            // default: version = unknown
        }
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String []args) {
        System.out.println("version = " + version);
    }
}
