package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.object.RiskResult;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;


/**
 * 仅仅是决策引擎api调用demo
 */
public class RiskServiceDemo {

    // 填写参数
    static String partnerCode = "your partner code";
    static String secretKey = "your secret key";
    static String eventId = "your event id";
    static String appDataSecretKey = "your app data secret key";

    public static void main(String[] argv) {

        testWithBuilder();
        testNormal();
    }

    //builder模式: 推荐使用
    public static void testWithBuilder(){
        ProxyModel proxyModel = new ProxyModel("192.168.6.32", 8118);
        RiskServiceClient.RiskServiceClientBuilder builder = new RiskServiceClient.RiskServiceClientBuilder();
        RiskServiceClient riskServiceClient = builder.partnerCode(partnerCode) //合作方,必填值
                .environment(Environment.PRODUCT) //对接环境,可选值:默认生产环境
                .connectTimeout(500)   //连接时间, 可选值: 默认1000
                .readTimeout(2000) //读取时间, 可选值: 默认1000
                .maxConnection(5) //最大连接数, 可选值: 默认50
                .proxyModel(proxyModel) //http代理, 可选值:默认null
                .heartbeatSwitch(false) //是否保持心跳, 可选值:默认true
                .charset("utf-8") //URLencode编码字符集, 可选值:默认utf-8
                .appDataSecrectKey(appDataSecretKey) //加密传输秘钥, 可选值:默认为空
                .sslCertPath("/Users/qiangzi/Downloads/tongdun-cacerts") //证书位置,可选值:默认为空
                .build();

        Map<String, String> params = new HashMap<String, String>();
        params.put("id_number", "tongdun_test_0001");
        params.put("resp_detail_type", "credit_score,application_id");
        //普通post提交
        RiskResult riskResult = riskServiceClient.execute(secretKey, eventId, params);
        System.out.println(JSONObject.toJSONString(riskResult, true));

        //全部参数加密传输
        RiskResult riskResult2 = riskServiceClient.executeWithSecret(secretKey, eventId, params);
        System.out.println(JSONObject.toJSONString(riskResult2, true));
    }

    //构造方法模式
    public static void testNormal(){
        // 调用接口
        RiskServiceClient client = RiskServiceClient.getInstance(partnerCode, Environment.PRODUCT);
        Map<String,String> params = new HashMap<String, String>();
        params.put("abc", "123");
        params.put("device_id", "456");
        RiskResult result = client.execute(secretKey, eventId,params);
        System.out.println(JSONObject.toJSONString(result, true));
    }

}
