/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.RuleDetailResult;
import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.ruledetail.parse.Format;
import cn.fraudmetrix.riskservice.ruledetail.parse.PublicFormatProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

public class RuleDetailClient
extends Observable {
    private static final Log log = LogFactory.getLog(RuleDetailClient.class);
    private String apiUrl;
    private static final String DEFAULT_CHARSET = "utf-8";
    private String partnerCode;
    private String charset;
    private CloseableHttpClient httpClient;
    private static final RuleDetailClient instance = new RuleDetailClient();
    private static boolean inited;
    private String sslCertPath;

    private RuleDetailClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel, boolean heartbeatSwitch) {
        if (!inited) {
            RuleDetailClient ruleDetailClient = instance;
            synchronized (ruleDetailClient) {
                if (inited) {
                    return;
                }
                inited = true;
            }
        } else {
            return;
        }
        if (this.sslCertPath != null && !"".equals(this.sslCertPath)) {
            System.setProperty("javax.net.ssl.trustStore", this.sslCertPath);
        }
        Asserts.notBlank((CharSequence)partnerCode, (String)"partnerCode");
        Asserts.check((connectTimeout >= 500 ? 1 : 0) != 0, (String)"connectTimeout must >= 500ms.");
        Asserts.check((readTimeout >= 500 ? 1 : 0) != 0, (String)"readTimeout must >= 500ms.");
        Asserts.check((maxConnection > 0 ? 1 : 0) != 0, (String)"maxConnection must > 0.");
        if (null == environment) {
            environment = Environment.PRODUCT;
        }
        this.apiUrl = environment.getRuleDetailUrl();
        this.partnerCode = partnerCode;
        this.charset = null == charset ? DEFAULT_CHARSET : charset;
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setMaxTotal(maxConnection);
        connMgr.setDefaultMaxPerRoute(maxConnection);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(connectTimeout);
        configBuilder.setSocketTimeout(readTimeout);
        configBuilder.setConnectionRequestTimeout(500);
        configBuilder.setStaleConnectionCheckEnabled(true);
        if (proxyModel != null) {
            configBuilder.setProxy(proxyModel.getProxy());
        }
        RequestConfig requestConfig = configBuilder.build();
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        if (heartbeatSwitch) {
            Thread heartbeatThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        RuleDetailClient.this.executeHeartbeat();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                            return;
                        }
                    }
                }
            }, "RuleDetailClient Heartbeat Thread");
            heartbeatThread.setDaemon(true);
            heartbeatThread.start();
        }
    }

    private synchronized void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        this.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, null, true);
    }

    public static RuleDetailClient getInstance(String partnerCode) {
        instance.init(partnerCode, Environment.PRODUCT, 1000, 1000, 50, "utf8");
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment) {
        instance.init(partnerCode, environment, 1000, 1000, 50, "utf8");
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment, boolean heartbeatSwitch) {
        instance.init(partnerCode, environment, 1000, 1000, 50, "utf8", null, heartbeatSwitch);
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment, ProxyModel proxyModel) {
        instance.init(partnerCode, environment, 1000, 1000, 50, "utf8", proxyModel, true);
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout) {
        instance.init(partnerCode, environment, connectTimeout, readTimeout, 50, "utf8");
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        instance.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset);
        return instance;
    }

    public static RuleDetailClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset, ProxyModel proxyModel) {
        instance.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset, proxyModel, true);
        return instance;
    }

    private String buildQueryString(Map<String, String> params) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (null != params) {
            for (String key : params.keySet()) {
                nameValuePairs.add(new BasicNameValuePair(key, params.get(key)));
            }
        }
        return URLEncodedUtils.format(nameValuePairs, (Charset)Charset.forName(this.charset));
    }

    public void executeHeartbeat() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partner_code", "heartbeat");
        params.put("partner_key", "heartheat");
        try {
            this.postException(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RuleDetailResult execute(String partnerKey, String sequenceId) {
        return this.execute(partnerKey, sequenceId, null);
    }

    public RuleDetailResult execute(String partnerKey, String sequenceId, String ruleId) {
        return this.execute(partnerKey, sequenceId, ruleId, null);
    }

    public RuleDetailResult execute(String partnerKey, String sequenceId, String ruleId, Boolean isChallenger) {
        JSONObject json;
        String result;
        if (partnerKey == null) {
            throw new RuntimeException("partnerKey\u5fc5\u586b");
        }
        if (sequenceId == null) {
            throw new RuntimeException("sequenceId\u5fc5\u586b");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partner_code", this.partnerCode);
        params.put("partner_key", partnerKey);
        params.put("sequence_id", sequenceId);
        if (ruleId != null) {
            params.put("rule_id", ruleId);
        }
        if (isChallenger != null) {
            params.put("is_challenger", isChallenger.toString());
        }
        if ((result = this.post(params)) == null) {
            return this.error("\u9519\u8bef1");
        }
        if (result.isEmpty()) {
            return this.error("\u9519\u8bef2");
        }
        try {
            json = this.parseJson(result);
            if (json == null) {
                return this.error("\u9519\u8bef3");
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to parse json", (Throwable)ex);
            return this.error("\u9519\u8bef4");
        }
        try {
            Format format = PublicFormatProvider.getInstance().getFormat((Type)((Object)RuleDetailResult.class));
            return (RuleDetailResult)format.decode(json);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to decode RuleDetail");
            return this.error("\u9519\u8bef5");
        }
    }

    private JSONObject parseJson(String json) {
        int features = 0;
        features |= Feature.AutoCloseSource.getMask();
        features |= Feature.InternFieldNames.getMask();
        features |= Feature.AllowUnQuotedFieldNames.getMask();
        features |= Feature.AllowSingleQuotes.getMask();
        features |= Feature.AllowArbitraryCommas.getMask();
        features |= Feature.SortFeidFastMatch.getMask();
        Object result = JSON.parse((String)json, (int)(features |= Feature.IgnoreNotMatch.getMask()));
        if (!(result instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)result;
    }

    private RuleDetailResult error(String message) {
        RuleDetailResult result = new RuleDetailResult();
        result.setSuccess(false);
        result.setReasonCode("000");
        result.setReasonDesc(message);
        return result;
    }

    private String post(Map<String, String> params) {
        try {
            String result = this.postException(params);
            log.debug((Object)("execute result: " + result));
            return result;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to execute http post", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postException(Map<String, String> params) throws Exception {
        String queryString = this.buildQueryString(params);
        HttpGet httpGet = new HttpGet(this.apiUrl + "?" + queryString);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("execute failed, response status: " + statusCode);
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new Exception("execute failed, response output is null!");
            }
            String result = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            String string = result = result.trim();
            return string;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                }
                finally {
                    httpGet.releaseConnection();
                }
            }
        }
    }

    private SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            log.error((Object)e);
        }
        return sslsf;
    }

    public static class RuleDetailClientBuilder {
        private Environment environment;
        private ProxyModel proxyModel;
        private int connectTimeout = 1000;
        private int readTimeout = 1000;
        private int maxConnection = 50;
        private String charset;
        private boolean heartbeatSwitch;
        private String partnerCode;
        private String sslCertPath;

        public RuleDetailClientBuilder partnerCode(String partnerCode) {
            this.partnerCode = partnerCode;
            return this;
        }

        public RuleDetailClientBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public RuleDetailClientBuilder proxyModel(ProxyModel proxyModel) {
            this.proxyModel = proxyModel;
            return this;
        }

        public RuleDetailClientBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public RuleDetailClientBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public RuleDetailClientBuilder maxConnection(int maxConnection) {
            this.maxConnection = maxConnection;
            return this;
        }

        public RuleDetailClientBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public RuleDetailClientBuilder heartbeatSwitch(boolean heartbeatSwitch) {
            this.heartbeatSwitch = heartbeatSwitch;
            return this;
        }

        public RuleDetailClientBuilder sslCertPath(String sslCertPath) {
            this.sslCertPath = sslCertPath;
            return this;
        }

        public RuleDetailClient build() {
            if (this.sslCertPath != null) {
                instance.sslCertPath = this.sslCertPath;
            }
            instance.init(this.partnerCode, this.environment, this.connectTimeout, this.readTimeout, this.maxConnection, this.charset, this.proxyModel, this.heartbeatSwitch);
            return instance;
        }
    }
}

