package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class ConvertPrimary implements Convert {

    private Type targetType;

    public ConvertPrimary(Type targetType){
        this.targetType = targetType;
    }

    @Override
    public Object run(Object o) {
        if (o == null) return null;
        if (targetType == int.class) return asInteger(o);
        if (targetType == Integer.class) return asInteger(o);
        if (targetType == long.class) return asLong(o);
        if (targetType == Long.class) return asLong(o);
        if (targetType == String.class) return asString(o);
        if (targetType == Boolean.class) return asBoolean(o);
        if (targetType == boolean.class) return asBoolean(o);
        if (targetType == Timestamp.class) return asTimestamp(o);
        if (targetType == Float.class) return asFloat(o);
        if (targetType == float.class) return asFloat(o);
        if (targetType == Double.class) return asDouble(o);
        if (targetType == double.class) return asDouble(o);
        return o;
    }

    private Integer asInteger(Object o) {
        if (o instanceof Integer) return (Integer) o;
        if (o instanceof Long) return (Integer) (int) (long) (Long) o;
        return null;
    }

    private Long asLong(Object o) {
        if (o instanceof Long) return (Long) o;
        if (o instanceof Integer) return (Long) (long) (int) (Integer) o;
        return null;
    }

    private String asString(Object o) {
        if (o instanceof String) return (String) o;
        return o.toString();
    }

    private Boolean asBoolean(Object o) {
        if (o instanceof Boolean) return (Boolean) o;
        return null;
    }

    private Timestamp asTimestamp(Object o) {
        if (o instanceof Timestamp) return (Timestamp) o;
        if (o instanceof Long) return new Timestamp((Long) o);
        if (o instanceof Integer) return new Timestamp((Integer) o);
        return null;
    }

    private Float asFloat(Object o) {
        if (o instanceof Float) return (Float) o;
        if (o instanceof Double) return (Float) (float) (double) (Double) o;
        if (o instanceof Long) return (float) (long) (Long) o;
        if (o instanceof Integer) return (float) (int) (Integer) o;
        return null;
    }

    private Double asDouble(Object o) {
        if (o instanceof Double) return (Double) o;
        if (o instanceof Float) return (Double) (double) (float) (Float) o;
        if (o instanceof Long) return (double) (long) (Long) o;
        if (o instanceof Integer) return (double) (int) (Integer) o;
        if (o instanceof BigDecimal) return ((BigDecimal) o).doubleValue();
        return null;
    }
}
