/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.riskservice.object;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 风险决策api结果
 *
 * @author ming.ma@fruadmetrix.cn
 */
public final class RiskResult implements Serializable {

    private static final long   serialVersionUID = 844958112006659504L;
    /**
     * API调用是否成功，失败时，请见{@link RiskResult#reason_code}
     */
    private boolean             success;
    /**
     * 错误码及原因描述，成功执行时为空
     */
    private String              reason_code;
    /**
     * 当前事件的风险分值
     */
    private Integer             final_score;
    /**
     * 当前事件的最终风险决策结果
     */
    private String              final_decision;
    /**
     * 当前事件的风险类型
     */
    private String              risk_type;
    /**
     * 当前事件所命中的规则列表
     */
    private List<HitRule>       hit_rules;
    /**
     * 当前API调用的全局唯一序列ID，用以标识本次API调用
     */
    private String              seq_id;
    /**
     * 云端执行本次风险决策所花费的时间，单位ms
     */
    private Integer             spend_time;
    /**
     * 当前事件关联的设备信息
     */
    private JSONObject          device_info;
    /**
     * 当前事件的地理位置信息
     */
    private JSONObject          geoip_info;

    private Map<String, Object> attribution;                           // 归属地信息

    /**
     * 执行的策略名称, 同{@link RiskResult#policy_set_name}
     *
     * @deprecated
     */
    @Deprecated
    private String              policy_name;
    /**
     * 执行的策略集名称
     */
    private String              policy_set_name;
    /**
     * 策略集具体内容
     */
    private List<Policy>        policy_set;

    /**
     * 自定义结果输出
     */
    private List<OutputField>   output_fields;

    public void setPolicy_name(String policy_name) {
        this.policy_name = policy_name;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setReason_code(String reason_code) {
        this.reason_code = reason_code;
    }

    public void setFinal_score(Integer final_score) {
        this.final_score = final_score;
    }

    public void setFinal_decision(String final_decision) {
        this.final_decision = final_decision;
    }

    public void setRisk_type(String risk_type) {
        this.risk_type = risk_type;
    }

    public void setHit_rules(List<HitRule> hit_rules) {
        this.hit_rules = hit_rules;
    }

    public void setSeq_id(String seq_id) {
        this.seq_id = seq_id;
    }

    public void setSpend_time(Integer spend_time) {
        this.spend_time = spend_time;
    }

    public void setDevice_info(JSONObject device_info) {
        this.device_info = device_info;
    }

    public void setGeoip_info(JSONObject geoip_info) {
        this.geoip_info = geoip_info;
    }

    public void setPolicy_set_name(String policy_set_name) {
        this.policy_set_name = policy_set_name;
    }

    public void setPolicy_set(List<Policy> policy_set) {
        this.policy_set = policy_set;
    }

    /**
     * Gets 当前事件的风险分值.
     *
     * @return Value of 当前事件的风险分值.
     */
    public Integer getFinal_score() {
        return final_score;
    }

    /**
     * Gets 当前事件的最终风险决策结果.
     *
     * @return Value of 当前事件的最终风险决策结果.
     */
    public String getFinal_decision() {
        return final_decision;
    }

    /**
     * Gets 当前事件的风险类型.
     *
     * @return Value of 当前事件的风险类型.
     */
    public String getRisk_type() {
        return risk_type;
    }

    /**
     * Gets 当前API调用的全局唯一序列ID，用以标识本次API调用.
     *
     * @return Value of 当前API调用的全局唯一序列ID，用以标识本次API调用.
     */
    public String getSeq_id() {
        return seq_id;
    }

    /**
     * Gets 执行的策略集名称.
     *
     * @return Value of 执行的策略集名称.
     */
    public String getPolicy_set_name() {
        return policy_set_name;
    }

    /**
     * Gets 当前事件所命中的规则列表.
     *
     * @return Value of 当前事件所命中的规则列表.
     */
    public List<HitRule> getHit_rules() {
        return hit_rules;
    }

    /**
     * Gets 执行的策略名称, 同{@link RiskResult#policy_set_name}
     *
     * @return Value of 执行的策略名称, 同{@link RiskResult#policy_set_name}
     * @deprecated
     */
    public String getPolicy_name() {
        return policy_name;
    }

    /**
     * Gets 云端执行本次风险决策所花费的时间，单位ms.
     *
     * @return Value of 云端执行本次风险决策所花费的时间，单位ms.
     */
    public Integer getSpend_time() {
        return spend_time;
    }

    /**
     * Gets 错误码及原因描述，成功执行时为空.
     *
     * @return Value of 错误码及原因描述，成功执行时为空.
     */
    public String getReason_code() {
        return reason_code;
    }

    /**
     * Gets 当前事件的地理位置信息.
     *
     * @return Value of 当前事件的地理位置信息.
     */
    public JSONObject getGeoip_info() {
        return geoip_info;
    }

    /**
     * Gets 当前事件关联的设备信息.
     *
     * @return Value of 当前事件关联的设备信息.
     */
    public JSONObject getDevice_info() {
        return device_info;
    }

    /**
     * Gets API调用是否成功，失败时，请见{@link RiskResult#reason_code}.
     *
     * @return Value of API调用是否成功，失败时，请见{@link RiskResult#reason_code}.
     */
    public boolean isSuccess() {
        return success;
    }

    /**
     * Gets 策略集具体内容.
     *
     * @return Value of 策略集具体内容.
     */
    public List<Policy> getPolicy_set() {
        return policy_set;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, true);
    }

    public static RiskResult failedWithReason(String reason_code) {
        RiskResult result = new RiskResult();
        result.success = false;
        result.reason_code = reason_code;
        return result;
    }

    public Map<String, Object> getAttribution() {
        return attribution;
    }

    public void setAttribution(Map<String, Object> attribution) {
        this.attribution = attribution;
    }


    public List<OutputField> getOutput_fields() {
        return output_fields;
    }

    public void setOutput_fields(List<OutputField> output_fields) {
        this.output_fields = output_fields;
    }

    /**
     * 根据属性名称获取决策结果自定义输出的属性值,该值可能为null
     */
    public Object getOutputFieldValue(String fieldName){
        if(output_fields == null || output_fields.size() == 0 || fieldName == null){
            return null;
        }
        for(OutputField outputField : output_fields){
            if(fieldName.equals(outputField.getField_name())){
                return outputField.getValue();
            }
        }
        return null;
    }
}
