package cn.fraudmetrix.riskservice.object;

/**
 * 风险决策系统环境枚举
 *
 * @author ming.ma@fruadmetrix.cn
 */
public enum Environment {

    /**
     * 风险决策系统sandbox环境
     */
    SANDBOX("https://apitest.tongdun.cn/riskService/v1.1", "https://apitest.tongdun.cn/risk/rule.detail/v3.2"),
    /**
     * 风险决策系统staging环境
     */
    STAGING("http://apistg.tongdun.cn/riskService/v1.1", "http://apistg.tongdun.cn/risk/rule.detail/v3.2"),
    /**
     * 风险决策系统product环境
     */
    PRODUCT("https://api.tongdun.cn/riskService/v1.1", "https://api.tongdun.cn/risk/rule.detail/v3.2"),
    /**
     * 自定义环境
     */
    CUSTOM(null, null);

    /**
     * 接口地址
     */
    private String apiUrl;
    private String ruleDetailUrl;

    Environment(String apiUrl, String ruleDetailUrl){
        this.apiUrl = apiUrl;
        this.ruleDetailUrl = ruleDetailUrl;
    }

    /**
     * 设置接口地址
     * 
     * @param apiUrl 接口地址
     * @return Environment
     */
    public Environment withApiUrl(String apiUrl) {
        if (null == this.apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        } else throw new UnsupportedOperationException("You can only set apiUrl for CUSTOM mode.");
    }

    /**
     * 获取对应环境的接口地址
     * 
     * @return 接口地址
     */
    public String getApiUrl() {
        if (null == apiUrl) {
            throw new IllegalStateException("You have to set apiUrl for CUSTOM mode first!");
        }
        return apiUrl;
    }

    public void setRuleDetailUrl(String x) {
        ensureCustomEnvironment();
        this.ruleDetailUrl = x;
    }

    public String getRuleDetailUrl() {
        if (ruleDetailUrl == null) {
            throw new IllegalStateException("You have to set url for CUSTOM mode first!");
        }
        return ruleDetailUrl;
    }

    private void ensureCustomEnvironment() {
        if (this != CUSTOM) {
            throw new UnsupportedOperationException("You can only set url for CUSTOM mode.");
        }
    }
}
