/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.ruledetail.BlackListDetail;
import cn.fraudmetrix.riskservice.ruledetail.BlackListHit;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Observable;

/**
 * 仅仅是决策引擎规则详情调用demo
 */
public class RuleDetailDemo extends Observable {

    // 填写参数
    static String partnerCode = "your partner code";
    static String partnerKey = "your partner key";
    static String sequenceId = "your sequence id";

    static Environment env = Environment.PRODUCT; // 调用生产环境

    public static void main(String[] argv) {
        // 填写参数
        testNormal();
        testWithProxy();
    }

    public static void testNormal(){

        // 调用接口
        RuleDetailClient client = RuleDetailClient.getInstance(partnerCode, Environment.STAGING);
        RuleDetailResult result = client.execute(partnerKey, sequenceId);
        System.out.println(JSONObject.toJSONString(result));
        if (result == null) return;

        // 样例：获取黑名单命中的数据
        List<BlackListDetail> find = result.find(BlackListDetail.class);
        for (BlackListDetail e : find) {
            List<BlackListHit> hits = e.getHits();
            for (BlackListHit hit : hits) {
                // hit中包含了命中黑名单的具体信息

            }
        }
    }


    public static void testWithProxy(){

        ProxyModel proxyModel = new ProxyModel("192.168.6.32", 8118, "http");
        RuleDetailClient client = RuleDetailClient.getInstance(partnerCode, Environment.PRODUCT, proxyModel);
        //或者: RuleDetailClient client =  RuleDetailClient.getInstance(partnerCode, Environment.PRODUCT, 1000,2000,50, "utf-8", proxyModel);
        RuleDetailResult result = client.execute(partnerKey, sequenceId);
        System.out.println(JSONObject.toJSONString(result));
        assert result != null;
    }

}
