package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.ProxyModel;
import cn.fraudmetrix.riskservice.object.RiskResult;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;


/**
 * 仅仅是决策引擎api调用demo
 */
public class RiskServiceDemo {

    // 填写参数
    static String partnerCode = "your partner code";
    static String secretKey = "your secret key";
    static String eventId = "your event id";

    public static void main(String[] argv) {
        // 填写参数
        testNormal();
        testWithProxy();
    }

    public static void testNormal(){

        // 调用接口
        RiskServiceClient client = RiskServiceClient.getInstance(partnerCode, Environment.PRODUCT);

        Map<String,String> params = new HashMap<String, String>();
        params.put("abc", "123");
        params.put("device_id", "456");
        RiskResult result = client.execute(secretKey, eventId,params);
        System.out.println(JSONObject.toJSONString(result));
    }



    public static void testWithProxy(){

        ProxyModel proxyModel = new ProxyModel("192.168.6.32", 8118, "http");
        RiskServiceClient client = RiskServiceClient.getInstance(partnerCode, Environment.PRODUCT, proxyModel);
        //或者: RiskServiceClient client =  RiskServiceClient.getInstance(partnerCode, Environment.PRODUCT, 1000, 2000, 50, null, proxyModel);
        Map<String,String> params = new HashMap<String, String>();
        params.put("abc", "123");
        params.put("device_id", "456");
        RiskResult result = client.execute(secretKey, eventId,params);
        System.out.println(JSONObject.toJSONString(result));
    }

}
