/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.ruledetail.parse;

import cn.fraudmetrix.riskservice.ruledetail.parse.FieldFormat;
import cn.fraudmetrix.riskservice.ruledetail.parse.FormatProvider;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicFieldFormat
implements FieldFormat {
    private static final Log logger = LogFactory.getLog(PublicFieldFormat.class);
    private FormatProvider format;
    private Type fieldType;
    private String fieldName;
    private Method setter;

    public PublicFieldFormat(FormatProvider format, Field field) {
        this.format = format;
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (isStatic) {
            return;
        }
        this.setter = this.getSetterMethod(field.getDeclaringClass(), field.getName(), field.getType());
        this.fieldType = field.getGenericType();
        this.fieldName = field.getName();
    }

    private Method getSetterMethod(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String methodName = this.getSetterMethodName(fieldName);
        try {
            return clazz.getMethod(methodName, fieldType);
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed to get setter method for field: " + fieldName), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void decodeField(JSONObject json, Object o) {
        if (json == null) {
            return;
        }
        if (o == null) {
            return;
        }
        if (this.setter == null) {
            return;
        }
        Object value = json.get((Object)PublicFieldFormat.underline(this.fieldName));
        if (value == null) {
            return;
        }
        Object after = this.format.getFormat(this.fieldType).decode(value);
        if (after == null) {
            return;
        }
        try {
            this.setter.invoke(o, after);
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed to invoke setter for " + this.fieldName), (Throwable)ex);
        }
    }

    private String getSetterMethodName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (fieldName.isEmpty()) {
            return "set";
        }
        return "set" + this.upperCaseFirst(fieldName);
    }

    private String upperCaseFirst(String fieldName) {
        String part2 = fieldName.substring(0, 1).toUpperCase();
        String part3 = fieldName.substring(1);
        return part2 + part3;
    }

    private static String underline(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                String s = str.substring(i, i + 1);
                if (c >= 'A' && c <= 'Z') {
                    sb.append("_").append(s.toLowerCase());
                    continue;
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }
}

