/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.ruledetail.parse;

import cn.fraudmetrix.riskservice.ruledetail.parse.SimpleLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyLoadMap<K, V> {
    private static final Log logger = LogFactory.getLog(LazyLoadMap.class);
    private Map<K, V> map = new ConcurrentHashMap();
    private Map<K, SimpleLock> creating = new ConcurrentHashMap<K, SimpleLock>();
    private Object CREATE_FAILED = new Object();

    public abstract V create(K var1);

    public V get(K key) {
        V r = this.getMayFailed(key);
        if (r == this.CREATE_FAILED) {
            return null;
        }
        return r;
    }

    private V getMayFailed(K key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.createKey(key);
    }

    private V createKey(K key) {
        this.createKeyNonExists(key);
        SimpleLock lock = this.creating.get(key);
        if (lock == null) {
            return this.map.get(key);
        }
        lock.waitUnlock();
        return this.map.get(key);
    }

    private V createNoException(K key) {
        try {
            V result = this.create(key);
            if (result == null) {
                return (V)this.CREATE_FAILED;
            }
            return result;
        }
        catch (Throwable t) {
            logger.warn((Object)("Failed to create key: " + key), t);
            return (V)this.CREATE_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeyNonExists(K key) {
        SimpleLock lock;
        LazyLoadMap lazyLoadMap = this;
        synchronized (lazyLoadMap) {
            if (this.map.containsKey(key)) {
                return;
            }
            if (this.creating.containsKey(key)) {
                return;
            }
            lock = new SimpleLock();
            this.creating.put(key, lock);
        }
        V created = this.createNoException(key);
        LazyLoadMap lazyLoadMap2 = this;
        synchronized (lazyLoadMap2) {
            this.map.put(key, created);
            lock.unlock();
            this.creating.remove(key);
        }
    }
}

