package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecodeJavaBeanViaConstructor implements Convert {

    private static final Log        logger = LogFactory.getLog(DecodeJavaBeanViaConstructor.class);

    private final FormatProvider    format;
    private final List<FieldFormat> fieldFormats;
    private final Constructor       constructor;

    public DecodeJavaBeanViaConstructor(FormatProvider format, Class<?> sourceType){
        this.format = format;

        // 根据原始数据类型保存JavaBean的创建方法
        this.constructor = getConstructor(sourceType);

        // 根据每个字段获取字段生成格式
        List<FieldFormat> fieldFormats = createFieldFormatsIncludeSuper(sourceType);
        this.fieldFormats = Collections.unmodifiableList(fieldFormats);
    }

    private List<FieldFormat> createFieldFormatsIncludeSuper(Class<?> clazz) {
        List<FieldFormat> result = new ArrayList<FieldFormat>();
        while (clazz != null) {
            List<FieldFormat> sub = createFieldFormats(clazz);
            result.addAll(sub);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List<FieldFormat> createFieldFormats(Class<?> sourceType) {
        Field[] fields = sourceType.getDeclaredFields();
        List<FieldFormat> result = new ArrayList<FieldFormat>();
        for (Field field : fields) {
            FieldFormat fieldFormat = format.getFieldFormat(field);
            if (fieldFormat == null) continue;
            result.add(fieldFormat);
        }
        return result;
    }

    @Override
    public Object run(Object o) {
        // 输入参数要求是JSONObject
        if (o == null) return null;
        if (!(o instanceof Map)) return null;
        JSONObject json = new JSONObject((Map) o);

        // 创建一个实例，如果创建失败就返回null
        Object instance = newInstance();
        if (instance == null) return null;

        // 分别储存每个字段
        for (FieldFormat e : fieldFormats) {
            if (e == null) continue;
            e.decodeField(json, instance);
        }

        // 返回组装好的实例
        return instance;
    }

    private Constructor getConstructor(Class<?> sourceType) {
        try {
            Constructor result = sourceType.getConstructor();
            return result;
        } catch (Exception ex) {
            logger.warn("Failed to get constructor for JavaBean", ex);
            return null;
        }
    }

    private Object newInstance() {
        if (constructor == null) return null;
        try {
            return constructor.newInstance();
        } catch (Exception ex) {
            logger.warn("Failed to create JavaBean from constructor", ex);
            return null;
        }
    }
}
