/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    SANDBOX("https://apitest.tongdun.cn/riskService", "https://apitest.tongdun.cn/risk/rule.detail/v3"),
    STAGING("https://apistg.tongdun.cn/riskService", "https://apistg.tongdun.cn/risk/rule.detail/v3"),
    PRODUCT("https://api.tongdun.cn/riskService", "https://api.tongdun.cn/risk/rule.detail/v3"),
    CUSTOM(null, null);

    private String apiUrl;
    private String ruleDetailUrl;

    private Environment(String apiUrl, String ruleDetailUrl) {
        this.apiUrl = apiUrl;
        this.ruleDetailUrl = ruleDetailUrl;
    }

    public Environment withApiUrl(String apiUrl) {
        if (null == this.apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }
        throw new UnsupportedOperationException("You can only set apiUrl for CUSTOM mode.");
    }

    public String getApiUrl() {
        if (null == this.apiUrl) {
            throw new IllegalStateException("You have to set apiUrl for CUSTOM mode first!");
        }
        return this.apiUrl;
    }

    public void setRuleDetailUrl(String x) {
        this.ensureCustomEnvironment();
        this.ruleDetailUrl = x;
    }

    public String getRuleDetailUrl() {
        if (this.ruleDetailUrl == null) {
            throw new IllegalStateException("You have to set url for CUSTOM mode first!");
        }
        return this.ruleDetailUrl;
    }

    private void ensureCustomEnvironment() {
        if (this != CUSTOM) {
            throw new UnsupportedOperationException("You can only set url for CUSTOM mode.");
        }
    }
}

